/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: TOUPPERX.C $
   $Locker:  $	$Name:  $	$State: Exp $

	Functions:	toUpper(), toFUpper(), rereadUpcaseTable()

	Comments:

	int toUpper(int ch)

	Upcases ((unsigned char)ch) via the DOS NLS functions for normal
	characters. This function should be replaced when the locale
	support becomes widely available.

	There is no toLower(), because the DOS NLS API only supports
	upcasing.

	Return:
		The character in upper-case (always 0..255).

	void rereadUpcaseTable(void)

	Causes that toUpper() re-retreives the upcase table again.

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <dos.h>
#include <ctype.h>
#else
#include <intr.h>
#endif
#include <portable.h>
#include "suppl.h"
#include "dynstr.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: TOUPPERX.C 1.5 1998/08/19 06:32:54 ska Exp $";
#endif

static dword upcaseCTable;			/* upcase table for characters */
static unsigned tblCLength = 0;		/* no table at this time */
static dword upcaseFTable;			/* upcase table for filename characters */
static unsigned tblFLength = 0;		/* no table at this time */

void rereadUpcaseTable(void)
{	tblFLength = tblCLength = 0;
}

static void getUpcaseTable(unsigned *tblLength, dword *upTable)
{	IREGS r;
#ifndef _MICROC_
	byte tbl[5];
#define xsegm *(word*)&tbl[3]
#define xofs *(word*)&tbl[1]

#else
	struct {
		byte t_fct;
		word t_ofs;
		word t_seg;
	} tbl;
#define xsegm tbl.t_seg
#define xofs tbl.t_ofs
#endif

	/* First: get the pointer to the upcase table */
	r.r_ax = 0x6502;
	r.r_es = FP_SEG(tbl);
	r.r_di = FP_OFF(tbl);
	r.r_bx = r.r_dx = 0xFFFF;
	r.r_cx = sizeof(tbl);
	if(!invokeDOS(aS(r))) {
		*tblLength = peekw(xsegm, xofs) + 0x80;
#ifdef _MICROC_
		setDWP(upTable, tbl.t_seg, tbl.t_ofs - 0x80 + 2);
#else
		*upTable = *(dword*)&tbl[1] - 0x80 + 2;
#endif
	}
	else			/* get failed -> use empty table */
		*tblLength = 0x7F;
}

static int toMUpper(int ch, word *tblLength, dword *upTable)
{

	if(!*tblLength) getUpcaseTable(tblLength, upTable);

	return ((ch = ch & 0xFF) < 0x80 || *tblLength < ch)
		? toupper(ch)		/* this is the standard case */
		: peekb(DWP_HI(nM(*)upTable), DWP_LO(nM(*)upTable) + ch);
}

int toFUpper(int ch)
{	return toMUpper(ch, &tblFLength, aS(upcaseFTable));
}

int toUpper(int ch)
{	return toMUpper(ch, &tblCLength, aS(upcaseCTable));
}
