/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: STPCPY.C $
   $Locker:  $	$Name:  $	$State: Exp $

	stpcpy(char *dst, char *src)

	Copy src onto dst

	Return a pointer to the '\0' of dst

   Target compilers: Pacific C v7.51

*/

#include "initsupl.inc"

#ifdef COMPILE
#undef COMPILE
#endif

#ifdef _PAC_NOCLIB_
#define COMPILE
#endif
#ifdef __WATCOMC__
#define COMPILE
#endif

#ifdef COMPILE
#include <portable.h>

char *stpcpy(char * const dst, const char * const src)
{	register char *p;
	register const char *q;

	p = dst - 1;
	q = src - 1;
	while(*++p = *++q);
	return p;
}

#endif
