;	Pacific C ^Break catcher 
;	Small code & small data version
; See cb_catch.asm for more details

	.globl	small_data
	.globl	small_code
	.psect	_TEXT,class=CODE
	.globl	__fct_cbreak
	.globl	__cbreak_catcher_ss
	.globl	_exit

__cbreak_catcher_ss:
		push bx
		push cx
		push dx
		push di
		push si
		push ds
		push es
		push bp
		push ax
		mov ax, ss			; /* under Micro-C always SS == DS */
		mov ds, ax
		mov ax, __fct_cbreak
		or ax, ax
		je cbreak1_catcher
		call ax
		or ax, ax			; /* continue with program? */
		jne cbreak1_catcher
		; /* terminate the program, that's a bit of a problem, because */
		; /* MS built in some interesting stuff to make their DOS */
		; /* incompatible with DR DOS and Novell DOS. Therefore we don't */
		; /* let DOS terminate our program, but we terminate it ourselves */
		; /* with the exit code 3. That won't inform the caller, that */
		; /* we terminated because of ^C and probably leads to misinterpretation */
		; /* of the exit code. */
		; /* To let DOS terminate the program, change: */
		; /*	 1) in this branch: only set the Carry flag (stc). */
		; /*	 2) Replace the iret by retf (NOT retf 2!). */

		mov dx, #3		; PAC passes the leftmost argument within DX
		call _exit

cbreak1_catcher:
		pop ax
		pop bp
		pop es
		pop ds
		pop si
		pop di
		pop dx
		pop cx
		pop bx
		iret				; /* continue with the program */
	.end
