/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/*  $Header: D:/FREEDOS/SRC/LIB/SUPPL/RCS/MCB_LENG.C 2.3 1998/08/05 09:42:22 ska Exp $
 *
 *  MCB_LENG.C - Memory Control handling
 *
 *	Functions: mcb_length()
 *
 *  Comments:
 *
 *	unsigned mcb_length(unsigned segm);
 *	Return the length of the segment segm in bytes. If the segment is
 *	larger than (64KB - 1) bytes, the function will always return 0xFFFFu.
 *	If segm == 0 (no segment is given), the function returns 0x0000.
 *
 	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

 *  01/29/96 (Steffen Kaiser) -----------------------------------------------
 *    started.
 *
 */

#include "initsupl.inc"

#ifndef _MICROC_
#include <dos.h>
#endif
#include <portable.h>
#include "mcb.h"

unsigned mcb_length(const unsigned segm)
/* Return the length of the memory block starting at segm */
{	unsigned length;

	if(segm == 0)			/* security value */
		return 0;

	length = peekw(SEG2MCB(segm), OFF_MCB_SIZE);	/* length of block in paras */

	return length >= 4096?	/* someone thinks, he can increase his env endlessly */
		0xffff: length << 4;
}
