/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: MCB_APAR.C $
   $Locker:  $	$Name:  $	$State: Exp $

	unsigned mcb_allParents(unsigned mcb, MCB_WALKFUNC fct, void *arg)

	Launch "(*fct)(arg, mcb)" for all parents (excluding the process mcb
	itself). The argument mcb is the MCB of the particular process.
	(*fct) must return != 0, if the walk process shall be terminated.
	The walk terminates, when a shell is reached.

	If mcb is 0, _psp is used, otherwise it is checked via "isPSP(mcb)",
	if this is (possibly) a PSP.

	Return:	  -1: MCB chain or something else corrupted (e.g. mcb was
					no PSP)
			   0: shell reached, but function didn't terminate
			else: function terminated walk process

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <dos.h>
#endif
#include <portable.h>
#include "mcb.h"

int mcb_allParents(unsigned mcb, MCB_WALKFUNC fct, void *arg)
{	unsigned mcb1;

	if(mcb) {
		if(!isPSP(mcb)) return -1;
	}
	else mcb = _psp;

	do {
		if((mcb1 = peekw(mcb, SEG_OFFSET + 0x16)) == mcb)
			return 0;		/* no parent process */
		if((mcb1 = (*fct)(arg, mcb = mcb1)) != 0)	/* function terminates */
			return mcb1;
	} while(mcb > 0x40);

	return -1;
}
