/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: LONGADDU.C $
   $Locker:  $	$Name:  $	$State: Exp $

	longaddu(num1, unsigned num2)

	add the unsigned num2 to the dword num1
	Micro-C only.

	Return:
		== 0: No overflow
		!= 0: otherwise

*/

#include "initsupl.inc"

#ifdef _MICROC_

#include "suppl.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: LONGADDU.C 2.3 1998/08/19 02:40:21 ska Exp $";
#endif

longaddu(/*dword **/num, /*unsigned*/ n)
{	LSIZE / 2;
	asm {
		mov cx, ax
		mov bx, 6[bp]		; address of number
		mov ax, 4[bp]		; number to add to
		add [bx], ax
		mov ax, 0
		jnc addu1			; no overflow
		inc bx
	addu2:
		inc bx
		inc Byte Ptr [bx]	; add carry
		loope addu2
		jne addu1			; no overflow?
		inc al				; overflow
	addu1:
	}
	return;
}
#endif

