/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: INVOKEDO.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int invokeDOS(struct REGPACK *prp)

	Invoke DOS using intr(0x21, prp).

	Return:
		 0: DOS returned with Carry flag cleared
		!0: AX value (DOS error code) if DOS returned with Carry flag set

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifdef _MICROC_
#include <intr.h>
#else
#include <dos.h>
#endif
#include <portable.h>
#include "suppl.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: INVOKEDO.C 1.5 1998/08/19 06:32:54 ska Exp $";
#endif

int invokeDOS(IREGS *prp)
{	intrpt(0x21, prp);
	return (prp->r_flags & 1)? prp->r_ax: 0;
}
