/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: FMEMOVE.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int _fmemmove(dseg, dofs, sseg, sofs, length)

	Copy the memory area sseg:sofs to dseg:dofs and handle overlapped
	areas correctly.

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifdef _MICROC_
#include <portable.h>
#include "fmemory.h"

int _fmemmove(unsigned dseg, unsigned dofs
 , unsigned sseg, unsigned sofs, unsigned length)
{	unsigned seg, ofs;

	if(!length)
		return;

	/* 1st: normalize pointers for compare */
	_fnormalize(dseg, dofs);
	_fnormalize(sseg, sofs);

	if(sseg == dseg && sofs == dofs)
		return;

	seg = sseg;				/* end of source area */
	ofs = sofs + length;
	_fnormalize(seg, ofs);

	/* 2nd: check, if the areas overlap and if this matters at all */
	/* Bad results will occur, if sseg:sofs < dseg:dofs < seg:ofs */
	if(_fcompare(sseg, sofs, dseg, dofs) < 0
	 && _fcompare(dseg, dofs, seg, ofs) <= 0) {	/* perform manually */
	 	dofs += length;		/* both point behind the areas now */
	 	sofs += length;
		do pokeb(dseg, --dofs, peekb(sseg, --sofs));
		while(--length);
	}
	else _fmemcpy(dseg, dofs, sseg, sofs, length);
}

#else
#ifdef _PAC_NOCLIB_
#include <portable.h>
#include "fmemory.h"

void _fmemmove(void far * const s1, const void far * const s2
	, unsigned length)
{	byte far *p;
	byte far *q;
	byte far *h;

	if(!length)
		return;

	p = _fnormalize(s1);
	q = _fnormalize(s2);
	h = _fnormalize(p + length);

	if(p < q && h >= q) {		/* overlapping areas */
		p += length;
		q += length;
		do *--p = *--q;
		while(--length);
	}
	else
		_fmemcpy(s1, s2, length);
}
#endif
#endif
