/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: FILEFIND.C $
   $Locker:  $	$Name:  $	$State: Exp $


	int findfirst(const char * const pattern, struct ffblk *ff, int attrib);
	Initiate file search
	Return:	0 on success

	int findnext(struct ffblk *ff);
	Next file search
	Return:	0 on success

	Pacific C only

*/

#include "initsupl.inc"

#ifdef _PAC_NOCLIB_
#include "suppl.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: FILEFIND.C 1.2 1998/08/19 07:26:56 ska Exp $";
#endif

int findfirst(const char * const pattern, struct ffblk *ff, int attrib)
{	void far *dta;
	IREGS r;
	int rv;

	dta = getdta();
	setdta((void far*)ff);
	r.r_dx = FP_OFF(pattern);
	r.r_ds = FP_SEG(pattern);
	r.r_cx = attrib;
	r.r_ax = 0x4e00;
	rv = invokeDOS(&r);

	setdta(dta);

	return rv;
}
	
int findnext(struct ffblk *ff)
{	void far *dta;
	IREGS r;
	int rv;

	dta = getdta();
	setdta((void far*)ff);
	r.r_ax = 0x4f00;
	rv = invokeDOS(&r);

	setdta(dta);

	return rv;
}

#endif
