/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: ENV_SCPY.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int env_strcpy(word segm, char buf[], const int len, const int stringNr)

	Copies the stringNr'th string (1st string is 0) of the environment
	segm into the buffer buf with the length len.

	If segm == 0, the current used environment is processed.

	Return:
		0:	OK
		1:	stringNr too high
		2:	buffer to small the hold the complete string, partially filled
		3:	no environment

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <string.h>
#include <dos.h>
#endif
#include "environ.h"
#include "fmemory.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: ENV_SCPY.C 2.5 1998/08/19 02:40:21 ska Exp $";
#endif

int env_strcpy(word segm, char buf[], const int len, const int stringNr)
{	word ofs;

	if(!segm && !(segm = env_glbSeg))
		return 3;						/* no environment at all */

	if(!(ofs = env_string(segm, stringNr))
	 || ofs == env_firstFree(segm))
		return 1;						/* string number too high */

	_fmemcpy(TO_FP(buf), MK_FP(segm, ofs), len);
	buf[len - 1] = '\0';	/* Make sure that the string is terminated */

	return ((strlen(buf) < len - 1) || !peekb(segm, ofs + len - 1))? 0: 2;
}
