/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: ENV_SCNT.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int env_strings(word segm, int diff)

	Modifies the counter of strings appended to the environment.

	Return the resulting counter.
	Return 0 indicates either no environment at all or no string.

	If segm == 0, the current used environment is processed.

   Target compilers: Micro-C; Borland C v2.0, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <dos.h>
#endif
#include "environ.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: ENV_SCNT.C 1.4 1998/08/19 02:40:21 ska Exp $";
#endif

int env_strcounter(word segm, int diff)
{	word cntOfs;

	if(!segm && !(segm = env_glbSeg)) return 0;

	diff += peekw(segm, cntOfs = env_endOfVars(segm) + 1);
	pokew(segm, cntOfs, diff);

	return diff;
}
