/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/*  $Header: D:/FREEDOS/SRC/LIB/SUPPL/RCS/ENV_REPL.C 1.3 1998/08/05 09:42:22 ska Exp $
 *
 *  ENV_REPL.C - part of the enviroment handling.
 *
 *	Functions: env_replace()
 *
 *  Comments:
 *
 *	unsigned env_replace(unsigned env, int mode [, unsigned segm/length] )
 *	Replace the (old) environment env. How is controlled by mode:
 *		ENV_DELETE: Delete segment env
 *		ENV_COPY: Copy the contents of the old env into the new env
 *			If the new env is smaller than the old one, the contents
 *			could be destroyed.
 *		ENV_CLEAR: Initialize the new env (no vars, no strings)
 *			ENV_COPY superceeds this flag.
 *		ENV_CREATE: Create a new environment, in this case, length is
 *			provided as argument.
 *		ENV_FREECOUNT: Only applicable with ENV_CREATE set, this means that
 *			the length specifies the amount of unused bytes in the new env.
 *			ENV_LIMITED superceeds this flag.
 *		ENV_LIMITED: Only applicable with ENV_CREATE set, limit the length
 *			of the created environment to the lowest possible one. This value
 *			is 4, if ENV_COPY is not set; env_firstFree(env), otherwise.
 *			The third argument need not to be specified.
 *
 *	env and segm must not be equal. That also applies to the case when one
 *	of them is 0 (zero) and the other the current used environment.
 *
 *	To duplicate an environment use:
 *		newEnvSeg = env_replace(oldEnvSeg? oldEnvSeg: env_glbSeg
 *			, ENV_CREATE | ENV_FREECOUNT | ENV_COPY, 0)
 *						-or-
 *		newEnvSeg = env_replace(oldEnvSeg? oldEnvSeg: env_glbSeg
 *			, ENV_CREATE | ENV_LIMITED | ENV_COPY)
 *	latter resizes the environment to the lowest possible; the first statement
 *	won't shrink the environment.
 *	Note: Without "?:" construct in the 1st argument and if the 1st arg is
 *		zero, on success the current used environment is changed to the
 *		returned segment.
 *
 *	If env == 0 (current used environment) and the operation is successful,
 *	the current used environment is updated to segm (the return value).
 *	If the original environment segment is not deleted by the ENV_DELETE
 *	option or saved prior and deleted manually, this chunk of memory is
 *	lost. In some cases this chunk is also not free'ed by DOS, when the
 *	program is terminated.
 *
 *	Return: Either segm or the environment newly created.
 *			0: on failure
 *	
 	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

 *  01/29/96 (Steffen Kaiser) -----------------------------------------------
 *    started.
 *
 */

#include "initsupl.inc"

#ifndef _MICROC_
#include <dos.h>
#include <string.h>
#endif
#include <portable.h>
#include "mcb.h"
#include "suppl.h"
#define NO_ENV_REPLACE_PROTOTYPE
#include "environ.h"		/* don't include the prototype og env_replace() */
#include "fmemory.h"

#ifdef _MICROC_
register unsigned env_replace(unsigned XOenv /*, int mode, unsigned segm/length*/)
#else
unsigned env_replace(unsigned Oenv, int mode, unsigned Xsegm)
#endif
{	unsigned env, segm;
#define length segm

#ifdef _MICROC_
	unsigned Oenv, mode;

	env = nargs() * 2 + &XOenv;
	Oenv = *(unsigned *)env;
	mode = ((unsigned *)env)[1];
	segm = ((unsigned *)env)[2];
#else
	segm = Xsegm;				/* ensure that this parameter is valid */
#endif

	if(!(env = Oenv) && !(env = env_glbSeg))
		return 0;		/* no source environment */

	if(mode & ENV_CREATE) {		/* create a new environment */
		if(mode & ENV_LIMITED)
			length = env_firstFree(env);
		else if(mode & ENV_FREECOUNT) {
			if(addu(&length, env_firstFree(env)))
				return 0;
		}
		if(!(segm = env_create(length)))
			return 0;
	}
	else						/* the 3rd argument is a segment */
		if(!segm && !(segm = env_glbSeg) || segm == env)
			return 0;

	if(mode & ENV_COPY)
#ifndef _MICROC_
#ifdef min
#undef min
#endif
#define min(a,b) (((a)<(b))?(a):(b))
#endif
		_fmemcpy(MK_FP(segm, 0), MK_FP(env, 0)
		 , min(mcb_length(segm), mcb_length(env)));
	else if(mode & ENV_CLEAR)
		poked(segm, 0, 0);		/* the first 3 bytes must be zero */

	if(mode & ENV_DELETE)
		env_delete(env);

	if(!Oenv) env_setGlbSeg(segm);

	return segm;
}
