/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: ENV_NOSP.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int env_noSpace(word segm, const char name[], const char value[], const word ign)

	Checks if the segment segm has enough free space to hold the
	variable "name=value". The amount of ign bytes are assumed to
	be additionally free.

	If segm == 0, the current used environment is used.
	name and value may be == NULL.

	Return:
		0: Enough space
		1: No space
		4: No environment at all

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <dos.h>
#include <string.h>
#endif
#include <portable.h>
#include "environ.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: ENV_NOSP.C 1.4 1998/08/19 02:40:21 ska Exp $";
#endif

int env_noSpace(word segm, const char name[], const char value[], const word ign)
{	int needSpace;

	if(!segm && !(segm = env_glbSeg))
		return 4;

	return (needSpace = (name? strlen(name): 0) + (value? strlen(value): 0) + 2) > ign
	 && env_freeCount(segm) < needSpace - ign;
}
