/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: ENV_NEW.C $
   $Locker:  $	$Name:  $	$State: Exp $

	env_create(unsigned length)

	Create a new environment with at least length bytes.

	Return:	0: allocation failed
			!0: segment address

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#include <portable.h>
#include "environ.h"
#include "suppl.h"

word env_create(const unsigned length)
{	word segm;
	int allocMode;

	if(length == 0)
		return 0;

	switch(env_resizeCtrl & (ENV_FIRSTFIT | ENV_LASTFIT)) {
		case ENV_FIRSTFIT:	allocMode = 0; break;/* first fit */
		case ENV_LASTFIT:	allocMode = 2; break;/* last fit */
		default:			allocMode = 1; break;/* best fit */
	}

	/* try to allocate block in the UMBs */
	if(!(env_resizeCtrl & ENV_USEUMB)
	 || (segm = allocBlk(length, allocMode | 0x40)) == 0)
		segm = allocBlk(length, allocMode);	/* try the low memory */

	if(segm)	poked(segm, 0, 0);	/* initialize to an unused environment */

	return segm;
}
