/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/*  $Header: D:/FREEDOS/SRC/LIB/SUPPL/RCS/ENV_LEN.C 2.3 1998/08/05 09:42:22 ska Exp $
 *
 *  ENV_LEN.C - part of the enviroment handling.
 *
 *	Supplemental functions shared by several environment functions.
 *
 *  unsigned env_varlen(unsigned segm, unsigned offset)
 *  Return the number of bytes allocated by the variable at this
 *  position.
 *
 *	segm must not be zero.
 *
 	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

 *  01/29/96 (Steffen Kaiser) -----------------------------------------------
 *    started.
 *
 */

#include "initsupl.inc"

#ifndef _MICROC_
#include <dos.h>
#include <string.h>
#endif
#include <portable.h>
#include "environ.h"
#include "fmemory.h"

unsigned env_varlen(const unsigned segm, const unsigned offset)
/* Return the length of the string at segm:offset */
{	return _fstrlen(MK_FP(segm, offset)) + 1;
}
