/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: ENV_FORA.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int env_forAll(env, fct, arg)

	fct is a pointer to a function of the type:
		int (*fct)(void *arg, unsigned env, unsigned ofs)
	where arg is arg of env_forAll() and env:ofs is the address of the
	current variable (start of its name).

	fct() is called once for each variable. This loops terminates, if
	there is no next variable or if fct() returns != 0.

	If env is 0, the current local environment is used, otherwise,
	env is considered to be an initalized environment segment.

	Return:	 0: all variables done (function never hit).
			-1: environment corrupted or no environment at all
		  else: function cancelled walk process.

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <dos.h>
#endif
#include <portable.h>
#include "environ.h"

int env_forAll(unsigned env, ENV_WALKFUNC fct, void *arg)
{	unsigned ofs, retVal;

	if((!env && !(env = env_glbSeg)) || !fct) return -1;

	for(ofs = 0; peekb(env, ofs); ofs += env_varlen(env, ofs)) {
		if((retVal = (*fct)(arg, env, ofs)) != 0)	/* call function & break */
			return retVal;
	}

	return 0;
}

