/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/*  $Header: D:/FREEDOS/SRC/LIB/SUPPL/RCS/ENV_ADD.C 2.3 1998/08/05 09:42:22 ska Exp $
 *
 *  ENV_ADD.C - part of the enviroment handling.
 *
 *	Supplemental function shared by several environment functions.
 *
 *	int env_addVar(unsigned segm, char *name, char *value);
 *	Append a new variable with the name and value.
 *
 *	segm must not be zero!
 *
 *  Return:	0: failed
 *			1: OK
 *
 	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

 *  01/29/96 (Steffen Kaiser) -----------------------------------------------
 *    started.
 *
 */

#include "initsupl.inc"

#ifndef _MICROC_
#include <dos.h>
#include <string.h>
#endif
#include <portable.h>
#include "environ.h"
#include "fmemory.h"

int env_addVar(const unsigned segm, const char name[], const char value[])
{	unsigned endOff, firstFree;
	int lenN, lenV, lenG;

	if(env_freeCount(segm)
	 < (lenG = (lenN = strlen(name)) + (lenV = strlen(value)) + 2)
	  || lenG <= 1)		/* longer than 32KB */
		return 0;		/* sorry, no space free in the env seg */

	/* 1) move the string table out of the way */
	firstFree = env_firstFree(segm);
	endOff = env_endOfVars(segm);

	_fmemmove(MK_FP(segm, endOff + 1 - 1 + lenG), MK_FP(segm, endOff + 1 - 1)
	 , firstFree - (endOff + 1) + 1);	/* move the var space terminator, too */

	/* 2) move the variable */
	_fmemcpy(MK_FP(segm, endOff), TO_FP(name), lenN);
	_fmemcpy(MK_FP(segm, endOff + 1 + lenN), TO_FP(value), lenV + 1);
	pokeb(segm, endOff + lenN, '=');

	return 1;
}
