/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: DTA.C $
   $Locker:  $	$Name:  $	$State: Exp $

	void far *getdta(void);
	Return current working DTA

	void setdta(void far *dta);
	Set current working DTA

*/

#include "initsupl.inc"

#ifdef _PAC_NOCLIB_
#include <suppl.h>

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: DTA.C 1.1 1998/08/05 09:42:22 ska Exp $";
#endif

void far *getdta(void)
{
#asm
	mov ah, #2fh
	int #21h
	mov ax, es
	mov dx, ax
	mov ax, bx
#endasm
}

void setdta(void far *dta)
{
#asm
	push ds
#if SMALL_CODE
	mov dx, 4[bp]
	mov ds, 6[bp]
#else
	mov dx, 6[bp]
	mov ds, 8[bp]
#endif
	mov ah, #1ah
	int #21h
	pop ds
#endasm
}

#endif
