/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: DSTRMID.C $
   $Locker:  $	$Name:  $	$State: Exp $

	char *StrMiddle(char s[], unsigned pos, unsigned length)

	Return the length characters of a string beginning with the pos'th
	character. The first character has the position 0 (zero).

	If strlen(s) < pos, "" is returned.
	If strlen(s) < pos + length, StrTail(pos) is returned.

	s may be NULL.

	Return:
		NULL: s==NULL, malloc() failed
		else: pointer to the malloc()'ed string

	Target compilers: Micro-C, Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <string.h>
#include <stdlib.h>
#endif
#include <portable.h>
#include "dynstr.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: DSTRMID.C 1.3 1998/08/19 02:40:21 ska Exp $";
#endif

char *StrMiddle(const char s[], unsigned pos, unsigned length)
{	unsigned l;
	char *h;

	if(!s) return NULL;

	if((l = (unsigned)strlen(s)) <= pos)
		return strdup("");

	if(l - pos < length)
		return StrTail(s, pos);

	if((h = malloc(length + 1)) != NULL) {
		memcpy(h, s + pos, length);
		h[length] = NUL;
	}

	return h;
}
