/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: DSTRLEFT.C $
   $Locker:  $	$Name:  $	$State: Exp $

	char *StrLeft(char s[], unsigned length)

	Return the left length characters of s.

	If strlen(s) < length, the string is duplicated.

	s may be NULL.

	Return:
		NULL: s==NULL, malloc() failed
		else: pointer to the malloc()'ed buffer

	Target compilers: Micro-C, Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <stdlib.h>
#include <string.h>
#endif
#include <portable.h>
#include "dynstr.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: DSTRLEFT.C 1.3 1998/08/19 02:40:21 ska Exp $";
#endif

char *StrLeft(const char s[], unsigned length)
{	char *h;
	unsigned l;

	if(!s) return NULL;

	if((l = (unsigned)strlen(s)) < length)
		length = l;

	if((h = malloc(length + 1)) != NULL) {
		memcpy(h, s, length);
		h[length] = NUL;
	}

	return h;
}
