/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: DSTRCMPF.C $
   $Locker:  $	$Name:  $	$State: Exp $

	int _fStriCmp(dseg, dofs, sseg, sofs)

	Compares the strings at sseg:sofs and dseg:dofs, case-insensitive using
	toUpper().

	Returns: == 0: both strings are equal
			  > 0: 1st string > 2nd string (or longer)
			  < 0: 1st string < 2nd string (or smaller)

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <dos.h>
#endif
#include <portable.h>
#include "dynstr.h"

int _fStriCmp(unsigned const dseg, unsigned dofs
 , unsigned const sseg, unsigned sofs)
{	int d;
	char c;

	while((d = (c = toUpper(peekb(dseg, dofs++)))
	 - toUpper(peekb(sseg, sofs++))) == 0 && c);

	return d;
}
