/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: DSTRCAT.C $
   $Locker:  $	$Name:  $	$State: Exp $

	char *StrCat_(char *dest[], char src[])

	Append the string src[] at dest.
	If src == NULL, this function performs no action.
	If *dest == NULL, this functions performs StrCpy_(dest, src)

	Return:
		NULL: malloc() failed; *dest is unchanged
		else: *dest

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <string.h>
#include <stdlib.h>
#endif
#include <portable.h>
#include "dynstr.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: DSTRCAT.C 1.4 1998/08/19 02:40:21 ska Exp $";
#endif

char *StrCat_(char *dest[], const char src[])
{	char *h, *p;

	if(!src) return *dest;

	if((p = *dest) == NULL)
		return *dest = strdup(src);

	if((h = realloc(p, strlen(p) + strlen(src) + 1)) == NULL)
		return NULL;

	return strcat(*dest = h, src);
}
