/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: DSTRAPPC.C $
   $Locker:  $	$Name:  $	$State: Exp $

	char *StrAppChr_(char *dest[], char chr)

	Append a single character to the string *dest.

	chr may be NUL.
	*dest may be NULL.

	Return:
		NULL: malloc() failed; *dest unchanged
		else: pointer to the malloc()'ed buffer; original *dest free()'ed

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <string.h>
#endif
#include <portable.h>
#include "dynstr.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: DSTRAPPC.C 1.4 1998/08/19 02:40:21 ska Exp $";
#endif

char *StrAppChr_(char *dest[], char chr)
{	static char appBuf[] = " ";

	if((*appBuf = chr) != NUL) {
		if(!StrCat_(dest, appBuf))
			return NULL;
	}

	return *dest;
}
