/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/*  $Header: D:/FREEDOS/SRC/LIB/SUPPL/RCS/DOSALLOC.C 2.4 1998/08/05 09:42:22 ska Exp $
 *
 *  DOSALLOC.C - part of the enviroment handling.
 *
 *	Functions: DOSalloc()
 *
 *  Comments:
 *
 *	word DOSalloc(word length, int mode)
 *
 *	Allocates a chunk of memory directly va the DOS API.
 	The name field of the MCB is updated.

 	length: Length of the requested block in paragraphes (16 bytes each).
 	mode:	Allocation strategy:
		0x00 low memory first fit
		0x01 low memory best fit
		0x02 low memory last fit
		0x0F use current allocation strategy
		0x40 high memory first fit
		0x41 high memory best fit
		0x42 high memory last fit
		0x80 first fit, try high then low memory
		0x81 best fit, try high then low memory
		0x82 last fit, try high then low memory
		0x8F make high memory accessable, but don't change startegy

		If the bit 0x10 is set, the maximal allocateable block size
		is returned.

	Return:		0: allocation failed
				else: the segment address of the allocated block or, if
					the bit 0x10 of mode was set, the number of paragraphes
					of the largest unallocated block of DOS memory.

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

 *
 */

#include "initsupl.inc"

#ifndef _MICROC_
#include <dos.h>
#include <string.h>
#endif
#include <portable.h>
#include "suppl.h"
#include "mcb.h"
#include "fmemory.h"

word DOSalloc(word length, int mode)
{	int UMBLink, allocStrat;
	USEREGS

	if(mode & (0x40 | 0x80)) {	/* UMBs have to be linked in */
		_AX = 0x5802;		/* Get UMB LInk State */
		geninterrupt(0x21);	/* This fails prior DOS 5 */
		UMBLink = _AL;
		if(_CFLAG) 		/* no UMBs */
			UMBLink = 1, 	/* disables the UMB Unlink call */
			mode &= 0xF;	/* Disables side effects with elder DOSs */
		else {
			if(!UMBLink) {		/* UMBs need to be linked in */
				_BX = 1;		/* Link in UMBs */
				_AX = 0x5803;	/* Set UMB Link State */
				geninterrupt(0x21);
			}
		}
	}

	if((mode & 0xF) != 0xF) {
	/* allocate the block, with the specified mode
		--> save the old allocation mode */
		_AX = 0x5800;						/* Get Allocation Strategy */
		geninterrupt(0x21);
		allocStrat = _AL;
		if(_CFLAG)						/* MCB chain destroyed */
			length = 0;
		else {
			_BX = mode & ~0x10;				/* allocation strategy to set */
			_AX = 0x5801;					/* Set Allocation Strategy */
			geninterrupt(0x21);
		}
	}
	
	if(length) {
		/* now, try to allocate the block */
		_BX = (mode & 0x10)? 0xFFFF: length;	/* size of block */
		_AH = 0x48;								/* Allocate Memory Block */
		geninterrupt(0x21);
		length = _AX;
		if(_CFLAG)
			length = (mode & 0x10)? _BX: 0;	/* allocation failed */
		else					/* allocation OK; update name field */
			_fmemcpy(MK_FP(SEG2MCB(length), OFF_MCB_NAME)
			 , MK_FP(SEG2MCB(_psp), OFF_MCB_NAME), 8);

		if((mode & 0xF) != 0xF) {
		/* reset allocation strategy */
			_BX = allocStrat;
			_AX = 0x5801;
			geninterrupt(0x21);
		}
	}

	/* reset UMBLink state */
	if(!UMBLink) {
		_BX = 0;								/* Unlink UMBs from chain */
		_AX = 0x5803;
		geninterrupt(0x21);
	}

	return length;		/* allocated block */
}
