/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: DFNTRUEN.C $
   $Locker:  $	$Name:  $	$State: Exp $

	char *dfntruename(const char fn[])

	Return the truename of the file named fn.

	The truename of a file is a fully-qualified filename according
	the _physical_ access path. That means that the truename can be
	used to exactly determine, if two file specifications match the
	same physical file, e.g.:
			SUBST Z: C:\FREEDOS
		&& C:\FREEDOS\SUBST.EXE exists
		&& the current working directory is C:\FREEDOS ==>
			dfntruename("a:/subst.exe") --> "C:\\FREDOS\\SUBST.EXE"
			dfntruename("subst.exe") --> "C:\\FREEDOS\\SUBST.EXE"
	
	Return:
		NULL: malloc() failed, or DOS API call failed
		else: pointer to the malloc()'ed string

	But beware! The truename must not be used as a function to fully-qualify
	a filename. There are at least two cases when that fails:
		1)		JOIN A: C:\LW-A
			==>	dfntruename("C:/lw-a/file") --> "A:\\FILE"
			but the drive A: is not accessable at all!
		2) Networked drives, e.g. CD-ROM drives and LAN drives, does not
			follow the standard naming. Most of them (if not all) follow
			the UNC standard. For example:
				Drive F: is a Novell Netware drive created by:
					MAP ROOT F:=SERVER/VOLUME:PATH1/PATH2/PATH3
				==> dfntruename("f:\\file") 
					--> "\\SERVER\\VOLUME\\PATH1\\PATH2\\PATH3\\FILE"
				Windows 95 can handle UNC filenames, but this results in
				much slower access time, because Windows 95 globs the filename
				through the "network environment" driver each time such name
				is used.

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifdef _MICROC_
#include <intr.h>
#else
#include <dos.h>
#include <stdlib.h>
#include <errno.h>
#endif
#include <portable.h>
#include "dfn.h"
#include "dynstr.h"
#include "suppl.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: DFNTRUEN.C 1.5 1998/08/19 06:32:54 ska Exp $";
#endif

char *dfntruename(const char fn[])
{	char *h;
	IREGS rp;

	if((h = malloc(DFN_FILENAME_BUFFER_LENGTH)) != NULL) {
		rp.r_ax = 0x6000;
		rp.r_ds = FP_SEG(fn);
		rp.r_si = FP_OFF(fn);
		rp.r_es = FP_SEG(h);
		rp.r_di = FP_OFF(h);
		if(invokeDOS(aS(rp))) {		/* failed */
#ifndef _MICROC_					/* set errno */
			errno = rp.r_ax;
#endif
			free(h);
			return NULL;
		}
	}

	return StrTrim(h);
}
