/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: DFNSEARC.C $
   $Locker:  $	$Name:  $	$State: Exp $

	char *dfnsearch(const char fname[], const char *path, const char *ext)

	Search for the file fname[] within the search path *path. If no extension
	is supplied, all extensions in *ext are tried. *ext may contain wildcards.

	If SUPPORT_UNC_PATH is defined, UNC paths are supported. UNC paths are
	always fully-qualified, except that the extension might be missing.

	If path==NULL, the environment variable "PATH" is retreived.
	If *path==0, no search path is available (thus, scanning in current
	working directory only).
	If ext==NULL, the extensions ".COM.EXE.BAT" are used.
	If *ext==0, the extension is not altered.
	If *ext=='.', this dot is ignored.

	If path contains an entry ".", the current working directory is not
	tried first.
	If the program is running in an Windows environment, the default Windows
	pathes are not prepended automatically.

	If fname[] already contains a drive or path specification, path is ignored.
	If fname[] already contains an extension, ext is ignored.

	The returned filename is not necessarily fully-qualified, nor it is
	pre-processed by dfnsqueeze(). All what is asured is that the returned
	filename can be found relative to the current working directory. The
	function does neither try to open the file nor to asure that this file
	is executable in any way. But Hidden or System files are not included
	into the search.

	Return:
		NULL: fname[] == NULL, *fname == 0, no file found, malloc() failed
		else: pointer to fully-qualified filename, it's malloc()'ed

	Target compilers: Micro-C v3.14, Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <string.h>
#include <stdlib.h>
#include <io.h>
#ifndef _PAC_NOCLIB_
#include "dir.inc"
#endif
#else
#include <file.h>
#endif
#include <portable.h>
#include "dfn.h"
#include "dynstr.h"
#include "environ.h"
#include "suppl.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: DFNSEARC.C 1.9 1998/08/19 07:26:56 ska Exp $";
#endif

static char *searchFile(char *fname)
{
#ifdef _MICROC_
	struct FF_block ff;
#else
	struct ffblk ff;
#endif

	return findfirst(fname, aS(ff), 0)
		? NULL								/* no match found */
		: strdup(inM(ff.FF_name, ff.ff_name));	/* return file name */
}

static char *testFile(char *pa, char *na, char *ex)
{	char *fname, *tname, *found;

	fname = NULL;
	if((tname = dfnmerge(NULL, NULL, pa, na, ex)) != NULL
	 && (found = searchFile(tname)) != NULL) {		/* found */
	 	fname = dfnmerge(NULL, NULL, pa, found, NULL);
	 	free(found);
	}

	free(tname);
	return fname;
}

static char *scanDir(char *na, char *ex, char *ext, char *pa)
{	char *h, *found;
	struct STR_SAVED_TOKENS st;

	if(ex || !*ext)
		return testFile(pa, na, ex);

	StrTokSave(aS(st));
	found = NULL;
	if((h = StrTokenize(ext, ".")) != NULL) do {
		if((found = testFile(pa, na, h)) != 0)
			StrTokStop();
	} while((h = StrTokenize(NULL, ".")) != NULL);

	StrTokRestore(aS(st));
	return found;
}

char *dfnsearch(char fname[], char *path, char *ext)
{	int freePath, scanCwd;
	char *dr, *pa, *na, *ex;
	char *found, *p;
	struct STR_SAVED_TOKENS st;

	if(!fname || !*fname)
		return NULL;

/* What was specified? */
	if(!dfnsplit(fname, &dr, &pa, &na, &ex))
		return NULL;

/* What can be searched? */
	StrTokSave(aS(st));
	freePath = 0;
	found = NULL;

	if(dr || pa) path = "";
	else if(!path) {
		if((path = dupvar("PATH")) == NULL) path = "";
		else freePath = 1;
	}

	if(path) {
		if(ex) ext = "";
		else if(!ext) ext = "COM.EXE.BAT";
		else if(*ext == '.') ++ext;

		if(*path) {				/* there is a search path (dr==pa==NULL) */
			/* check, if the current working directory must be searched */
#if 0
			scanCwd = 1;
			if((p = StrTokenize(path, ";")) != NULL) do {
				if(memcmp(p, ".", 2) == 0) scanCwd = 0;		/* found ! */
			} while((p = StrTokenize(NULL, ";")) != NULL);
			/* To keep the string unchanged, the Tokenize fct must finnish! */
#endif
			p = path - 1;
			scanCwd = 1;
			while(scanCwd && (p = strstr(p + 1, ";.")) != NULL)
				scanCwd = p[3] != ';' && p[3] != '\0';

			if(!scanCwd || (found = scanDir(na, ex, ext, dfnpath(0))) == NULL) {
				if((p = StrTokenize(path, ";")) != NULL) do {
					if((found = scanDir(na, ex, ext, p)) != NULL)
						StrTokStop();
				} while((p = StrTokenize(NULL, ";")) != NULL);
			}
		}
		else {
			if(freePath)
				free(path);
			if((path = dfnmerge(NULL, dr, pa, NULL, NULL)) != NULL) {
				freePath = 1;
				free(pa);
				if((pa = dfnexpand(path, NULL)) != NULL)
					found = scanDir(na, ex, ext, pa);
			}
		}
	}


	if(freePath) free(path);

	free(ex);
	free(na);
	free(pa);
	free(dr);

	StrTokRestore(aS(st));

	return found;
}
