/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: DFNPATH.C $
   $Locker:  $	$Name:  $	$State: Exp $

	char *dfnpath(int drive)

	Retreive the fully-qualified path of: "<drive>:."
	The path is malloc()'ed and has _no_ trailing backslash, except the
	path is the root directory.

	drive may be:
		'A'-'Z', 'a'-'z', or 1..32 (note: 32!, 1 == 'A')
		0 == current drive

	Return:
		NULL: malloc() failed, non-existing drive, or drive invalid
		else: pointer to the path

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#ifdef __TURBOC__
#include <direct.h>
#endif
#include <ctype.h>
#endif
#include <portable.h>
#include "dfn.h"
#include "dynstr.h"
#include "suppl.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: DFNPATH.C 1.5 1998/08/19 02:40:21 ska Exp $";
#endif

char *dfnpath(int drive)
{
	if(isupper(drive)) drive -= 'A' - 1;
	else if(islower(drive)) drive -= 'a' - 1;
	else if((unsigned)drive > 32) return NULL;

	return StrTrim(_getdcwd(drive, NULL, DFN_FILENAME_BUFFER_LENGTH));
}
