/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: DFNMERGE.C $
   $Locker:  $	$Name:  $	$State: Exp $

	char *dfnmerge(char fname[], const char dr[], const char path[]
	 , const char name[], const char ext[])

	Merge a file name.
	If SUPPORT_UNC_PATH is defined, UNC paths are supported. In this case
	*dr must be '\\'.

	dr, path, name, ext:
		Pointers of the path components.
		If one of these is NULL (thus, it is not present), it is not merged.

	If dr[] does not contain an UNC path:
		fname := <dr>:<path>\<name>.<ext>
			':' is added, if <dr> is present;
			'\' is added, if <path>,& <name> or <ext> are present;
			'.' is added, if <ext> is present.

	If dr[] does contain an UNC path:
		fname := <dr>\<path>\<name>.<ext>
			1st '\' is added, if <path>, <name> or <ext> are present;
			2nd '\' is added, if <path> is and <name> or <ext> are present;
			'.' is added, if <ext> is present.

	fname:	Pointer to the memory to receive the result.
			If NULL: the necessary memory is malloc'ed.

   Return:
   	NULL if malloc failed.
   	otherwise: pointer to the beginning of the result.

	Target compilers: Micro-C v3.13, v3.14; Borland C v2, v3.1, v4.52

*/

#include "initsupl.inc"

#ifndef _MICROC_
#include <string.h>
#include <stdlib.h>
#include <dos.h>
#endif
#include <portable.h>
#include "dfn.h"
#include "suppl.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: DFNMERGE.C 1.7 1998/08/19 02:40:21 ska Exp $";
#endif

char *dfnmerge(char fname[], const char dr[], const char path[]
 , const char name[], const char ext[])
{	int len;
	char *p;

	if((p = fname) == NULL) {	/* determine file name length */
#ifdef SUPPORT_UNC_PATH
		len = dr? (*dr == '\\'? strlen(dr) + 1: 3): 1;
#else
		len = dr? 3: 1;		/* add the NUL terminator */
#endif
		if(path) len += strlen(path) + 1;
		if(name) len += strlen(name);
		if(ext) len += strlen(ext) + 1;
		if((fname = p = malloc(len)) == NULL)
			return NULL;
		*fname = NUL;
	}
	if(dr) {
#ifdef SUPPORT_UNC_PATH
		if(*dr == '\\') {
			p = stpcpy(p, dr);
			if(path? *path && *path != '\\' && *path != '/'
			 : name || ext)
			 	*p++ = '\\';
		}
		else {
#endif
			*p++ = *dr;
			*p++ = ':';
			if(path && !*path)		/* root directory */
				*p++ = '\\';
#ifdef SUPPORT_UNC_PATH
		}
#endif
		*p = NUL;
	}
	if(path) {
		p = stpcpy(p, path);
		if((name || ext) && p[-1] != '\\' && p[-1] != '/') {
			*p++ = '\\';
			*p = NUL;
		}
	}
	if(name)	p = stpcpy(p, name);
	if(ext) {
		*p++ = '.';
		strcpy(p, ext);
	}
	return fname;
}
