/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $RCSfile: _GETDCWD.C $
   $Locker:  $	$Name:  $	$State: Exp $

	char *_getdwcd(int drive, char *buf, unsigned length)

	Retreive the fully-qualified path of: "<drive>:."
	The path _no_ trailing backslash, except the path is the root directory.

	If buf == NULL, a buffer of length bytes is malloc()'ed.

	Note: In any case, buf must be long enough to hold the complete path.
	length is not checked in any way!

	drive may be:
		0 == current drive
		1 == A:
		2 == B:
		 ... 

	Return:
		NULL: malloc() failed, non-existing drive, or drive invalid
		else: pointer to the path

	Target compilers: Micro-C only

*/

#include "initsupl.inc"

#ifdef _MICROC_
#define COMPILE 1
#endif
#ifdef _PAC_NOCLIB_
#define COMPILE 2
#endif
#ifdef __WATCOMC__
#define COMPILE 3
#endif

#ifdef COMPILE
#include <portable.h>
#include "suppl.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: _GETDCWD.C 1.4 1998/08/19 06:32:54 ska Exp $";
#endif

#ifdef _MICROC_
char *_getdcwd(int drive, char Xbuf[], unsigned length)
{
	char *buf;

	if((buf = Xbuf) || (buf = malloc(length))) {
		buf;						/* AX := buf */
		asm "mov si, ax";
		drive;						/* AX := drive */
		asm {
			mov dx, ax
			or ax, ax
			jz currDrive
			add al, 'A' - 1			;/* specified drive */
			jmp short putDrive
currDrive:
			mov ah, 19h
			int 21h
			add al, 'A'				;/* 0 == A: */
putDrive:
			mov Byte Ptr [si], al
			inc si
			mov Word Ptr [si], '\:'
			inc si
			inc si
			mov ah, 47h
			int 21h
		}
		if(Carry()) {				/* Get path failed */
			if(!Xbuf) free(buf);
			return NULL;
		}
	}
	return buf;
}

#else

#include <stdlib.h>
#include <string.h>
#include "suppl.h"

char *_getdcwd(int drive, char Xbuf[], unsigned length)
{	char *buf;
	USEREGS

	if((buf = Xbuf) || (buf = malloc(length))) {
		strcpy(buf, "A:\\");
		*buf += drive? drive - 1: getdisk();
		_SI = FP_OFF(&buf[3]);
		_DX = drive;
		_DS = FP_SEG(buf);
		_AX = 0x4700;
		geninterrupt(0x21);
		if(_CFLAG) {				/* Get path failed */
			if(!Xbuf) free(buf);
			return NULL;
		}
	}
	return buf;
}

#endif

#endif	/* COMPILE */
