/*
    SUPPL - a supplemental library for common useage
    Copyright (C) 1995,1996  Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
    See: COPYING.LB
*/
/* $Id: GETOPT.H 2.1 1996/11/08 03:18:16 ska Exp $
   $Locker:  $	$Name:  $	$State: Exp $

	Free-Dos library declaration header file.

*/

#ifndef __FREEDOS_H
#define __FREEDOS_H

#include <portable.h>

extern int	optind, 	/* index into argv[] array */
			optchar;	/* index into argv[optind][] array */
extern char *optarg;	/* address of argument of an argumented option */
						/* for getopt1(): address of set/unset modifier or
								NULL, if non set */

/* Global control variables for getoptG() */
extern char   *opt1st,		/* non-argumented options */
			  *opt2nd, 		/* argumented options */
			  *opt3rd, 		/* special argumented options */
			  *optSWCHAR, 	/* switch characters, defaults to "/=" */
			  *optARGCHAR, 	/* argument characters, defaults to ":=" */
			  *optBOOL;		/* set/clear characters, defaults to "+-" */
extern unsigned optFlags;	/* Hold the following flags: */
#define GETOPT_NOHELPSCREEN 0x100	/* Don't invoke hlpScreen() for '?' */
#define GETOPT_IGNORE 0x80	/* skip non-option arguments */
#define GETOPT_MARKEMPTY 0x40	/* place '\0' behind switchar to mark the
									argument as used */
#define GETOPT_ADVANCE 0x3f	/* skip (optFlags & GETOPT_ADVANCE) arguments when
								this option is used up */

int getopt(int argc, char **argv, char *opt, char *argopt);
int getopt1(int argc, char **argv, char *opt, char *argopt);
int getopt2(int argc, char **argv, char *opt, char *argopt, char *specopt);
int getoptG(int argc, char **argv);
/* get next option:
	argc: from main()
	argv: from main()
	opt: non-argumented options, upper-cased
	argopt: argumented options, upper-cased
	specopt: special argumented options, upper-cased
*/

#endif
