#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define OPT_FORCE   0x01
#define OPT_SLINK   0x02
#define OPT_LHELP   0x04
#define OPT_DTDIR   0x08
#define OPT_VBOSE   0x10
#define OPT_FPATH   0x20

const char finishtext[] = "'.\n";
const char betwentext[] = "' to `";
const char missngtext[] = "Missing argument\n";
const char createtext[] = "create symbolic link `";
const char removetext[] = "Couldn't remove `";
const char symfrmtext[] = "Couldn't create symlink from `";
const char hrdfrmtext[] = "Couldn't create hard link from `";
const char newlintext[] = "'\n";

void writeerr( const char *s )
{
    _write( 2, s, strlen( s ) );
}

void writeout( const char *s )
{
    _write( 1, s, strlen( s ) );
}

int lastchar( char *s )
{
    return( s[ strlen( s ) - 1 ] );
}

int main( int argc, char **argv )
{
    int c, flags = 0;

    while( ( c = getopt( argc, argv, "fsvp" ) ) != -1 ) {
        switch( c ) {
            case 'f':
                flags |= OPT_FORCE;
                break;
            case 's':
                flags |= OPT_SLINK;
                break;
            case 'v':
                flags |= OPT_VBOSE;
                break;
            case 'p':
                flags |= OPT_FPATH;
                break;
            case '?':
                flags |= OPT_LHELP;
                break;
        }
    }
    c = 0; /* We will use as the retval carrier today */

    if( flags & OPT_LHELP ) {
        writeerr( 
            "FreeDOS LN 1.0 - Create DJGPP-style hard and symbolic links\n" );
        writeerr(
            "Syntax: LN [-fsvp] <file1> <file2> [file3 ... destdir]\n" );
        writeerr(
            "Options:\n" );
        writeerr(
            "  -f  Force creation of link; overwrite destination files\n" );
        writeerr( 
            "  -s  Create symbolic links instead of hard links\n" );
        writeerr(
            "  -v  Write each file to screen before linking\n" );
        writeerr(
            "  -p  Use the full path of the source file[s]\n" );

        return( 1 );
    }

    if( ( c = _chmod( argv[ argc - 1 ], 0 ) ) & _A_SUBDIR && c != -1 ) {
        flags |= OPT_DTDIR;
    }

    if( !( flags & OPT_DTDIR ) ) {
        if( optind >= ( argc - 1 ) ) {
            writeerr( missngtext );
            c++;
        }

        for( ; optind < ( argc - 1 ); optind += 2 ) {
            char fullsource[ PATH_MAX ];

            if( flags & OPT_FPATH ) realpath( argv[ optind ], fullsource );
            else strcpy( fullsource, argv[ optind ] );

            if( flags & OPT_FORCE && _chmod( argv[ optind + 1 ], 0 ) != -1 ) {
                if( unlink( argv[ optind + 1 ] ) == -1 ) {
                    writeerr( removetext );
                    writeerr( argv[ optind + 1 ] );
                    writeerr( finishtext );
                    c++;
                    continue;
                }
            }
            
            if( flags & OPT_VBOSE ) {
                writeout( createtext );
                writeout( argv[ optind + 1 ] );
                writeout( betwentext );
                writeout( fullsource );
                writeout( newlintext );
            }

            if( flags & OPT_SLINK &&
                symlink( fullsource, argv[ optind + 1 ] ) == -1 ) {
                writeerr( symfrmtext );
                writeerr( fullsource );
                writeerr( betwentext );
                writeerr( argv[ optind + 1 ] );
                writeerr( finishtext );
                c++;
                continue;
            } else if( !( flags & OPT_SLINK ) &&
                       link( fullsource, argv[ optind + 1 ] ) == -1 ) {
                writeerr( hrdfrmtext );
                writeerr( fullsource );
                writeerr( betwentext );
                writeerr( argv[ optind + 1 ] );
                writeerr( finishtext );
                c++;
                continue;
            }
        }
    } else {
        char fullpath[ PATH_MAX ];
        char fullsource[ PATH_MAX ];

        if( flags & OPT_FPATH ) realpath( argv[ optind ], fullsource );
        else strcpy( fullsource, argv[ optind ] );

        argc--;

        if( optind >= argc ) {
            writeerr( missngtext );
            c++;
        }

        for( ; optind < argc; optind++ ) {
            strcpy( fullpath, argv[ argc ] );
            if( lastchar( fullpath ) != '/' && lastchar( fullpath ) != '\\' )
                strcat( fullpath, "\\" );
            strcat( fullpath, argv[ optind ] );
            if( flags & OPT_FORCE && _chmod( fullpath, 0 ) != -1 ) {
                if( unlink( fullpath ) == -1 ) {
                    writeerr( removetext );
                    writeerr( fullpath );
                    writeerr( finishtext );
                    c++;
                    continue;
                }
            }
            
            if( flags & OPT_VBOSE ) {
                writeout( createtext );
                writeout( fullpath );
                writeout( betwentext );
                writeout( fullsource );
                writeout( newlintext );
            }

            if( flags & OPT_SLINK &&
                symlink( fullsource, fullpath ) == -1 ) {
                writeerr( symfrmtext );
                writeerr( fullsource );
                writeerr( betwentext );
                writeerr( fullpath );
                writeerr( finishtext );
                c++;
                continue;
            } else if( !( flags & OPT_SLINK ) &&
                       link( fullsource, fullpath ) == -1 ) {
                writeerr( hrdfrmtext );
                writeerr( fullsource );
                writeerr( betwentext );
                writeerr( fullpath );
                writeerr( finishtext );
                c++;
                continue;
            }
        }
    }

    return( c );
}

