/*
  The following example program, adapted from the GNU getopt_long
  manual, illustrates the use of getopt_long() with most of its
  features.
*/

/* This program should compile under Linux and DOS equally well.  */

/*
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#include <stdio.h>

#ifdef unix
#define _GNU_SOURCE
#include <getopt.h>
#else /* assumes DOS */
#include <stdlib.h>
#include "getopt_l.h"
#endif

int
main (argc, argv)
     int argc;
     char **argv;
{
  int c;

  int option_index = 0;
  static struct option long_options[] =
  {
    {"help", 0, 0, 'h'},
    {"verbose", 0, 0, 'v'},
    {"extra", 1, 0, 'x'},
    {0, 0, 0, 0}
  };

  while ((c = getopt_long (argc, argv, "x:hv",
		       long_options, &option_index)) != EOF)
    {
      switch (c)
	{
	case 'x':
	  printf ("x -> option = %s\n", optarg);
	  break;

	case 'h':
	  printf ("print help\n");
	  break;

	case 'v':
	  printf ("verbose mode = on\n");
	  break;

	default:
	  printf ("?? getopt returned character %c (optopt=%c)\n", c, optopt);
	}
    }

  if (optind < argc)
    {
      printf ("non-option ARGV-elements: ");
      while (optind < argc)
	printf ("%s ", argv[optind++]);
      printf ("\n");
    }

  exit (0);
}
