#include <stdio.h>
#include "ems.c"

/* test program for EMS lib */

/* test buffers */
char buf1[100];
char buf2[100];

int main(void)
{
   int handle;    /* EMS handle */

   /* USE a test string */
   strcpy(buf1, "If you can read this, the EMS lib works :)");

   /* is EMS installed? non-zero if false */
   if (ems_installed())
      abort("This program requires EMS to be installed.");

   /* print off some info about EMS */
   printf("Ems Information\nPage Frame: %x\nTotal Pages: %u (%u KB)\nPages Free: %u (%u KB)\n",
          ems_page_frame(), ems_total_pages(), ems_total_pages() << 4,
          ems_pages_free(), ems_pages_free() << 4);

   /* Allocate 2 pages (32kb) of EMS */
   if (!(handle = ems_alloc(2)))
      abort("Error allocating 32kb of ram...");

   /* play with EMS here */
   puts("Allocated 32kb of ram...");

   /* MAP page 1 of EMS to page_frame #0
      Notice page 1 of EMS is actually 0 (because it is zero-based)
   */
   if (ems_map_memory(0, 0, handle))
      abort("Could not map first page of EMS to page frame.");

   /* copy from real mem to page frame */
   /* copy_seg(ems_page_frame(), 0, get_ds(), &buf1[0], strlen(buf1) + 1); */

   /* map second page of EMS to page frame #0 */
   if (ems_map_memory(0, 1, handle))
      abort("Could not map second page of EMS to page frame.");

   /* now map first page again to see if data is still there */
   if (ems_map_memory(0, 0, handle))
      abort("Could not map first page of EMS to page frame.");

   /* copy data into second buffer */
   /* copy_seg(get_ds(), &buf2[0], ems_page_frame(), 0, strlen(buf1) + 1); */

   /* is it the same? :) */
   puts(buf2);

   /* free ems ram */
   if (ems_free(handle))
      abort("Error freeing the 32kb of ram...");

   return( 0 );
}



