/*      CREATE.C - part of the FreeDAPI
        Copyright 1999 - Enrico Bartky

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <string.h>
#include <dapi.h>
#include <draw.h>
#include <alloc.h>
#include <graphics.h>
#include <misc.h>
#include <stdio.h>
#include <process.h>
#include <conio.h>

HTXT CreateText(HWND window,int x, int y, char txt[255])
{
 HTXT Text;
 Text.x=window->x+x;
 Text.y=window->y+y;
 strcpy(Text.txt,txt);
 return Text;
}

HBUTTON CreateButton(HWND window, int x, int y, char txt[255])
{
 HBUTTON Button;
 Button.x=window->x+x;
 Button.y=window->y+y;
 Button.x1=Button.x+strlen(txt)*TXTWIDTH+12;
 Button.y1=Button.y+TXTHIGH+6;
 strcpy(Button.txt,txt);
 return Button;
}

HCHECK CreateCheck(HWND window, int x, int y, char txt[255])
{
 HCHECK Check;
 Check.x=window->x+x;
 Check.y=window->y+y;
 strcpy(Check.txt,txt);
 return Check;
}

HENTER CreateEnter(HWND win, int x, int y,int l)
{
 HENTER Enter;
 Enter.x=win->x+x;
 Enter.y=win->y+y;
 Enter.x1=Enter.x+(l*TXTWIDTH)+(l*2);
 Enter.y1=Enter.y+(2)+(TXTHIGH)+(2);
 Enter.l=l;
 return Enter;
}

HWND CreateWindow(int x, int y, int x1, int y1, char title[255], HWND parent, int type)
{
 int i;
 #ifdef USE_EMS
  HWND Temp;
  i=DAPI_alloc(sizeof(HWND));
 #else
  HWND Temp=DAPI_alloc(1,sizeof(HWND));
 #endif
 Temp->x=x;
 Temp->parent=DAPI_alloc(1,sizeof(HWND));
 Temp->y=y;
 Temp->x1=x1;
 Temp->y1=y1;
 strcpy(Temp->title,title);
 Temp->parent=parent;
 if(parent==NULL)
  Temp->active=1;
 else
 {
  Temp->active=1;
  Temp->parent->active=0;
 }
 Temp->type=type;
 return Temp;
}