/* A sample program to implement hashes */

/* Code lifted from _The C Programming Language_, Second Ed., BWK/DMR. */

#include <stdio.h>
#include <stdlib.h>			/* malloc */
#include <string.h>			/* strdup */

#include "db.h"

/* Sample program */

int
main (void)
{
  char str[80];
  char *key, *value;
  db_t *ret;

  /* Load stdin into the hash.  The data file should contain more than
     101 values, to really test that the hash is doing what I think it
     should be doing.  We should not "top out" at 101 values. */

  /* This is a demo program, so you can ignore the error about gets */

  while (gets (str) != NULL)
    {
      key = strtok (str, ":");
      value = strtok (NULL, "");

      db_insert (key, value);
    }

  /* Now query some elements */

  printf ("if using foo2.dat, then these should be successful:\n");

  ret = db_fetch ("1");
  printf ("1 -> |%s|\n", (ret ? ret->value : "NOT_FOUND"));

  ret = db_fetch ("1.3");
  printf ("1.3 -> |%s|\n", (ret ? ret->value : "NOT_FOUND"));

  ret = db_fetch ("1.5");
  printf ("1.5 -> |%s|\n", (ret ? ret->value : "NOT_FOUND"));

  ret = db_fetch ("1.9");
  printf ("1.9 -> |%s|\n", (ret ? ret->value : "NOT_FOUND"));

  ret = db_fetch ("2");
  printf ("2 -> |%s|\n", (ret ? ret->value : "NOT_FOUND"));

  ret = db_fetch ("3");
  printf ("3 -> |%s|\n", (ret ? ret->value : "NOT_FOUND"));

  ret = db_fetch ("51");
  printf ("51 -> |%s|\n", (ret ? ret->value : "NOT_FOUND"));

  ret = db_fetch ("101");
  printf ("101 -> |%s|\n", (ret ? ret->value : "NOT_FOUND"));

  ret = db_fetch ("102");
  printf ("102 -> |%s|\n", (ret ? ret->value : "NOT_FOUND"));

  ret = db_fetch ("105");
  printf ("105 -> |%s|\n", (ret ? ret->value : "NOT_FOUND"));

  printf ("\nthese should fail:\n");

  ret = db_fetch ("*");
  printf ("* -> |%s|\n", (ret ? ret->value : "NOT_FOUND"));

  ret = db_fetch ("ecks");
  printf ("ecks -> |%s|\n", (ret ? ret->value : "NOT_FOUND"));

  /* Done */

  exit (0);
}
