#include <stdio.h>
#include <math.h>
#include <string.h>

#include <allegro.h>

#include "apeg.h"

#ifdef _MSC_VER
#define strcasecmp stricmp
#endif

typedef struct {
	int coded_w, coded_h;
} EArgs;

int vid_init(APEG_STREAM *stream, int coded_w, int coded_h, void *arg)
{
	EArgs *eargs = arg;

	eargs->coded_w = coded_w;
	eargs->coded_h = coded_h;

	printf("YUV4MPEG2 W%d H%d F%d:%d I%c A%d:%d\n",
	       stream->w, stream->h, stream->fps_numerator,
	       stream->fps_denominator, 'p', stream->aspect_numerator,
	       stream->aspect_denominator);

	fflush(stdout);
	return 0;
}

void vid_write(APEG_STREAM *stream, unsigned char **src, void *arg)
{
	EArgs *eargs = arg;
	int y, w, h;

	printf("FRAME\n");

	w = stream->w;
	h = stream->h;
	for(y = 0;y < h;++y)
		fwrite(src[0] + y*eargs->coded_w, 1, w, stdout);

	w /= 2;
	h /= 2;

	for(y = 0;y < h;++y)
		fwrite(src[1] + y*(eargs->coded_w/2), 1, w, stdout);
	for(y = 0;y < h;++y)
		fwrite(src[2] + y*(eargs->coded_w/2), 1, w, stdout);

	fflush(stdout);
}

int aud_init(APEG_STREAM *stream, int *channels, int *frequency, void *arg)
{
	uint32_t val32 = ~0u;
	uint16_t val16;

	fwrite("RIFF", 1, 4, stdout);
	fwrite(&val32, 1, 4, stdout);
	fwrite("WAVE", 1, 4, stdout);

	fwrite("fmt ", 1, 4, stdout);
	fputc(16, stdout); fputc(0, stdout);
	fputc( 0, stdout); fputc(0, stdout); // 32-bit word

	fputc(1, stdout); fputc(0, stdout); // 16-bit word
	val16 = *channels;
	fputc(val16&255, stdout); fputc(val16>>8, stdout); // 16-bit word
	val32 = *frequency;
	fputc(val32&255, stdout); fputc((val32>>8)&255, stdout);
	fputc((val32>>16)&255, stdout); fputc((val32>>24), stdout); // 32-bit word

	fwrite("\0\0\0\0\0\0", 1, 6, stdout);

	val16 = 16;
	fputc(val16&255, stdout); fputc(val16>>8, stdout); // 16-bit word

	val32 = ~0u;
	fwrite("data", 1, 4, stdout);
	fwrite(&val32, 1, 4, stdout);

	fflush(stdout);
	return 0;
	(void)stream;
	(void)arg;
}

int aud_write(APEG_STREAM *stream, void *buf, int length, void *arg)
{
	uint16_t *smp = (uint16_t*)buf;
	int to_do = length/2, i;

	for(i = 0;i < to_do;++i)
	{
		uint16_t val16 = smp[i];
		fputc(val16&255, stdout); fputc((val16>>8)^0x80, stdout);
	}

	fflush(stdout);
	return to_do*2;
	(void)stream;
	(void)arg;
}

int main(int argc, char **argv)
{
	APEG_STREAM *stream;
	EArgs eargs;
	const char *fname;

#ifdef _WIN32
	/* Goddamn Windows... */
	_setmode(_fileno(stdin),  _O_BINARY);
	_setmode(_fileno(stdout), _O_BINARY);
#endif

	if(argc < 2)
	{
		fprintf(stderr, "Usage: %s [-audio] <filename.mpg>\n", argv[0]);
		exit(1);
	}

	if(allegro_init() != 0)
	{
		fprintf(stderr, "Allegro init failed!\n%s\n", allegro_error);
		exit(1);
	}

	install_timer();

	if(strcasecmp(argv[1], "-audio") == 0)
	{
		fname = argv[2];
		apeg_ignore_video(TRUE);
		apeg_set_audio_callbacks(aud_init, aud_write, NULL);
	}
	else
	{
		fname = argv[1];
		apeg_ignore_audio(TRUE);
		apeg_set_display_callbacks(vid_init, vid_write, &eargs);
	}

	stream = apeg_open_stream(fname);
	if(!stream)
	{
		fprintf(stderr, "Could not load stream!\n%s\n", apeg_error);
		exit(1);
	}

	if((stream->flags&APEG_HAS_VIDEO))
		apeg_set_stream_rate(stream, 0.0);

	do {
		stream->timer = 1;
	} while(apeg_advance_stream(stream, FALSE) == APEG_OK);

	apeg_close_stream(stream);
	return 0;
}
END_OF_MAIN()
