/*
 * $Id: msghu852.c,v 1.7 2005/06/10 22:51:36 ronpinkas Exp $
 */

/*
 * Harbour Project source code:
 * Language Support Module (HU852)
 *
 * Copyright 1999-2001 Viktor Szakats <viktor.szakats@syenar.hu>
 * www - http://www.harbour-project.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA (or visit the web site http://www.gnu.org/).
 *
 * As a special exception, the Harbour Project gives permission for
 * additional uses of the text contained in its release of Harbour.
 *
 * The exception is that, if you link the Harbour libraries with other
 * files to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the Harbour library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the Harbour
 * Project under the name Harbour.  If you copy code from other
 * Harbour Project or Free Software Foundation releases into a copy of
 * Harbour, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for Harbour, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.
 *
 */

/* Language name: Hungarian */
/* ISO language code (2 chars): HU */
/* Codepage: 852 */

#include "hbapilng.h"

static HB_LANG s_lang =
{
   {
      /* Identification */

      "HU852",                     /* ID */
      "Hungarian",                 /* Name (in English) */
      "Magyar",                    /* Name (in native language) */
      "HU",                        /* RFC ID */
      "852",                       /* Codepage */
      "$Revision: 1.7 $ $Date: 2005/06/10 22:51:36 $",         /* Version */

      /* Month names */

      "janur",
      "februr",
      "mrcius",
      "prilis",
      "mjus",
      "jnius",
      "jlius",
      "augusztus",
      "szeptember",
      "oktber",
      "november",
      "december",

      /* Day names */

      "vasrnap",
      "htf",
      "kedd",
      "szerda",
      "cstrtk",
      "pntek",
      "szombat",

      /* CA-Cl*pper compatible natmsg items */

      "Adatbzisok       Ttelszm    Utols md.     Mret",
      "Kri a tovbbi rszeket?",
      "lapszm",
      "** sszesen **",
      "* Rszsszesen *",
      "*** Mindsszesen ***",
      "Ins",
      "   ",
      "Rossz dtum",
      " Hatrok ",
      " - ",
      "I/N",
      "INVALID EXPRESSION",

      /* Error description names */

      "Ismeretlen hiba",
      "Paramter hiba",
      "Tmbindex hiba",
      "Karakteres vltoz tlcsorduls",
      "Numerikus tlcsorduls",
      "Nullval val oszts",
      "Numerikus hiba",
      "Szintaktikus hiba",
      "Tl sszetett mvelet",
      "",
      "",
      "Kevs memria",
      "Nem definilt fggvny",
      "Nem exportlt metdus",
      "Nem ltez vltoz",
      "Nem ltez munkaterlet nv",
      "Nem exportlt vltoz",
      "Helytelen munkaterlet nv",
      "Mr hasznlt munkaterlet nv",
      "",
      "Ltrehozsi hiba",
      "Megnyitsi hiba",
      "Lezrsi hiba",
      "Olvassi hiba",
      "rs hiba",
      "Nyomtatsi hiba",
      "",
      "",
      "",
      "",
      "Nem tmogatott mvelet",
      "Korlt tllpve",
      "Index hiba felfedezve",
      "Nem megfelel adattpus",
      "Tl szles adat",
      "Nem megnyitott munkaterlet",
      "Nem indexelt munkaterlet",
      "Kizrlagos megnyitsi md szksges",
      "Zrols szksges",
      "rs nem megengedett",
      "Zrols nem sikerlt j rekord felvitelekor",
      "Zrols nem sikerlt",
      "",
      "",
      "",
      "",
      "tmbelem hozzfrs",
      "tmbelem rtkads",
      "tmbelem dimenzi",
      "nem tmb",
      "feltteles",
      "Invalid self",

      /* Internal error names */

      "Kezelhetetlen hiba %lu: ",
      "Hiba kezelsi hiba",
      "Nincs ERRORBLOCK() a hiba kezelshez",
      "Tl sok rekurzv hiba kezel hvs",
      "Az RDD hibs vagy nem sikerlt betlteni",
      "Nem megfelel tpus metdus (%s)",
      "hb_xgrab can't allocate memory",
      "hb_xrealloc called with a NULL pointer",
      "hb_xrealloc called with an invalid pointer",
      "hb_xrealloc can't reallocate memory",
      "hb_xfree called with an invalid pointer",
      "hb_xfree called with a NULL pointer",
      "Can\'t locate the starting procedure: \'%s\'",
      "No starting procedure",
      "Unsupported VM opcode",
      "Symbol item expected from %s",
      "Invalid symbol type for self from %s",
      "Codeblock expected from %s",
      "Incorrect item type on the stack trying to pop from %s",
      "Stack underflow",
      "An item was going to be copied to itself from %s",
      "Invalid symbol item passed as memvar %s",
      "Memory buffer overflow",
      "hb_xgrab requested to allocate zero bytes",
      "hb_xrealloc requested to resize to zero bytes",
      "hb_xalloc requested to allocate zero bytes",

      /* Texts */

      "YYYY.MM.DD",
      "I",
      "N"
   }
};

HB_LANG_ANNOUNCE( HU852 );

HB_CALL_ON_STARTUP_BEGIN( hb_lang_Init_HU852 )
   hb_langRegister( &s_lang );
HB_CALL_ON_STARTUP_END( hb_lang_Init_HU852 )
#if defined(HB_PRAGMA_STARTUP)
   #pragma startup hb_lang_Init_HU852
#elif defined(HB_MSC_STARTUP)
   #if _MSC_VER >= 1010
      #pragma data_seg( ".CRT$XIY" )
      #pragma comment( linker, "/Merge:.CRT=.data" )
   #else
      #pragma data_seg( "XIY" )
   #endif
   static HB_$INITSYM hb_vm_auto_hb_lang_Init_HU852 = hb_lang_Init_HU852;
   #pragma data_seg()
#endif

