/*
 * $Id: msgpt.c 9353 2008-09-11 10:55:02Z vszakats $
 */

/*
 * Harbour Project source code:
 * Language Support Module (PT)
 *
 * Copyright 2000 Luiz Rafael Culik <culik@sl.conex.net>
 * www - http://www.harbour-project.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA (or visit the web site http://www.gnu.org/).
 *
 * As a special exception, the Harbour Project gives permission for
 * additional uses of the text contained in its release of Harbour.
 *
 * The exception is that, if you link the Harbour libraries with other
 * files to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the Harbour library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the Harbour
 * Project under the name Harbour.  If you copy code from other
 * Harbour Project or Free Software Foundation releases into a copy of
 * Harbour, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for Harbour, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.
 *
 */

/*
 * The following parts are Copyright of the individual authors.
 * www - http://www.harbour-project.org
 *
 * Copyright 2000 Felipe Coury <fcoury@creation.com.br>
 *    Small fixes
 *    Internal error names
 *
 * See doc/license.txt for licensing terms.
 *
 */

/* Language name: Portuguese */
/* ISO language code (2 chars): PT */
/* Codepage: 850 */

#include "hbapilng.h"

static HB_LANG s_lang =
{
   {
      /* Identification */

      "PT",                        /* ID */
      "Portuguese",                /* Name (in English) */
      "Portugues",                 /* Name (in native language) */
      "PT",                        /* RFC ID */
      "850",                       /* Codepage */
      "",                          /* Version */

      /* Month names */

      "Janeiro",
      "Fevereiro",
      "Maro",
      "Abril",
      "Maio",
      "Junho",
      "Julho",
      "Agosto",
      "Setembro",
      "Outubro",
      "Novembro",
      "Dezembro",

      /* Day names */

      "Domingo",
      "Segunda-feira",
      "Tera-feira",
      "Quarta-feira",
      "Quinta-feira",
      "Sexta-feira",
      "Sbado",

      /* CA-Cl*pper compatible natmsg items */

      "Banco de Dados    # Registro    Ult. Atuali.    Tam.",
      "Voce quer mais testes?",
      "Pagina No.",
      "** Subtotal **",
      "* Subsubtotal *",
      "*** Total ***",
      "Ins",
      "   ",
      "Data invlida",
      "Faixa: ",
      " - ",
      "S/N",
      "EXPRESSO INVALIDA",

      /* Error description names */

      "Erro desconhecido",
      "Erro nos parmetros",
      "Erro de limite",
      "Overflow de string",
      "Overflow numrico",
      "Diviso por zero",
      "Erro numrico",
      "Erro de sintaxe",
      "Operao muito complexa",
      "",
      "",
      "Memria insuficiente",
      "Funo indefinida",
      "Mtodo no exportado",
      "Varivel no existe",
      "Alias no existe",
      "Nenhuma varivel exportada",
      "Nome de alias incorreto",
      "Nome de alias duplicado",
      "",
      "Erro de criao",
      "Erro de abertura",
      "Erro ao fechar",
      "Erro de leitura",
      "Erro de escrita",
      "Erro de impresso",
      "",
      "",
      "",
      "",
      "Operao no suportada",
      "Limite excedido",
      "Detectado ndice corrompido",
      "Tipo incorreto de dado",
      "Tamanho do dato muito longo",
      "Workarea no est em uso",
      "Workarea no indexada",
      "Uso exclusivo requerido",
      "Travamento requerido",
      "Escrita no permitida",
      "Falha no travamento do Append",
      "Falha no travamento",
      "",
      "",
      "",
      "",
      "acesso de array",
      "array assign",
      ""
      "no  um array",
      "condicional",

      /* Internal error names */

      "Erro irrecupervel %lu: ",
      "Erro na recuperaao do erro",
      "ERRORBLOCK() para erro ausente",
      "Muitas chamadas recursivas ao manipulador de erros",
      "Falha ao carregar ou RDD invlido",
      "Mtodo de %s invlido",
      "hb_xgrab nao pode alocar memria",
      "hb_xrealloc chamado com ponteiro NULL",
      "hb_xrealloc chamado com ponteiro invlido",
      "hb_xrealloc nao pode realocar memria",
      "hb_xfree chamado com ponteiro invlido",
      "hb_xfree chamado com ponteiro NULL",
      "Impossivel localizar procedure de incializaao: \'%s\'",
      "Nao ha procedure de inicializaao",
      "VM opcode nao suportado",
      "Item de smbolo esperado de %s",
      "Tipo de smbolo invlido para self em %s",
      "Codeblock esperado em %s",
      "Tipo incorreto de item na pilha tentando executar um pop de %s",
      "Stack underflow",
      "Um item iria ser copiado para ele mesmo em %s",
      "Symbol item invlido passado como memvar  %s",
      "Memory buffer overflow",
      "hb_xgrab requisitou para alocar zero bytes",
      "hb_xrealloc requisitou para redimensiorar para zero byte",
      "hb_xalloc requisitou para alocar zero bytes",

      /* Texts */

      "DD/MM/YYYY",
      "S",
      "N"
   }
};

HB_LANG_ANNOUNCE( PT );

HB_CALL_ON_STARTUP_BEGIN( hb_lang_Init_PT )
   hb_langRegister( &s_lang );
HB_CALL_ON_STARTUP_END( hb_lang_Init_PT )

#if defined( HB_PRAGMA_STARTUP )                                         
   #pragma startup hb_lang_Init_PT                                     
#elif defined( HB_MSC_STARTUP )
   #if defined( HB_OS_WIN_64 )
      #pragma section( HB_MSC_START_SEGMENT, long, read )
   #endif                                          
   #pragma data_seg( HB_MSC_START_SEGMENT )
   static HB_$INITSYM hb_vm_auto_hb_lang_Init_PT = hb_lang_Init_PT;    
   #pragma data_seg()
#endif                                                                 
