\ THIS PROGRAM TESTS SOME OF THE FLOATING-POINT WORDS OF A MINFORTH SYSTEM

REQUIRES tester.fr
REQUIRES float.mf

CR
TESTING --- MINFORTH FLOATING-POINT WORDS ---

: EMPTY-FPSTACK	 \ ( F: ... -- ) EMPTY FLOATING-POINT STACK
  BEGIN FDEPTH WHILE FDROP REPEAT ;

WARNING OFF
: } FDEPTH 0<> ABORT" FP-STACK IS NOT EMPTY" } ;
WARNING ON

EMPTY-FPSTACK
DECIMAL

\ ------------------------------------------------------------------------
TESTING BASIC FUNCTIONS

{ -> }		\ START	WITH CLEAN SLATE

{ 0. d>f fdepth f>d -> 1 0. } \ test the words used in EMPTY-FPSTACK
{ 0. d>f fdrop fdepth -> 0 }
{ 0. d>f 0. d>f fdrop fdepth f>d -> 1 0. }

{ 0. d>f f>d -> 0. }
{ 1. d>f f>d -> 1. }
{ -1. d>f f>d -> -1. }

\ ------------------------------------------------------------------------
TESTING STACK OPERATIONS

{ 1. d>f 2. d>f fswap f>d f>d -> 1. 2. }
{ 1. 2. 3. d>f d>f d>f frot f>d f>d f>d -> 3. 1. 2. }
{ -7. d>f fdup f>d f>d -> -7. -7. }
{ -4. d>f -2. d>f fover f>d f>d f>d -> -4. -2. -4. }

\ ------------------------------------------------------------------------
TESTING BASIC ARITHMETICS

{ 1. d>f fdup f+ f>d -> 2. }
{ -2. d>f -3. d>f f+ f>d -> -5. }

{ 1. d>f fdup f- f>d -> 0. }
{ -2. d>f -3. d>f f- f>d -> 1. }

{ 0. d>f fnegate f>d -> 0. }
{ 7. d>f fnegate f>d -> -7. }
{ -3. d>f fnegate f>d -> 3. }

{ 2. d>f fdup f* f>d -> 4. }
{ -3. d>f fdup f* f>d -> 9. }
{ -2. d>f 3. d>f f* f>d -> -6. }
{ 5. d>f -2. d>f f* f>d -> -10. }
{ 0. d>f -1. d>f f* f>d -> 0. }
{ 3. d>f 0. d>f f* f>d -> 0. }

{ 10. d>f 5. d>f f/ f>d -> 2. }
{ -33. d>f 11. d>f f/ f>d -> -3. }
{ 33. d>f -3. d>f f/ f>d -> -11. }
{ -14. d>f -7. d>f f/ f>d -> 2. }
{ 0. d>f 2. d>f f/ f>d -> 0. }

\ ------------------------------------------------------------------------
TESTING COMPARISONS

{ 1. d>f f0< -> false }
{ 0. d>f f0< -> false }
{ -1. d>f f0< -> true }

{ 0. d>f f0= -> true }
{ 1. d>f f0= -> false }
{ -2. d>f f0= -> false }

{ 1. d>f 2. d>f f< -> true }
{ 2. d>f 0. d>f f< -> false }
{ 0. d>f -2. d>f f< -> false }
{ -3. d>f -2. d>f f< -> true }

{ 1. d>f fabs f>d -> 1. }
{ -2. d>f fabs f>d -> 2. }

{ -2. d>f 1. d>f fmax f>d -> 1. }
{ -1. d>f -2. d>f fmax f>d -> -1. }
{ -1. d>f 0. d>f fmax f>d -> 0. }
{ 0. d>f -1. d>f fmax f>d -> 0. }
{ 1. d>f 2. d>f fmin f>d -> 1. }
{ -3. d>f -4. d>f fmin f>d -> -4. }
{ 1. d>f 0. d>f fmin f>d -> 0. }
{ 0. d>f -2. d>f fmin f>d -> -2. }

{ 10. d>f 11. d>f 1. d>f f~ -> false }
{ -10. d>f -11. d>f 2. d>f f~ -> true }
{ 1. d>f 2. d>f 1. d>f f~ -> false }

{ 0. d>f fdup fdup f~ -> true }
{ 1. d>f fdup 0. d>f f~ -> true }
{ -2. d>f fdup 0. d>f f~ -> true }
{ 3. d>f 4. d>f 0. d>f f~ -> false }

{ 2. d>f 3. d>f -1. d>f 5. d>f f/ f~ -> false }
{ 2. d>f 3. d>f -2. d>f 5. d>f f/ f~ -> true }
{ -2. d>f -3. d>f -1. d>f 5. d>f f/ f~ -> false }
{ -2. d>f -3. d>f -2. d>f 5. d>f f/ f~ -> true }

\ ------------------------------------------------------------------------
TESTING MEMORY ACCESS, FLITERAL, FCONSTANT, FVARIABLE

VARIABLE FMEM 2 CELLS ALLOT

{ 1. d>f fmem f! -> }
{ fmem f@ f>d -> 1. }

FMEM 2 CELLS ERASE
{ -2. d>f fmem sf! -> }
{ fmem sf@ f>d -> -2. }
{ fmem cell+ @ -> 0 }

{ 3. d>f fmem df! -> }
{ fmem df@ f>d -> 3. }

: FT1 [ -2. d>f ] fliteral ;
{ ft1 f>d -> -2. }

-3. D>F FCONSTANT FT2
{ ft2 f>d -> -3. }

FVARIABLE FT4
{ -4. d>f ft4 f! -> }
{ ft4 f@ f>d -> -4. }

{ 0 floats -> 0 }
{ 1 floats -> 8 }
{ -1 floats -> -8 }
{ 0 sfloats -> 0 }
{ 1 sfloats -> 4 }
{ -1 sfloats -> -4 }
{ 0 dfloats -> 0 }
{ 1 dfloats -> 8 }
{ -1 dfloats -> -8 }
{ 0 float+ -> 8 }
{ 0 sfloat+ -> 4 }
{ 0 dfloat+ -> 8 }

{ 8 faligned -> 8 }
{ 9 faligned -> 16 }
{ 10 faligned -> 16 }
{ 11 faligned -> 16 }
{ 12 faligned -> 16 }
{ 13 faligned -> 16 }
{ 14 faligned -> 16 }
{ 15 faligned -> 16 }
{ 16 faligned -> 16 }
{ 17 faligned -> 24 }

{ 4 sfaligned -> 4 }
{ 5 sfaligned -> 8 }
{ 6 sfaligned -> 8 }
{ 7 sfaligned -> 8 }
{ 8 sfaligned -> 8 }
{ 9 sfaligned -> 12 }

{ 8 dfaligned -> 8 }
{ 9 dfaligned -> 16 }
{ 10 dfaligned -> 16 }
{ 11 dfaligned -> 16 }
{ 12 dfaligned -> 16 }
{ 13 dfaligned -> 16 }
{ 14 dfaligned -> 16 }
{ 15 dfaligned -> 16 }
{ 16 dfaligned -> 16 }
{ 17 dfaligned -> 24 }

{ 0 c, falign here 7 and -> 0 }
{ 0 c, dfalign here 7 and -> 0 }
{ 0 c, sfalign here 3 and -> 0 }
{ falign here falign here = -> true }
{ dfalign here dfalign here = -> true }
{ sfalign here sfalign here = -> true }

\ ------------------------------------------------------------------------
TESTING NUMBER INPUT

{ s" 1E" >float f>d -> true 1. }
{ s" 1.E" >float f>d -> true 1. }
{ s" 1.E0" >float f>d -> true 1. }
{ s" 1.2E+1" >float f>d -> true 12. }
{ s" +1.2E1" >float f>d -> true 12. }
{ s" 120E-1" >float f>d -> true 12. }
{ s" -120E-1" >float f>d -> true -12. }

{ s" 1F" >float -> false }

{ s"   " >float f>d -> true 0. }  \ special case

{ s" 2.D0" >float f>d -> true 2. }
{ s" 2.d+0" >float f>d -> true 2. }
{ s" -2.e-0" >float f>d -> true -2. }

{ 1.0E0 f>d -> 1. }
{ -2.0E1 f>d -> -20. }
{ 200.E-1 f>d -> 20. }
{ +300.E+02 f>d -> 30000. }
{ 10E f>d -> 10. }
{ -10E-1 f>d -> -1. }

\ ------------------------------------------------------------------------
TESTING FRACTIONAL ARITHMETICS

: F=    ( r1 r2 -- flag, true if exact identitiy )
  0E f~ ;
  
: TF=   ( r1 r2 -- flag, true if abs. error < 0.00005 )
  0.00005E f~ ;

{ 1.E 1.00005E tf= -> false }
{ 1.E 1.00004E tf= -> true }

{ 3.33333E 6.66666E f+ 10E tf= -> true }
{ 10E 6.66666E f- 3.33333E tf= -> true }
{ 2E 0.02E f* 0.04E tf= -> true }
{ 10E 3E f/ 3.3333E tf= -> true }
{ -3E-3 fnegate +3E-3 f= -> true }

{ 2E floor 2E f= -> true }
{ 1.5E floor 1E f= -> true }
{ -0.5E floor -1E f= -> true }
{ 0E floor 0E f= -> true }
{ -0E floor 0E f= -> true }

{ 2E fround 2E f= -> true }
{ 1.5E fround 2E f= -> true }
{ 1.4999E fround 1E f= -> true }
{ -0.4999E fround 0E f= -> true }
{ -0.5001E fround -1E f= -> true }

{ 4E fsqrt 2E tf= -> true }
{ 2E fsqrt 1.4142E tf= -> true }
{ 0E fsqrt 0E f= -> true }
{ 1E fsqrt 1E f= -> true }

\ ------------------------------------------------------------------------
TESTING TRIGONOMETRIC FUNCTIONS

PI   .5E F* FCONSTANT PI2/
PI2/ .5E F* FCONSTANT PI4/ 

{ 0E fsin 0E f= -> true }
{ pi fsin 0E tf= -> true }
{ pi2/ fsin 1E tf= -> true }
{ pi4/ fsin 0.7071E tf= -> true }
{ pi fnegate fsin 0E tf= -> true }
{ pi2/ fnegate fsin 1E fnegate tf= -> true }
{ pi4/ fnegate fsin -0.7071E tf= -> true }
{ 10E fsin -0.5440E tf= -> true }

{ 0E fcos 1E f= -> true }
{ pi fcos 1E fnegate tf= -> true }
{ pi2/ fcos 0E tf= -> true }
{ pi4/ fcos 0.7071E tf= -> true }
{ pi fnegate fcos 1E fnegate tf= -> true }
{ pi2/ fnegate fcos 0E tf= -> true }
{ pi4/ fnegate fcos 0.7071E tf= -> true }
{ 10E fcos -0.8391E tf= -> true }

{ 0E fsincos 1E f= 0E f= -> true true }
{ pi4/ fsincos f- 0E tf= -> true }
{ 2.3562E fsincos f+ 0E tf= -> true }

{ 0E ftan 0E f= -> true }
{ pi ftan 0E tf= -> true }
{ pi4/ ftan 1E tf= -> true }
{ pi 6E f/ ftan 0.57735E tf= -> true }
{ pi fnegate ftan 0E tf= -> true }
{ pi 6E f/ fnegate ftan -0.57735E tf= -> true }
{ pi4/ fnegate ftan 1E fnegate tf= -> true }
{ 10E ftan 0.6484E tf= -> true }

{ 0E fasin 0E f= -> true }
{ 0.5E fasin pi f/ 0.1667E tf= -> true }
{ 1E fasin pi f/ 0.5E tf= -> true }
{ -1E fasin pi f/ -0.5E tf= -> true }

{ 1E facos 0E f= -> true }
{ 0.5E facos pi f/ 0.3333E tf= -> true }
{ 0E facos pi f/ 0.5E tf= -> true }
{ -1E facos pi tf= -> true }

{ 0E fatan 0E f= -> true }
{ 1E fatan 0.7854E tf= -> true }
{ 0.5E fatan 0.4636E tf= -> true }
{ -1E fatan -0.7854E tf= -> true }

{ 0E 1E fatan2 0E f= -> true }
{ 1E 1E fatan2 0.7854E tf= -> true }
{ -1E 1E fatan2 -0.7854E tf= -> true }
{ -1E -1E fatan2 -2.3562E tf= -> true }
{ 1E -1E fatan2 2.3562E tf= -> true }

\ ------------------------------------------------------------------------
TESTING EXPONENTIAL AND LOGARITHMIC FUNCTIONS

{ 0E fexp 1E f= -> true }
{ 1E fexp 2.7183E tf= -> true }
{ -1E fexp 0.3679E tf= -> true }

{ 0E fexpm1 0E f= -> true }
{ 1E fexpm1 1.7183E tf= -> true }
{ -1E fexpm1 -0.6321E tf= -> true }

{ 1E fln 0E f= -> true }
{ 2.7183E fln 1E tf= -> true }
{ 0.36788E fln -1E tf= -> true }

{ 1E flog 0E f= -> true }
{ 0.1E flog -1E tf= -> true }
{ 10E flog 1E tf= -> true }

{ 0E flnp1 0E f= -> true }
{ 1E flnp1 0.6931E tf= -> true }
{ -0.63212E flnp1 -1E tf= -> true }

{ 1E 0E f** 1E f= -> true }
{ 2E 2E f** 4E tf= -> true }
{ 2E 0.5E f** 1.4142E tf= -> true }

\ ------------------------------------------------------------------------
TESTING HYPERBOLIC FUNCTIONS

{ 0E fsinh 0E f= -> true }
{ -1E fsinh -1.1752E tf= -> true }
{ 1E fsinh 1.1752E tf= -> true }

{ 0E fcosh 1E f= -> true }
{ 1E fcosh 1.5431E tf= -> true }
{ -1E fcosh 1.5431E tf= -> true }

{ 0E ftanh 0E f= -> true }
{ 1E ftanh 0.7616E tf= -> true }
{ -1E ftanh -0.7616E tf= -> true }

{ 0E fasinh 0E f= -> true }
{ -1E fasinh -0.8814E tf= -> true }
{ 1E fasinh 0.8814E tf= -> true }

{ 1E facosh 0E f= -> true }
{ 2E facosh 1.317E tf= -> true }

\ ------------------------------------------------------------------------
TESTING NUMBER OUTPUT

CREATE FBUF 20 ALLOT
FBUF 20 ERASE

{ 1E fbuf 5 represent -> 1 false true }
{ s" 10000" fbuf 5 compare -> 0 }
{ fbuf 5 + c@ -> 0 }

{ -1E fbuf 5 represent -> 1 true true }
{ s" 10000" fbuf 5 compare -> 0 }

{ 100E 3E f/ fbuf 5 represent -> 2 false true }
{ s" 33333" fbuf 5 compare -> 0 }
{ 0.02E 3E f/ fbuf 5 represent -> -2 false true }
{ s" 66667" fbuf 5 compare -> 0 }

.( CHECKING MINFORTH FS. )

: YSS  \ ( a u -- ) type a new output check line
cr ." You should see " type ."  : " ;

5 SET-PRECISION

1E S" 1.E0" YSS FS.
20E S" 2.E1" YSS FS.
0.02E S" 2.E-2" YSS FS.
-333.E2 S" -3.33E4" YSS FS.
10E 3E F/ S" 3.3333E0" YSS FS.
0.2E 3E F/ S" 6.6667E-2" YSS FS.

CR .( CHECKING MINFORTH FE. )

1E S" 1.E0" YSS FE.
20E S" 20.E0" YSS FE.
300E S" 300.E0" YSS FE.
4000E S" 4.E3" YSS FE.
1E 3E F/ S" 333.33E-3" YSS FE.
2E4 3E f/ S" 6.6667E3" YSS FE.

CR .( CHECKING MINFORTH F. )

1E3 S" 1000." YSS F.
1.1E3 S" 1100." YSS F.
1E 3E F/ S" 0.33333" YSS F.
200E 3E F/ S" 66.667" YSS F.
0.000234E S" 0.00023" YSS F.
0.000236E S" 0.00024" YSS F.
