;
;			DX-FORTH
;
; A direct-threaded 8086 Forth compiler for MSDOS 2.x
;
;
; Assemble preliminary COM file using MASM or TASM:
;
; for Borland TASM 3
;
;	TASMX /l KERNEL.ASM
;	TLINK /t KERNEL
;
; for Microsoft MASM 5.1
;
;	MASM /l KERNEL.ASM
;	LINK KERNEL.OBJ
;	EXE2BIN KERNEL.EXE KERNEL.COM
;
; Make final compressed executable:
;
;	KERNEL.COM - SAVE KERNEL BYE
;

	.8086

no	equ	0
yes	equ	not no

; Date last revised

date	 macro
	db	'2011-11-18'
	 endm

; Modification level

rel	equ	3	; release #
rev	equ	95	; revision #
beta	equ	no	; beta release

; Equates for conditional assembly

debug	equ	no	; debugging messages
ucase	equ	yes	; forth names case insensitive
fpeng	equ	no	; engineering output functions
cfs	equ	yes	; control flow stack extensions
ldp	equ	no	; allow leading decimal point on f/p input

; Command-line assembly options

x	=	no	; show hidden words
fstack	=	yes	; separate floating point stack
floord	=	no	; integer division method
float	=	yes	; include floating point routines
nfd	=	6	; max open source files (min = 2)
retro	=	no	; classic forth behaviours

	ifdef	NOHIDE
x	=	yes
	endif

	ifdef	NOFLOAT
float	=	no
	endif

	ifdef	NOFSTACK
fstack	=	no
	endif

	ifdef	FLOORED
floord	=	yes
	endif

	ifdef	FILES
nfd	=	files
	endif

	ifdef	CLASSIC
retro	=	yes
	endif

; Memory sizes
;
; Set memory used by the forth compiler (default is 96K).
; Systems with limited memory may use reduced values e.g.
; EM=9000h, SM=4000h, HM=2800h results in a 46k footprint.
;
; EM SM HM must be a multiple of 16 bytes!

em	=	0fff0h	; end of memory + 1
sm	=	0b000h	; system dict. start
hm	=	8000h	; header memory size

; user-specified values from the command-line

	ifdef	ems
em	=	ems AND 0fff0h
	endif

	ifdef	sms
sm	=	sms AND 0fff0h
	endif

	ifdef	hms
hm	=	hms AND 0fff0h
	endif

; Buffer sizes

us	equ	128		; user variable space
rts	equ	256		; return stack space

tibsiz	equ	80		; TIB buffer size
bufsiz	equ	10*128		; max block size (multiple of 128)
pfsiz	equ	79+1		; max MS-DOS path/filename size
wbsiz	equ	31+5		; min WORD buffer size
pssiz	equ	255		; max parsed string buffer size
fdsiz	equ	pfsiz+8		; file descriptor size
pno	equ	68		; pictured numeric buffer size

; DOS and memory equates

	 if	retro
psb	equ	em-pssiz	; buffer S"
	 else
psb	equ	em-wbsiz-pssiz	; buffer WORD S"
	 endif
tib	equ	psb-tibsiz	; TIB
sfb	equ	tib-bufsiz	; screen block buffer
fdbs	equ	sfb-(fdsiz*nfd) ; file descriptor blocks

dosfcb	equ	005ch		; default file control block
dosbuf	equ	0080h		; default DTA and command-line buffer
tpa	equ	0100h		; program start

; Equates

vocs	=	8+1	; search vocabularies

init	=	noop	; INIT
ident	=	noop	; IDENT
fnu	=	false	; FNUMBER
fnum	=	0	; fp-stack items
fps	=	0	; fp-stack size

toppru	=	0	; top prunes

	 if	float

maxsig	=	7	; max significant digits

init	=	fpini
ident	=	fiden
fnu	=	fnumb
	 if	fstack
fnum	=	6
fps	=	(fnum+5)*4 ; allow extra for fp display etc
	 endif

toppru	=	fprun1

	 endif

; ASCII characters

bel	equ	07h	; bell
bs	equ	08h	; backspace
tab	equ	09h	; tab
lf	equ	0ah	; line feed
ff	equ	0ch	; form feed
cr	equ	0dh	; carriage return
can	equ	18h	; ctl-x
ctlz	equ	1ah	; ctl-z
escape	equ	1bh	; escape

;
; Forth Registers
;
;	FORTH	8086	Forth preservation rules
;	-----	----	------------------------
;	IP	SI	Interpretive pointer. Should be preserved across
;			forth words.
;	SP	SP	Data stack pointer.  Should be used only as data
;			stack across forth words. May be used within forth
;			words if restored before NEXT.
;	RP	BP	Return stack pointer. Should be preserved across
;			forth words.
;		AX	Input only when APUSH called.
;		DX	Input only when DPUSH called.
;
;	comment conventions:
;
;	a	=	address
;	c	=	8b character
;	u	=	16b unsigned number
;	n	=	16b signed number
;	x	=	16b signed or unsigned number
;	d	=	32b signed double number
;	ud	=	32b unsigned double number
;	xd	=	32b signed or unsigned number
;	cfa,xt	=	addr of code field (execution token)
;	lfa	=	addr of link field
;	nfa	=	addr of name field
;	pfa	=	addr of parameter field (body)
;
;	FIG	Fig-FORTH model
;	F79	Forth-79 Standard
;	F83	Forth-83 Standard
;	F94	Forth-94 ANS FORTH Standard

cw	equ	2	; cell size (bytes)

;
; Memory allocation
;
; The memory above LIMIT is used only by the interpreter.  This space
; is not wasted for turnkey applications as LIMIT, user variables and
; stacks are relocated to EM giving applications more free ram (as
; indicated by UNUSED).  Word headers have their own segment.
;
; HM	|-------------
;	|
; DPH	|-------------
;	|		word headers
; 0	|-------------
;
; EM	|-------------	end of memory
;	|		parsed string buffer
; PSB	|-------------
;	|		terminal input buffer
; TIB	|-------------
;	|		block buffer
; SFB	|-------------
; ESM	|-------------	end of system memory
;	|
; DPS	|-------------
;	|		system dictionary
; LIMIT |-------------
;	|		user variables
; R0	|-------------
;	|		return stack
; FS0	|-------------
;	|		separate fp stack
; S0	|-------------
;	|		parameter stack
; PAD	|-------------
;	|		word and number conversion area
; DP	|-------------
;	|		application dictionary
; 0100h |-------------

;
; Macro for generating word header
;

lastl	=	0		; initial link pointer (end of chain)

hdr	 macro	en,str,im,fl,axt
	local	a,b
				;; en  = enable hdr  0=disable
				;; str = name string
				;; im  = immediate
				;; fl  = application/system flag
				;; axt = alias xt

	 if	en		;; if header enable

	 if	fl
	aseg
	 else
	cseg
	 endif

cfadr	=	$		;; code field address

heads	segment	public		;; put heads in own segment
lnk	=	$		;; link address for next word

bits	=	0

	 if	im
bits	=	bits+40h	;; set immediate bit
	 endif

	 ifnb	<axt>		;; if alias
cfadr	=	axt		;; set cfa
bits	=	bits+80h	;; set alias bit
	 endif

	db	a		;; generate count byte
b	db	str		;; generate name
a	=	$-b+bits

	dw	lastl		;; generate link field
	dw	cfadr		;; for application words

lastl	=	lnk-horig

heads	ends

	 endif

	 if	fl		;; switch to system or application
	aseg
	 else
	cseg
	 endif

	 endm

; Macro to generate counted string

dcs	 macro	s1,s2,s3,s4	;; allow comma separated
	local	a,b
	db	a		;; generate count byte
b	db	s1
	 ifnb	<s2>
	db	s2
	 ifnb	<s3>
	db	s3
	 ifnb	<s4>
	db	s4
	 endif
	 endif
	 endif
a	=	$-b
	 endm

; Macro to switch between application and system memory

cseg	 macro
loc	=	$
	 if	loc ge (orig+sm)
pchi	=	$
	org	pclo
	 endif
	 endm

aseg	 macro
loc	=	$
	 if	loc lt (orig+sm)
pclo	=	$
	org	pchi
	 endif
	 endm

; Macro for I/O delay to same peripheral

iodelay	 macro
	jmp	short $+2
	 endm

; Macro for inline NEXT

nextt	 macro
	lodsw
	jmp	ax
	 endm

; Macro to ignore next 1 bytes

ignore1	 macro
	db	0a8h	;; test al,n
	 endm

; Macro to ignore next 2 bytes

ignore2	 macro
	db	0a9h	;; test ax,n
	 endm

; Macro to generate fdb table

gfdb	 macro
	local	a
a	=	fdbs
	 rept	nfd
	dw	a
a	=	a+fdsiz
	 endm
	 endm

; Assembly initialisation

dgroup	group	main,heads	; put in same segment for COM file

main	segment	byte public 'CODE'
main	ends

heads	segment	byte public
horig	=	$		; base of segment
	db	0		; dummy to prevent nfa at addr=0
heads	ends

main	segment
	assume	cs:main,ds:main,ss:main,es:main

	org	0
orig	equ	$

	org	$+tpa
pclo	=	$

	org	sm
pchi	=	$

;
; Code starts here
;
	cseg

start:	jmp	cldd

	org	start+3

; Video parameters - do not change

cattr	db	?,?		; current video attribute	0103
cmode	db	?,?		; current video mode, page	0105
wmin	db	?,?		; current window min (col,row)	0107
wmax	db	?,?		; current window max (col,row)	0109

	db	5 dup (?)	; reserved			010B

; Buffer for temporary asciiz strings

zb1	db	pfsiz dup (0)
zb2	db	pfsiz dup (0)

tmpstk	equ	$-cw		; temp stack for startup & EXE load

;	DXFORTH  ( -- minor major )

	hdr	1,'DXFORTH'
dxf:	mov	ax,rel
	mov	dx,rev

; NEXT is forth's address interpreter.  For primitives, it is usually
; compiled in-line for maximum speed.

dpush:	push	dx		; 2PUSH
apush:	push	ax		; 1PUSH

;	NOOP  ( -- )

	hdr	1,'NOOP'	; FIG
noop	equ	$

next:	nextt			; NEXT

imode	db	?,?		; initial video mode, page
iattr	db	?		; initial video attribute
	db	2 dup (?)	; spare

; Boot up variables used by COLD, must be in same order as USER variables

initu	equ	$		; <<< beginning data
	dw	3 dup (?)	; reserved for multitasking
is0	dw	?		; s0
ir0	dw	?		; r0
idp	dw	initdp		; dp
idps	dw	initdps		; dps
ivoc	dw	envir2		; voc-link
ifs0	dw	?		; fs0
idph	dw	initdph		; dph
initu2	equ	$		; <<< end data

esm	dw	?		; end of system memory
iboot	dw	?		; initial boot value
dosv	db	?,?		; DOS version (major,minor)
defdrv	db	?		; default drive
scaps	db	?		; COMPARE SEARCH case flag
cmdf	db	?		; command line flag
kbfn	db	?,?		; INT 16 functions
kbpend	db	?		; key pending (0 if none)
segfth	dw	?		; forth segment
ulimit	dw	?,?		; LIMIT for turnkey

; Misc. subroutines

;	set cursor position

scurs:	mov	ah,2
	ignore2

;	get cursor position

gcurs:	mov	ah,3

;	perform int 10h using current page number

videop:	mov	bh,cmode+1
	jmp	short video

;	perform INT 10h using current attribute

videoa:	mov	bh,cattr

;	perform INT 10h saving SI, BP

video:	push	si
	push	bp
	int	10h
	pop	bp
	pop	si
	ret

;	get video mode  AL=mode AH=page BH=cols

gmode:	mov	ah,0fh
	call	video
	xchg	bh,ah
	mov	word ptr cmode,ax	; save
	ret

;	perform INT 16h saving SI, BP

kbint:	push	si
	push	bp
	int	16h
	pop	bp
	pop	si
	ret

;	make uppercase AL

upc:	cmp	al,'a'
	jc	upc1
	cmp	al,'z'+1
	jnc	upc1
	xor	al,20h
upc1:	ret

;	move block downwards  AX = src, DI = dest, CX = cnt

bmovd:	push	ds
	pop	es
bmovd1:	xchg	si,ax
	rep	movsb
	mov	si,ax
	ret

;	move block up/down  AX = src, DI = dest, CX = cnt, DX = scratch

bmove:	mov	dx,di
	sub	dx,ax
	cmp	dx,cx
	jc	bmovu		; overlap and moving-up
;	jmp	movd

;	move block downwards  AX = src, DI = dest, CX = cnt
;	increment by word  n.b. does not propagate

movd:	push	ds
	pop	es
	xchg	si,ax
	shr	cx,1
	rep	movsw
	jnc	movd1
	movsb
movd1:	mov	si,ax
	ret

;	move block upwards  AX = src, DI = dest, CX = cnt

bmovu:	push	ds
	pop	es
	xchg	si,ax
	dec	cx
	add	di,cx
	add	si,cx
	inc	cx
	std
	rep	movsb
	cld
	mov	si,ax
	ret

;	runtime for colon definitions

docol:	sub	bp,cw		; push IP onto return stack
	mov	[bp],si
	pop	si		; get new IP from 'call'
	nextt

;	runtime for user variables

douse:	pop	bx
	mov	ax,upp
	add	ax,[bx]
	push	ax
	nextt

;	runtime for deferred words - equiv to @ EXECUTE

dodef:	pop	bx
	jmp	[bx]

;	(EXIT)  ( -- )		exit colon definition

	hdr	1,'(EXIT)'
exit:	mov	si,[bp]		; pop IP from return stack

;	UNNEST  ( -- )

	hdr	1,'UNNEST'
unnest:	add	bp,cw
	nextt

;	exit1

exit1:	push	si		; exit colon to code
	mov	si,[bp]
	add	bp,cw

;	EXECUTE  ( xt -- )

	hdr	1,'EXECUTE'
exec:	ret

;	clit  ( -- char )

	hdr	x,'CLIT'	; FIG
clit:	sub	ax,ax
	lodsb
	push	ax
	nextt

;	lit  ( -- n )

	hdr	x,'LIT'		; FIG
lit:	lodsw
	push	ax
	nextt

;	2lit  ( -- x1 x2 )

	hdr	x,'2LIT'
tlit:	lodsw
	mov	dx,ax
	lodsw
	push	ax
	push	dx
	nextt

;
;	Stack Manipulation
;
; SP@  SP!  RP@  RP!  >R  R>  R@  2>R  2R>  2R@  DROP  DUP  ?DUP
; SWAP  OVER  ROT  -ROT  ROLL  -ROLL  PICK  NIP  TUCK  2DROP  2DUP
; 2SWAP  2OVER  2ROT  DEPTH
;

;	SP@  ( -- addr )

	hdr	1,'SP@'
spat:	mov	ax,sp		; 'push sp' won't work on 8086
	jmp	apush

;	SP!  ( addr -- )

	hdr	1,'SP!'
spsto:	pop	ax
	mov	sp,ax
	nextt

;	RP@  ( -- addr )

	hdr	1,'RP@'
rpat:	push	bp
	nextt

;	RP!  ( addr -- )

	hdr	1,'RP!'
rpsto:	pop	bp
	nextt

;	>R  ( x -- )

	hdr	1,'>R'
tor:	sub	bp,cw
	pop	[bp]
	nextt

;	R>  ( -- x )

	hdr	1,'R>'
fromr:	push	[bp]
	add	bp,cw
	nextt

;	R@  ( -- x )

	hdr	1,'R@'
rat:	push	[bp]
	nextt

;	2>R  ( x1 x2 -- )

	hdr	1,'2>R'
ttor:	sub	bp,cw*2
	pop	[bp]
	pop	[bp+cw]
	nextt

;	2R>  ( -- x1 x2 )

	hdr	1,'2R>'
tfrom:	push	[bp+cw]
	push	[bp]
	add	bp,cw*2
	nextt

;	2R@  ( -- x1 x2 )

	hdr	1,'2R@'
trat:	push	[bp+cw]
	push	[bp]
	nextt

;	DROP  ( x -- )

	hdr	1,'DROP'
drop:	add	sp,cw
	nextt

;	DUP  ( x -- x x )

	hdr	1,'DUP'
dupp:	mov	bx,sp
	push	[bx]
	nextt

;	?DUP  ( x -- 0 | x x )

	hdr	1,'?DUP'
qdup:	mov	bx,sp
	mov	cx,[bx]
	jcxz	qdup1
	push	cx
qdup1:	nextt

;	SWAP  ( x1 x2 -- x2 x1 )

	hdr	1,'SWAP'
swap:	pop	dx
	pop	ax
	push	dx
	push	ax
	nextt

;	OVER  ( x1 x2 -- x1 x2 x1 )

	hdr	1,'OVER'
over:	mov	bx,sp
	push	[bx+cw]
	nextt

;	ROT  ( x1 x2 x3 -- x2 x3 x1 )

	hdr	1,'ROT'
rot:	pop	dx
	pop	bx
	pop	ax
	push	bx
	push	dx
	push	ax
	nextt

;	-ROT  ( x1 x2 x3 -- x3 x1 x2 )

	hdr	1,'-ROT'
drot:	pop	bx
	pop	ax
	pop	dx
	push	bx
	push	dx
	push	ax
	nextt

;	ROLL  ( xu xu-1 .. x0 u -- xu-1 .. x0 xu )

	hdr	1,'ROLL'
roll:	pop	cx
;;	jcxz	roll2
	mov	di,cx
	shl	di,1
	add	di,sp
	push	si
	lea	si,[di-cw]
	std
roll1:	mov	ax,[di]
	push	ds
	pop	es
	rep	movsw
	cld
	mov	[di],ax
	pop	si
roll2:	nextt

;	-ROLL  ( xu .. xu+1 x0 u -- x0 xu .. xu+1 )

	hdr	1,'-ROLL'
droll:	pop	cx
;;	jcxz	roll2
	mov	di,sp
	push	si
	lea	si,[di+cw]
	jmp	roll1

;	PICK  ( xu .. x1 x0 u -- xu .. x1 x0 xu )

	hdr	1,'PICK'
pick:	pop	bx
	shl	bx,1
	add	bx,sp
	push	[bx]
	nextt

;	NIP  ( x1 x2 -- x2 )

	hdr	1,'NIP'
nip:	pop	ax
	add	sp,cw
	push	ax
	nextt

;	TUCK  ( x1 x2 -- x2 x1 x2 )

	hdr	1,'TUCK'
tuck:	pop	ax
	pop	dx
	push	ax
	push	dx
	push	ax
	nextt

;	2DROP  ( xd -- )

	hdr	1,'2DROP'
tdrop:	add	sp,cw*2
	nextt

;	2DUP  ( xd -- xd xd )

	hdr	1,'2DUP'
tdup:	mov	bx,sp
	push	[bx+cw]
	push	[bx]
	nextt

;	2SWAP  ( xd1 xd2 -- xd2 xd1 )

	hdr	1,'2SWAP'
tswap:	pop	bx
	pop	cx
	pop	ax
	pop	dx
	push	cx
	push	bx
	push	dx
	push	ax
	nextt

;	2OVER  ( xd1 xd2 -- xd1 xd2 xd1 )

	hdr	1,'2OVER'
tover:	mov	bx,sp
	push	[bx+cw*3]
	push	[bx+cw*2]
	nextt

;	2ROT  ( xd1 xd2 xd3 -- xd2 xd3 xd1 )  5 roll 5 roll

	hdr	1,'2ROT'
trot:	call	docol
	dw	clit
	db	5
	dw	roll
	dw	clit
	db	5
	dw	roll
	dw	exit

;	DEPTH  ( -- +n ) 	sp@ s0 @ swap - 2/

	hdr	1,'DEPTH'
depth:	mov	bx,upp
	mov	ax,[bx+6]	; S0
	sub	ax,sp
	sar	ax,1
	jmp	apush

;
;	Memory & String Operations
;
; CSEG  SSEG  HSEG  @  !  C@  C!  2@  2!  @L  !L  C@L  C!L
; 2@L  2!L  +!  h@  h!  hc@  ON  OFF  BLANK  ERASE  FILL
; LFILL  CMOVE  CMOVE>  CMOVEL  MOVE  COUNT  PLACE  SCAN
; SKIP  -TRAILING  /STRING  COMPARE  SEARCH  +STRING  ZCOUNT
; ZPLACE  ASCIIZ
;

;	CSEG  ( -- x )		code segment

	hdr	1,'CSEG'
csegg:	push	cs
	nextt

;	SSEG  ( -- a-addr )	search segment

	hdr	1,'SSEG'
sseg:	call	dovar
sseg1	dw	?		; patched

;	HSEG  ( -- x )		heads segment

	hdr	1,'HSEG'
hseg:	call	docon
hseg1	dw	?		; patched

;	@  ( a-addr -- x )

	hdr	1,'@'
at:	pop	bx
	push	[bx]
	nextt

;	!  ( x a-addr -- )

	hdr	1,'!'
store:	pop	bx
	pop	[bx]
	nextt

;	C@  ( c-addr -- char )

	hdr	1,'C@'
cat:	pop	bx
	sub	ax,ax
	mov	al,[bx]
	push	ax
	nextt

;	C!  ( char c-addr -- )

	hdr	1,'C!'
cstor:	pop	bx
	pop	ax
	mov	[bx],al
	nextt

;	2@  ( a-addr -- x1 x2 )

	hdr	1,'2@'
tat:	pop	bx
tat1:	push	[bx+cw]
	push	[bx]
	nextt

;	2!  ( x1 x2 a-addr -- )

	hdr	1,'2!'
tstor:	pop	bx
	pop	[bx]
	pop	[bx+cw]
	nextt

;	@L  ( seg offs -- x )

	hdr	1,'@L'
atl:	pop	bx
	pop	ds
	push	[bx]
	mov	bx,cs
	mov	ds,bx
	nextt

;	!L  ( x seg offs -- )

	hdr	1,'!L'
storl:	pop	bx
	pop	ds
	pop	[bx]
	mov	bx,cs
	mov	ds,bx
	nextt

;	C@L  ( seg offs -- char )

	hdr	1,'C@L'
catl:	pop	bx
	pop	ds
	sub	ax,ax
	mov	al,[bx]
	mov	bx,cs
	mov	ds,bx
	push	ax
	nextt

;	C!L  ( char seg offs -- )

	hdr	1,'C!L'
cstorl:	pop	bx
	pop	ds
	pop	ax
	mov	[bx],al
	mov	bx,cs
	mov	ds,bx
	nextt

;	2@L  ( seg offs -- x1 x2 )

	hdr	1,'2@L'
tatl:	pop	bx
	pop	ds
	push	[bx+cw]
	push	[bx]
	mov	bx,cs
	mov	ds,bx
	nextt

;	2!L  ( x1 x2 seg offs -- )

	hdr	1,'2!L'
tstorl:	pop	bx
	pop	ds
	pop	[bx]
	pop	[bx+cw]
	mov	bx,cs
	mov	ds,bx
	nextt

;	+!  ( x a-addr -- )

	hdr	1,'+!'
pstor:	pop	bx
	pop	ax
	add	[bx],ax
	nextt

;	h@  ( h-addr -- x )

	hdr	x,'H@',,1
hat:	pop	bx
	push	word ptr hseg1
	push	bx
	jmp	atl

;	h!  ( x h-addr -- )
;
;	hdr	x,'H!',,1
;hstor:	pop	bx
;	push	word ptr hseg1
;	push	bx
;	jmp	storl

;	hc@  ( h-addr -- char )

	hdr	x,'HC@',,1
hcat:	pop	bx
	push	word ptr hseg1
	push	bx
	jmp	catl

;	ON  ( addr -- )		-1 swap !

	hdr	1,'ON'
on:	pop	bx
on1:	mov	word ptr [bx],-1
	nextt

;	OFF  ( addr -- )	0 swap !

	hdr	1,'OFF'
off:	pop	bx
off1:	mov	word ptr [bx],0
	nextt

;	BLANK  ( c-addr u -- )	bl fill

	hdr	1,'BLANK'
blank:	mov	al,20h
	ignore2

;	ERASE  ( addr u -- )	0 fill

	hdr	1,'ERASE'
erase:	mov	al,0
	ignore1

;	FILL  ( c-addr u char -- )

	hdr	1,'FILL'
fill:	pop	ax
	mov	cx,ds
	mov	es,cx
	pop	cx
	pop	di
fill1:	rep	stosb
	nextt

;	LFILL  ( seg offs u char -- )

	hdr	1,'LFILL'
lfill:	pop	ax
	pop	cx
	pop	di
	pop	es
	jmp	fill1

;	CMOVE  ( c-addr1 c-addr2 u -- )

	hdr	1,'CMOVE'
cmove:	pop	cx
	pop	di
	pop	ax
cmove1:	call	bmovd
	nextt

;	CMOVE>	( c-addr1 c-addr2 u -- )

	hdr	1,'CMOVE>'
cmovu:	pop	cx
	pop	di
	pop	ax
	call	bmovu
	nextt

;	CMOVEL  ( seg1 offs1 seg2 offs2 u -- )

	hdr	1,'CMOVEL'
cmovl:	mov	bx,ds
	pop	cx
	pop	di
	pop	es
	pop	ax
	pop	ds
	call	bmovd1
	mov	ds,bx
	nextt

;	MOVE  ( a-addr1 a-addr2 u -- )	>r 2dup u< if r> cmove> else r>
;					cmove then

	hdr	1,'MOVE'
move:	pop	cx
	pop	di
	pop	ax
	call	bmove
	nextt

;	COUNT  ( c-addr1 -- c-addr2 u )  dup 1+ swap c@

	hdr	1,'COUNT'
count:	pop	bx
	sub	ax,ax
	mov	al,[bx]
	inc	bx
	push	bx
	jmp	apush

;	PLACE  ( c-addr1 u c-addr2 -- )  2dup 2>r 1+ swap move 2r> c!

	hdr	1,'PLACE'
place:	pop	di
	pop	cx
	pop	ax
	push	cx
	push	di
	inc	di
	call	bmove
	jmp	cstor

;	SCAN  ( c-addr1 u1 char -- c-addr2 u2 )

	hdr	1,'SCAN'
scan:	pop	ax
	pop	cx
	jcxz	scan2
	pop	di
	mov	es,sseg1
	repnz	scasb
	jnz	scan1
	inc	cx
	dec	di
scan1:	push	di
scan2:	push	cx
	nextt

;	SKIP  ( c-addr1 u1 char -- c-addr2 u2 )

	hdr	1,'SKIP'
skip:	pop	ax
	pop	cx
	jcxz	skip2
	pop	di
	mov	es,sseg1
	rep	scasb
	jz	skip1
	inc	cx
	dec	di
skip1:	push	di
skip2:	push	cx
	nextt

;	-TRAILING  ( c-addr u1 -- c-addr u2 )

	hdr	1,'-TRAILING'
dtrai:	pop	cx
	jcxz	dtrai2
	pop	bx
	push	bx
	add	bx,cx
dtrai1:	dec	bx
	cmp	byte ptr [bx],20h
	jnz	dtrai2
	loop	dtrai1
dtrai2:	push	cx
	nextt

;	/STRING  ( c-addr1 u1 n -- c-addr2 u2 )  rot over + -rot -

	hdr	1,'/STRING'
sstr:	pop	ax
	mov	bx,sp
	sub	[bx],ax
	add	[bx+cw],ax
	nextt

;	-caps  ( -- )		disable caps COMPARE/SEARCH

	hdr	x,'-CAPS'
dcaps:	mov	al,0
	ignore2

;	CAPS  ( -- )		enable caps COMPARE/SEARCH

	hdr	1,'CAPS'
caps:	mov	al,1
	mov	scaps,al
	nextt

;	string compare

	cseg

cmpss:	cmp	byte ptr scaps,0
	jnz	cmpnc
	rep	cmpsb
	ret

cmpnc:	push	ax
	cmp	cx,cx	; clear S Z flags
	jcxz	cmpnc2
cmpnc1:	lodsb
	call	upc
	mov	ah,al
	mov	al,es:[di]
	inc	di
	call	upc
	cmp	ah,al
	jnz	cmpnc2
	loop	cmpnc1
cmpnc2:	pop	ax
	ret

;	COMPARE  ( c-addr1 u1 c-addr2 u2 -- -1 | 0 | 1 )

	hdr	1,'COMPARE'
cmpp:	mov	dx,si
	pop	cx
	pop	si
	pop	bx
	pop	di
	mov	es,sseg1
	sub	ax,ax
	cmp	cx,bx
	jz	cmpp2
	ja	cmpp1
	inc	ax
	jmp	short cmpp2

cmpp1:	dec	ax
	mov	cx,bx
cmpp2:	call	cmpss
	jz	cmpp3
	mov	ax,-1
	jnc	cmpp3
	neg	ax
cmpp3:	mov	si,dx
	push	ax
	jmp	dcaps

;	SEARCH	( c-addr1 u1 c-addr2 u2 -- c-addr3 u3 -1 | c-addr1 u1 0 )

	hdr	1,'SEARCH'
sear:	pop	bx
	pop	ax
	or	bx,bx	; u2=0
	jz	sear3	; match
	pop	dx
	pop	di
	push	di
	push	dx
	push	si
	xchg	si,ax
	mov	es,sseg1
	sub	dx,bx
	js	sear5	; u2<u1
sear1:	push	si
	push	di
	mov	cx,bx
	call	cmpss
	pop	di
	pop	si
	jz	sear2
	or	dx,dx
	jz	sear5
	inc	di
	dec	dx
	jmp	sear1

sear2:	pop	si
	pop	ax
	pop	ax
	add	dx,bx
	push	di
	push	dx
sear3:	mov	ax,-1
sear4:	push	ax
	jmp	dcaps

sear5:	pop	si
	sub	ax,ax
	jmp	sear4

;	+STRING  ( c-addr1 u1 c-addr2 u2 -- c-addr2 u3)
;					2swap swap 2over + 2 pick cmove +

	hdr	1,'+STRING'
pstr:	pop	dx
	pop	di
	pop	cx
	pop	ax
	push	di
	add	di,dx
	add	dx,cx
	push	dx
	call	movd
	nextt

;	ZCOUNT  ( c-addr -- c-addr u )  dup begin count until over - 1-

	hdr	1,'ZCOUNT'
zcnt:	pop	bx
	push	bx
	call	zcnt1
	jmp	apush

;	BX=addr AX=cnt

zcnt1:	sub	ax,ax
zcnt2:	cmp	byte ptr [bx],0
	jz	zcnt3
	inc	bx
	inc	ax
	jnz	zcnt2
zcnt3:	ret

;	ZPLACE	( c-addr1 u c-addr2 -- )  2dup + >r swap cmove 0 r> c!

	hdr	1,'ZPLACE'
zplace:	pop	di
	pop	cx
	pop	ax
	call	movd
	mov	byte ptr [di],0
	nextt

;	ASCIIZ  ( c-addr1 u -- c-addr2 )  (pfsiz-1) min zbuf @ zplace zbuf
;					  2@ tuck swap zbuf 2!

	hdr	1,'ASCIIZ'
asciiz:	call	docol
	dw	clit
	db	pfsiz-1
	dw	min
	dw	zbuf,at
	dw	zplace
	dw	zbuf,tat
	dw	tuck,swap
	dw	zbuf,tstor
	dw	exit

;
;	Comparison Functions
;
; D0=  0=  0<>  =  <>  0<  0>  <  >  U<  U>  MIN  MAX  UMIN  UMAX
; WITHIN  BETWEEN  D=  D0<  D<  DU<  DMIN  DMAX
;

;	D0=  ( d -- flag )	or 0=

	hdr	1,'D0='
dzequ:	pop	ax
	pop	bx
	or	ax,bx
	ignore1

;	0=  ( x -- flag )

	hdr	1,'0='
zequ:	pop	ax
	sub	ax,1
	sbb	ax,ax
	push	ax
	nextt

;	0<>  ( x -- flag )

	hdr	1,'0<>'
zneq:	pop	ax
zneq1:	neg	ax
	sbb	ax,ax
	push	ax
	nextt

;	=  ( x1 x2 -- flag )

	hdr	1,'='
equal:	pop	ax
	pop	bx
	sub	ax,bx
	sub	ax,1
	sbb	ax,ax
	push	ax
	nextt

;	<>  ( x1 x2 -- flag )

	hdr	1,'<>'
nequ:	pop	ax
	pop	bx
	sub	ax,bx
	neg	ax
	sbb	ax,ax
	push	ax
	nextt

;	0<  ( n -- flag )

	hdr	1,'0<'
zless:	pop	ax
	cwd
	push	dx
	nextt

;	0>  ( n -- flag )

	hdr	1,'0>'
zgrea:	pop	bx
	sub	ax,ax
	or	bx,bx
	jng	zgrea1
	dec	ax
zgrea1:	push	ax
	nextt

;	<  ( n1 n2 -- flag )

	hdr	1,'<'
less:	pop	bx
	pop	cx
	sub	ax,ax
	cmp	cx,bx
	jnl	less1
	dec	ax
less1:	push	ax
	nextt

;	>  ( n1 n2 -- flag )

	hdr	1,'>'
great:	pop	bx
	pop	cx
	sub	ax,ax
	cmp	cx,bx
	jng	great1
	dec	ax
great1:	push	ax
	nextt

;	U<  ( u1 u2 -- flag )

	hdr	1,'U<'
uless:	pop	ax
	pop	bx
	sub	bx,ax
	sbb	ax,ax
	push	ax
	nextt

;	U>  ( u1 u2 -- flag )

	hdr	1,'U>'
ugrea:	pop	ax
	pop	bx
	sub	ax,bx
	sbb	ax,ax
	push	ax
	nextt

;	MIN  ( n1 n2 -- n1 | n2 )  2dup > if swap then drop

	hdr	1,'MIN'
min:	pop	ax
	pop	bx
	cmp	ax,bx
	jl	min1
	mov	ax,bx
min1:	push	ax
	nextt

;	MAX  ( n1 n2 -- n1 | n2 )  2dup < if swap then drop

	hdr	1,'MAX'
max:	pop	ax
	pop	bx
	cmp	ax,bx
	jg	max1
	mov	ax,bx
max1:	push	ax
	nextt

;	UMIN  ( u1 u2 -- u1 | u2 )  2dup u> if swap then drop

	hdr	1,'UMIN'
umin:	pop	ax
	pop	bx
	cmp	ax,bx
	jc	umin1
	mov	ax,bx
umin1:	push	ax
	nextt

;	UMAX  ( u1 u2 -- u1 | u2 )  2dup u< if swap then drop

	hdr	1,'UMAX'
umax:	pop	ax
	pop	bx
	cmp	ax,bx
	ja	umax1
	mov	ax,bx
umax1:	push	ax
	nextt

;	WITHIN	( x1 x2 x3 -- flag )  over - >r - r> u<

	hdr	1,'WITHIN'
within:	pop	bx
	pop	ax
	pop	cx
	sub	cx,ax
	sub	bx,ax
	cmp	cx,bx
	sbb	ax,ax
	jmp	apush

	 if	1

;	BETWEEN	 ( x1 x2 x3 -- flag )  over - -rot - u< 0=

	hdr	1,'BETWEEN'
betw:	pop	bx
	pop	ax
	pop	cx
	sub	bx,ax
	sub	cx,ax
	cmp	bx,cx
	cmc
	sbb	ax,ax
	jmp	apush

	 endif

;	D=  ( d1 d2 -- flag )	d- d0=

	hdr	1,'D='
dequ:	call	docol
	dw	dsub
	dw	dzequ
	dw	exit

;	D0<  ( d -- flag )	nip 0<

	hdr	1,'D0<'
dzle:	pop	ax
	pop	bx
	cwd
	push	dx
	nextt

;	D<  ( d1 d2 -- flag )

	hdr	1,'D<'
dless:	pop	dx
	pop	bx
	pop	cx
	pop	ax
	sub	ax,bx
	sbb	cx,dx
	jl	dless1
	jmp	false

dless1:	jmp	true

;	DU<  ( ud1 ud2 -- flag )

	hdr	1,'DU<'
dules:	pop	dx
	pop	bx
	pop	cx
	pop	ax
	sub	ax,bx
	sbb	cx,dx
	sbb	ax,ax
	jmp	apush

;	DMIN  ( d1 d2 -- d1 | d2 )  2over 2over d< 0= if 2swap then 2drop

	hdr	1,'DMIN'
dmin:	call	docol
	dw	tover,tover
	dw	dless,zequ
dmin1	dw	zbran,dmin2
	dw	tswap
dmin2	dw	tdrop
	dw	exit

;	DMAX  ( d1 d2 -- d1 | d2 )  2over 2over d< if 2swap then 2drop

	hdr	1,'DMAX'
dmax:	call	docol
	dw	tover,tover
	dw	dless
	dw	bran,dmin1

;
;	Arithmetic and Logical Functions
;
; AND  OR  XOR	INVERT  NOT  S>D  D>S  NEGATE  ABS  DNEGATE  DABS  +
; -  M+  D+  D-  1+  2+  1-  2-  UM*  M*  UM/MOD  SM/REM  FM/MOD  M/MOD
; */MOD  */  /MOD  /  MOD  M*/  2*  2/  U2/  D2*  D2/  LSHIFT  RSHIFT
;

;	AND  ( x1 x2 -- x3 )

	hdr	1,'AND'
andd:	pop	ax
	pop	bx
	and	ax,bx
	push	ax
	nextt

;	OR  ( x1 x2 -- x3 )

	hdr	1,'OR'
orr:	pop	ax
	pop	bx
	or	ax,bx
	push	ax
	nextt

;	XOR  ( x1 x2 -- x3 )

	hdr	1,'XOR'
xorr:	pop	ax
	pop	bx
	xor	ax,bx
	push	ax
	nextt

;	INVERT  ( x1 -- x2 )	one's complement

	hdr	1,'INVERT'
invert:	pop	ax
	not	ax
	push	ax
	nextt

;	NOT  ( x1 -- x2 )		aka 0= not

	hdr	1,'NOT',,,zequ		; F79 NOT
nott	equ	zequ

;	S>D  ( n -- d )

	hdr	1,'S>D'
stod:	pop	ax
	cwd
	push	ax
	push	dx
	nextt

;	D>S  ( d -- n )			aka drop d>s

	hdr	1,'D>S',,,drop
dtos	equ	drop

;	NEGATE	( n1 -- n2 )

	hdr	1,'NEGATE'
negat:	pop	ax
	neg	ax
	push	ax
	nextt

;	ABS  ( n -- +n )

	hdr	1,'ABS'
abss:	pop	ax
	cwd
	xor	ax,dx
	sub	ax,dx
	jmp	apush

;	DNEGATE  ( d1 -- d2 )

	hdr	1,'DNEGATE'
dnegat:	pop	ax
dnegat1:pop	dx
	neg	ax
	neg	dx
	sbb	ax,0
	jmp	dpush

;	DABS  ( d -- +d )

	hdr	1,'DABS'
dabs:	pop	ax
	or	ax,ax
	js	dnegat1
	jmp	apush

;	+  ( x1 x2 -- x3 )

	hdr	1,'+'
plus:	pop	ax
	pop	bx
	add	ax,bx
	push	ax
	nextt

;	-  ( x1 x2 -- x3 )

	hdr	1,'-'
subb:	pop	dx
	pop	ax
	sub	ax,dx
	push	ax
	nextt

;	M+  ( xd1 n -- xd2 )	s>d d+

	hdr	1,'M+'
mplus:	pop	ax
        cwd
	ignore2

;	D+  ( xd1 xd2 -- xd3 )

	hdr	1,'D+'
dplus:	pop	dx
	pop	ax
	mov	bx,sp
	add	[bx+cw],ax
	adc	[bx],dx
	nextt

;	D-  ( xd1 xd2 -- xd3 )	dnegate d+

	hdr	1,'D-'
dsub:	pop	dx
	pop	ax
	mov	bx,sp
	sub	[bx+cw],ax
	sbb	[bx],dx
	nextt

;	1+  ( x1 -- x2 )

	hdr	1,'1+'
onep:	pop	ax
	inc	ax
	push	ax
	nextt

;	2+  ( x1 -- x2 )

	hdr	1,'2+'
twop:	pop	ax
	add	ax,2
	push	ax
	nextt

;	1-  ( x1 -- x2 )

	hdr	1,'1-'
onem:	pop	ax
	dec	ax
	push	ax
	nextt

;	2-  ( x1 -- x2 )

	hdr	1,'2-'
twom:	pop	ax
	sub	ax,2
	push	ax
	nextt

;	UM*  ( u1 u2 -- ud )

	hdr	1,'UM*'
umstr:	pop	ax
	pop	bx
	mul	bx
	push	ax
	push	dx
	nextt

;	M*  ( n1 n2 -- d )

	hdr	1,'M*'
mstar:	pop	ax
	pop	bx
	imul	bx
	push	ax
	push	dx
	nextt

;	*  ( x1 x2 -- x3 )	um* drop

	hdr	1,'*'
star:	pop	ax
	pop	bx
	mul	bx
	push	ax
	nextt

;	UM/MOD	( ud u1 -- u2 u3 )

	hdr	1,'UM/MOD'
umslm:	pop	bx
	pop	dx
	pop	ax
	cmp	dx,bx		; divide zero or overflow
	jnc	cverr
	div	bx
	push	dx
	push	ax
	nextt

	cseg

msm:	mov	di,dx
	mov	cx,bx
	or	dx,dx
	jns	msm1
	sub	dx,dx
	neg	ax
	sbb	dx,di
msm1:	or	bx,bx
	jns	msm2
	neg	bx
msm2:	cmp	dx,bx		; overflow?
	jnc	cverr0
	div	bx
	or	di,di		; sign remainder
	jns	msm3
	neg	dx
msm3:	xor	di,cx		; sign quotient
	jns	msm4
	neg	ax
	ret

msm4:	pop	di
	jmp	dpush

;	math or conversion error - set regs to -1

cverr0:	pop	ax
cverr:	mov	ax,-1
	cwd
	jmp	dpush

;	SM/REM	( d n1 -- n2 n3 )

	hdr	1,'SM/REM'
smrem:	pop	bx
	pop	dx
	pop	ax
smrem1:	call	msm
	jmp	dpush

;	FM/MOD	( d n1 -- n2 n3 )

	hdr	1,'FM/MOD'
fmsmd:	pop	bx
	pop	dx
	pop	ax
fmsmd1:	call	msm
	or	dx,dx		; floor
	jz	fmsmd2
	dec	ax
	add	dx,cx
	xor	di,ax		; overflow?
	js	cverr
fmsmd2:	jmp	dpush

;	M/MOD  ( d n1 -- n2 n3 )	fm/mod|sm/rem

	hdr	1,'M/MOD',,,msmod
	 if	floord
msmod	equ	fmsmd
	 else
msmod	equ	smrem
	 endif

;	*/MOD  ( n1 n2 n3 -- n4 n5 )	>r m* r> m/mod

	hdr	1,'*/MOD'
ssmod:	pop	bx
	pop	ax
	pop	cx
	imul	cx
	 if	floord
	jmp	fmsmd1
	 else
	jmp	smrem1
	 endif

;	*/  ( n1 n2 n3 -- n4 )		*/mod nip

	hdr	1,'*/'
ssla:	call	docol
	dw	ssmod,nip
	dw	exit

;	/MOD  ( n1 n2 -- n3 n4 )	>r s>d r> m/mod

	hdr	1,'/MOD'
slmod:	pop	bx
	pop	ax
	cwd
	 if	floord
	jmp	fmsmd1
	 else
	jmp	smrem1
	 endif

;	/  ( n1 n2 -- n3 )		/mod nip

	hdr	1,'/'
slash:	call	docol
	dw	slmod,nip
	dw	exit

;	MOD  ( n1 n2 -- n3 )		/mod drop

	hdr	1,'MOD'
modd:	call	docol
	dw	slmod,drop
	dw	exit

;	M*/  ( d1 n1 +n2 -- d2 )	>r 2dup xor swap abs >r -rot dabs
;					swap r@ um* rot r> um* rot 0 d+ r@
;					um/mod -rot r> um/mod nip swap rot
;					0< if dnegate then

	hdr	1,'M*/'
mssl:	pop	di
	pop	bx
	pop	cx
	pop	ax
	mov	dx,cx
	xor	dx,bx
	pushf
	or	bx,bx
	jns	mssl1
	neg	bx
mssl1:	or	cx,cx
	jns	mssl2
	neg	cx
	neg	ax
	sbb	cx,0
mssl2:	mul	bx
	push	dx
	xchg	cx,ax
	mul	bx
	pop	bx
	add	ax,bx
	adc	dx,0
	cmp	dx,di
	jnc	mssl5
	div	di
	xchg	ax,cx
	cmp	dx,di
	jnc	mssl5
	div	di
	popf
	jns	mssl4
	 if	floord
	or	dx,dx
	jz	mssl3
	add	ax,1
	adc	cx,0
	 endif
mssl3:	neg	cx
	neg	ax
	sbb	cx,0
mssl4:	push	ax
	push	cx
	nextt

mssl5:	jmp	cverr0

;	2*  ( x1 -- x2 )

	hdr	1,'2*'
tstar:	pop	ax
	shl	ax,1
	push	ax
	nextt

;	2/  ( n1 -- n2 )

	hdr	1,'2/'
twodiv:	pop	ax
	sar	ax,1
	push	ax
	nextt

;	U2/  ( u1 -- u2 )

	hdr	1,'U2/'
utdiv:	pop	ax
	shr	ax,1
	push	ax
	nextt

;	D2*  ( xd1 -- xd2 )

	hdr	1,'D2*'
dtstr:	pop	ax
	pop	dx
	shl	dx,1
	rcl	ax,1
	jmp	dpush

;	D2/  ( d1 -- d2 )

	hdr	1,'D2/'
dtdiv:	pop	ax
	pop	dx
	sar	ax,1
	rcr	dx,1
	jmp	dpush

;	LSHIFT	( x1 u -- x2 )

	hdr	1,'LSHIFT'
lsh:	pop	cx
	pop	ax
	shl	ax,cl
	push	ax
	nextt

;	RSHIFT	( x1 u -- x2 )

	hdr	1,'RSHIFT'
rsh:	pop	cx
	pop	ax
	shr	ax,cl
	push	ax
	nextt

;
;	Numeric Conversion
;
; DECIMAL  HEX  digit  >NUMBER  NUMBER?  <#  #>  #  HOLD  #S  SIGN
;

;	DECIMAL  ( -- ) 	10 base !

	hdr	1,'DECIMAL'
decim:	call	docol
	dw	clit
	db	10
	dw	base,store
	dw	exit

;	HEX  ( -- )		16 base !

	hdr	1,'HEX'
hex:	call	docol
	dw	clit
	db	16
	dw	base,store
	dw	exit

;	digit  ( char base -- u true | false )

	hdr	x,'DIGIT'
digit:	pop	dx
	pop	ax
	call	upc
	sub	al,'0'
	jc	digit2
	cmp	al,10
	jc	digit1
	sub	al,7
	cmp	al,10
	jc	digit2
digit1:	cmp	al,dl
	jnc	digit2
	sub	ah,ah
	push	ax
	jmp	true

digit2:	jmp	false

;	>NUMBER  ( d1 addr1 u1 -- d2 addr2 u2 )
;				begin dup while over c@ base @ digit while
;				>r 2swap r> swap base @ um* drop rot base @
;				um* d+ 2swap 1 /string 1 dpl +! repeat then

	hdr	1,'>NUMBER'
tonum:	call	docol
tonum1	dw	dupp		; begin
	dw	zbran,tonum2	; while
	dw	over,cat
	dw	base,at
	dw	digit
	dw	zbran,tonum2	; while
	dw	tor
	dw	tswap,fromr
	dw	swap
	dw	base,at
	dw	umstr,drop
	dw	rot
	dw	base,at
	dw	umstr
	dw	dplus
	dw	tswap
	dw	one,sstr
	dw	one,dpl,pstor
	dw	bran,tonum1	; repeat
tonum2	dw	exit		; then

;	NUMBER?  ( c-addr u -- d -1 | 0 )
;				over c@ [char] - = over 0> and dup >r 1
;				and /string over c@ [char] . > and 0 0
;				2swap ?dup if >number dpl on dup if 1-
;				over c@ [char] . - or dpl off then while
;				then r> 2drop 2drop false else drop r> if
;				dnegate then true then

	hdr	1,'NUMBER?'
numq:	call	docol		; convert string to double number
	dw	over,cat
	dw	clit
	db	'-'
	dw	equal
	dw	over,zgrea
	dw	andd
	dw	dupp,tor
	dw	one,andd
	dw	sstr
	dw	over,cat
	dw	clit
	db	'.'
	dw	great,andd
	dw	zero,zero
	dw	tswap
	dw	qdup
	dw	zbran,numq2
	dw	tonum
	dw	dpl,on
	dw	dupp
	dw	zbran,numq1
	dw	onem
	dw	over,cat
	dw	clit
	db	'.'
	dw	subb,orr
	dw	dpl,off
numq1	dw	zbran,numq3
numq2	dw	fromr
	dw	tdrop,tdrop
	dw	false
	dw	bran,numq5
numq3	dw	drop
	dw	fromr
	dw	zbran,numq4
	dw	dnegat
numq4	dw	true
numq5	dw	exit

;	<#  ( -- )		pad hld !

	hdr	1,'<#'
bdigs:	call	docol
	dw	pad
	dw	hld,store
	dw	exit

;	#>  ( xd -- c-addr u )	2drop hld @ pad over -

	hdr	1,'#>'
edigs:	call	docol
	dw	tdrop
	dw	hld,at
	dw	pad
	dw	over
	dw	subb
	dw	exit

;	#  ( ud1 -- ud2 )	0 base @ um/mod >r base @ um/mod r>
;				rot 9 over < if 7 + then [char] 0 + hold

	hdr	1,'#'
dig:	pop	ax
	pop	bx
	mov	di,upp
	add	di,24		; BASE
	sub	dx,dx
	div	word ptr [di]
	xchg	ax,bx
	div	word ptr [di]
	push	ax
	push	bx
	cmp	dl,10
	jc	dig1
	add	dl,7
dig1:	add	dl,'0'
	push	dx
;	jmp	hold

;	HOLD  ( char -- )	-1 hld +! hld @ dup dp @ u<
;				abort" numeric buffer overflow" c!

	hdr	1,'HOLD'
hold:	call	docol
	dw	true,hld,pstor
	dw	hld,at,dupp
	dw	dpp,at,uless
	dw	pabq
	dcs	'numeric buffer overflow'
	dw	cstor
	dw	exit

;	#S  ( ud -- 0 0 )	begin # 2dup d0= until

	hdr	1,'#S'
digs:	call	docol
digs1	dw	dig
	dw	tdup
	dw	dzequ
	dw	zbran,digs1
	dw	exit

;	SIGN  ( n -- )		0< if [char] - hold then

	hdr	1,'SIGN'
sign:	call	docol
	dw	zless
	dw	zbran,sign1
	dw	clit
	db	'-'
	dw	hold
sign1	dw	exit

;
;	Control Structures
;
; (of)  branch  ?branch  (loop)  (+loop)  UNLOOP  (?do)  (do)
; (leave)  bal  +BAL  -BAL  ?BAL  BEGIN  FORWARD  BACK  THEN
; IF  AHEAD  ELSE  UNTIL  AGAIN  WHILE  REPEAT  lv  DO  ?DO
; I  I'  J  LEAVE  LOOP  +LOOP  CS-PICK  CS-ROLL  CS-DROP
; cf0 #cs  CS-PUSH  CS-POP  CS-MARK  CS-TEST  COND  THENS
; CASE  ENDCASE  OF  ENDOF  [IF]  [ELSE]  [THEN]
;

;	(of)  ( x1 x2 -- | x1 )

	hdr	x,'(OF)'
pof:	pop	bx
	pop	ax
	cmp	ax,bx
	jz	zbran1
	push	ax

;	branch	( -- )

	hdr	x,'BRANCH'
bran:	mov	si,[si]
	nextt

;	?branch  ( flag -- )

	hdr	x,'?BRANCH'
zbran:	pop	cx
	jcxz	bran
zbran1:	add	si,cw
	nextt

;	(loop)  ( -- )

	hdr	x,'(LOOP)'
xloop:	mov	ax,1
	ignore1

;	(+loop)  ( n -- )

	hdr	x,'(+LOOP)'
xploo:	pop	ax
	add	[bp],ax
	jno	bran
	add	si,cw
;	jmp	unloop

;	UNLOOP	( -- )

	hdr	1,'UNLOOP'
unloo:	add	bp,cw*2
	nextt

;	(?do)  ( x1 x2 -- )

	hdr	x,'(?DO)'
xqdo:	pop	dx
	pop	bx
	cmp	bx,dx
	jz	bran
	ignore2

;	(do)  ( x1 x2 -- )

	hdr	x,'(DO)'
xdo:	pop	dx
	pop	bx
	xchg	bp,sp
	add	bx,8000h
	push	bx
	sub	dx,bx
	push	dx
	xchg	bp,sp
	lodsw
	nextt

;	(leave)  ( -- )

	hdr	x,'(LEAVE)'
pleav:	add	bp,cw*2
	mov	bx,[si]
	mov	si,[bx]
	nextt

;	bal  ( -- addr )

	hdr	x,'BAL',,1
bal:	call	dovar
bal1	dw	?

;	+BAL  ( -- )			1 bal +!

	hdr	1,'+BAL',,1
pbal:	inc	word ptr bal1
	nextt

;	-BAL  ( -- )			-1 bal +!

	hdr	1,'-BAL',,1
dbal:	dec	word ptr bal1
	nextt

;	?BAL  ( flag -- )		checking @ 0<> and
;					abort" definition unbalanced'

	hdr	1,'?BAL',,1
qbal:	call	docol
	dw	check,at
	dw	zneq,andd
	dw	pabq
	dcs	'definition unbalanced'
	dw	exit

;	BEGIN  ( -- dest )		?comp here +bal ;immediate

	hdr	1,'BEGIN',1,1
begin:	call	docol
	dw	qcomp
	dw	here
	dw	pbal
	dw	exit

;	FORWARD  ( -- orig )		postone begin 0 ,

	hdr	1,'FORWARD',,1
fwd:	call	docol
	dw	begin
	dw	zero
	dw	comma
	dw	exit

;	BACK  ( dest -- )		dup @ 0= ?bal , -bal

	hdr	1,'BACK',,1
back:	call	docol
	dw	dupp,at
	dw	zequ,qbal
	dw	comma
	dw	dbal
	dw	exit

;	THEN  ( orig -- )		dup @ ?bal here swap ! -bal
;					;immediate

	hdr	1,'THEN',1,1
then:	call	docol
	dw	dupp,at,qbal
	dw	here
	dw	swap,store
	dw	dbal
	dw	exit

;	IF  ( -- orig )			postpone ?branch forward
;					;immediate

	hdr	1,'IF',1,1
iff:	call	docol
	dw	comp,zbran
	dw	fwd
	dw	exit

;	AHEAD  ( -- orig )		postpone branch forward
;					;immediate

	hdr	1,'AHEAD',1,1
ahead:	call	docol
	dw	comp,bran
	dw	fwd
	dw	exit

;	ELSE  ( orig1 -- orig2 )	postpone ahead swap postpone then
;					;immediate

	hdr	1,'ELSE',1,1
elsee:	call	docol
	dw	ahead
	dw	swap
	dw	then
	dw	exit

;	UNTIL  ( dest -- )		postpone ?branch back
;					;immediate

	hdr	1,'UNTIL',1,1
until:	mov	ax,offset zbran
until1:	push	ax
	call	docol
	dw	comxt
	dw	back
	dw	exit

;	AGAIN  ( dest -- )		postpone branch back
;					;immediate

	hdr	1,'AGAIN',1,1
again:	mov	ax,offset bran
	jmp	until1

;	WHILE  ( dest -- orig dest )	postpone if swap ;immediate

	hdr	1,'WHILE',1,1
whilee:	call	docol
	dw	iff
	dw	swap
	dw	exit

;	REPEAT	( orig dest -- )	postpone again postpone then
;					;immediate

	hdr	1,'REPEAT',1,1
repeatt:call	docol
	dw	again
	dw	then
	dw	exit

;	lv  ( -- addr )			0 value lv

	hdr	x,'LV',,1
lvv:	call	doval
	dw	0

;	DO  ( -- orig dest )		?comp postpone (do) lv forward
;					dup to lv postpone begin ;immediate

	hdr	1,'DO',1,1
do:	mov	ax,offset xdo
do1:	push	ax
	call	docol
	dw	qcomp
	dw	comxt
	dw	lvv
	dw	fwd
	dw	dupp
	dw	pto,lvv
	dw	begin
	dw	exit

;	?DO  ( -- orig dest )		?comp postpone (?do) lv forward
;					dup to lv postpone begin ;immediate

	hdr	1,'?DO',1,1
qdo:	mov	ax,offset xqdo
	jmp	do1

;	I  ( -- x )

	hdr	1,'I'
ido:	mov	ax,[bp]
	add	ax,[bp+cw]
	push	ax
	nextt

	 if	0

;	I'  ( -- x )

	hdr	1,'I'''
idot:	mov	ax,[bp+cw]
	xor	ax,8000h
	push	ax
	nextt

	 endif

;	J  ( -- x )

	hdr	1,'J'
jdo:	mov	ax,[bp+cw*2]
	add	ax,[bp+cw*3]
	push	ax
	nextt

;	LEAVE  ( -- )			postpone (leave) lv dup @ ?bal ,

	hdr	1,'LEAVE',1,1
leavee:	call	docol
	dw	comp,pleav
	dw	lvv
	dw	dupp,at,qbal
	dw	comma
	dw	exit

;	LOOP  ( addr1 addr2 -- )	postpone (loop) back
;					postpone then to lv ;immediate

	hdr	1,'LOOP',1,1
loopp:	mov	ax,offset xloop
loopp1:	push	ax
	call	docol
	dw	comxt
	dw	back
	dw	then
	dw	pto,lvv
	dw	exit

;	+LOOP  ( addr1 addr2 -- )	postpone (+loop) back
;					postpone then to lv ;immediate

	hdr	1,'+LOOP',1,1
ploop:	mov	ax,offset xploo
	jmp	loopp1

	 if	cfs

;	CS-PICK				pick +bal

	hdr	1,'CS-PICK',,1
cspic:	inc     word ptr bal1
	jmp	pick

;	CS-ROLL				aka roll cs-roll

	hdr	1,'CS-ROLL',,,roll
csrol	equ	roll

;	CS-DROP				drop -bal

	hdr	1,'CS-DROP',,1
csdro:	pop	ax
	jmp	dbal

;	cf0				control flow stack base

	hdr	x,'CF0',,1
cfz:	call	dovar
cfz1	dw	?

;	#cs  ( -- cells )		sp@ cf0 @ - negate 2/ 1- 0 max

	hdr	x,'#CS',,1
ncs:	mov	ax,cfz1
	sub	ax,sp
	sar	ax,1
	dec	ax
	jns	ncs1
	sub	ax,ax
ncs1:	jmp	apush

;	CS-PUSH				#cs -roll

	hdr	1,'CS-PUSH',,1
cspush:	call	docol
	dw	ncs
	dw	droll
	dw	exit

;	CS-POP				#cs roll

	hdr	1,'CS-POP',,1
cspop:	call	docol
	dw	ncs
	dw	roll
	dw	exit

;	CS-MARK				0 +bal

	hdr	1,'CS-MARK',,1
csm:	sub	ax,ax
	push	ax
	jmp	pbal

;	CS-TEST				dup 0<>

	hdr	1,'CS-TEST',,1
cstes:	pop	ax
	push	ax
	jmp	zneq1

;	COND				aka cs-mark cond immediate

	hdr	1,'COND',1,,csm
cond	equ	csm

;	THENS				begin cs-test while postpone then
;					repeat cs-drop ;immediate

	hdr	1,'THENS',1,1
thens:	call	docol
thens1	dw	cstes
	dw	zbran,thens2
	dw	then
	dw	bran,thens1
thens2	dw	csdro
	dw	exit

	 else

;	COND				0 +bal ;immediate

	hdr	1,'COND',1,1
cond:	sub	ax,ax
	push	ax
	jmp	pbal

;	THENS				begin ?dup while postpone then
;					repeat -bal ;immediate

	hdr	1,'THENS',1,1
thens:	call	docol
thens1	dw	qdup
	dw	zbran,thens2
	dw	then
	dw	bran,thens1
thens2	dw	dbal
	dw	exit

	 endif

;	CASE  ( -- sys )		?comp postpone cond ;immediate

	hdr	1,'CASE',1,1
casee:	call	docol
	dw	qcomp
	dw	cond
	dw	exit

;	ENDCASE  ( sys -- )		postpone drop postpone thens
;					;immediate

	hdr	1,'ENDCASE',1,1
endc:	call	docol
	dw	comp,drop
	dw	thens
	dw	exit

;	OF  ( -- addr )			postpone (of) forward ;immediate

	hdr	1,'OF',1,1
of:	call	docol
	dw	comp,pof
	dw	fwd
	dw	exit

;	ENDOF  ( addr1 -- addr2 )	aka else endof

	hdr	1,'ENDOF',1,,elsee
endof	equ	elsee

;	[IF]  ( flag -- )	0= if postpone [else] then ;immediate

	hdr	1,'[IF]',1,1
pif:	pop	cx
	jcxz	pels
	nextt

;	[ELSE]	( -- )		1 begin token 2dup upper dup if 2dup
;				s" [IF]" compare if 2dup s" [ELSE]"
;				compare if s" [THEN]" compare 0= else
;				2drop dup 1 = then else 2drop 1 then +
;				else 2drop refill and then ?dup 0= until
;				;immediate

	hdr	1,'[ELSE]',1,1
pels:	call	docol
	dw	one
pels1	dw	token
	 if	ucase
	dw	tdup,upper
	 endif
	dw	dupp
	dw	zbran,pels6
	dw	tdup
	dw	psqot
	dcs	'[IF]'
	dw	cmpp
	dw	zbran,pels4
	dw	tdup
	dw	psqot
	dcs	'[ELSE]'
	dw	cmpp
	dw	zbran,pels2
	dw	psqot
	dcs	'[THEN]'
	dw	cmpp,zequ
	dw	bran,pels3
pels2	dw	tdrop
	dw	dupp,one,equal
pels3	dw	bran,pels5
pels4	dw	tdrop,one
pels5	dw	plus
	dw	bran,pels7
pels6	dw	tdrop
	dw	refil,andd
pels7	dw	qdup,zequ
	dw	zbran,pels1
	dw	exit

;	[THEN]	( -- )		aka noop [then] immediate

	hdr	1,'[THEN]',1,,noop
pthen	equ	next

;	(D.)  ( d -- c-addr u )	 tuck dabs <# #s rot sign #>

	hdr	1,'(D.)'
pddot:	call	docol
	dw	tuck
	dw	dabs
	dw	bdigs
	dw	digs
	dw	rot,sign
	dw	edigs
	dw	exit

;	D.R  ( d u -- ) 	>r (d.) r> over - spaces type

	hdr	1,'D.R'
ddotr:	call	docol
	dw	tor
	dw	pddot
ddotr1	dw	fromr
	dw	over,subb
	dw	spacs
	dw	typee
	dw	exit

;	D.  ( d -- )		0 d.r space

	hdr	1,'D.'
ddot:	call	docol
	dw	zero,ddotr
	dw	space
	dw	exit

;	.R  ( n u -- )		>r s>d r> d.r

	hdr	1,'.R'
dotr:	pop	bx
	pop	ax
	cwd
	push	ax
	push	dx
	push	bx
	jmp	ddotr

;	U.R  ( u1 u2 -- )	0 swap d.r

	hdr	1,'U.R'
udotr:	pop	ax
	sub	dx,dx
	push	dx
	push	ax
	jmp	ddotr

;	U.  ( u -- )		0 d.

	hdr	1,'U.'
udot:	sub	ax,ax
	push	ax
	jmp	ddot

;	.  ( n -- )		s>d d.

	hdr	1,'.'
dot:	pop	ax
	cwd
	push	ax
	push	dx
	jmp	ddot

;	?  ( addr -- )		@ .

	hdr	1,'?'
ques:	pop	bx
	push	[bx]
	jmp	dot

;	DOSVER  ( -- minor major )

	hdr	1,'DOSVER'
dosver:	mov	ax,word ptr dosv
	sub	dx,dx
	xchg	dl,ah
	jmp	dpush

;	BDOS  ( DX n -- AL )

	hdr	1,'BDOS'
bdos:	pop	ax
	pop	dx
	sub	bx,bx
	sub	cx,cx
	xchg	ah,al
	int	21h
	sub	ah,ah
	jmp	apush

	cseg

regs	dw	10 dup (?)	; cpu registers

stkfth	dw	?

;	INTCALL  ( u -- )

	hdr	1,'INTCALL'
intc:	pop	ax
	push	si
	push    bp
	push    cs
	mov	byte ptr intc1+1,al
	mov	si,offset regs
	lodsw
	push	ax	; AX
	lodsw
	mov	bx,ax
	lodsw
	mov	cx,ax
	lodsw
	mov	dx,ax
	lodsw
	mov	bp,ax
	lodsw
	push	ax	; SI
	lodsw
	mov	di,ax
	lodsw
	push	ax	; DS
	lodsw
	mov	es,ax
	pop     ds
	pop	si
	pop	ax
	mov	cs:stkfth,sp
intc1:	int	0
	cli
	mov	ss,cs:segfth	; restore SS:SP
	mov	sp,cs:stkfth	; for DOS 2.x
	sti
	pushf
	push	es
	push	di
	push	cs
	pop	es
	mov	di,offset regs
	cld
	stosw
	mov	ax,bx
	stosw
	mov	ax,cx
	stosw
	mov	ax,dx
	stosw
	mov	ax,bp
	stosw
	mov	ax,si
	stosw
	pop	ax	; DI
	stosw
	mov	ax,ds
	stosw
	pop	ax	; ES
	stosw
	pop	ax	; flags
	stosw
	pop	ds
	pop	bp
	pop	si
	nextt

	hdr	1,'''FLAGS'
tfl:	mov	al,18
	ignore2

	hdr	1,'''ES'
tes:	mov	al,16
	ignore2

	hdr	1,'''DS'
tds:	mov	al,14
	ignore2

	hdr	1,'''DI'
tdi:	mov	al,12
	ignore2

	hdr	1,'''SI'
tsi:	mov	al,10
	ignore2

	hdr	1,'''BP'
tbp:	mov	al,8
	ignore2

	hdr	1,'''DX'
tdx:	mov	al,6
	ignore2

	hdr	1,'''CX'
tcx:	mov	al,4
	ignore2

	hdr	1,'''BX'
tbx:	mov	al,2
	ignore2

	hdr	1,'''AX'
tax:	mov	al,0
	cbw
	add	ax,offset regs
	jmp	apush

;	DOSERR?  ( -- ior )	'flags @ 1 and if 'ax @ else 0 then

	hdr	1,'DOSERR?'
doserr:	test	byte ptr regs+18,1
	jz	doserr2
	mov	ax,regs
	stc

;	test for DOS error

doserr1:jnc	doserr2
	mov	ah,0feh		; convert DOS error# to ior value
	jmp	apush

doserr2:jmp	zero

; Port fetch and store instructions

;	PC@  ( p-addr -- 8bit )

	hdr	1,'PC@'		; FIG P@
pcat:	pop	dx
	sub	ax,ax
	in	al,dx
	push	ax
	nextt

;	PC!  ( 8bit p-addr -- )

	hdr	1,'PC!'		; FIG P!
pcsto:	pop	dx
	pop	ax
	out	dx,al
	nextt

;	P@  ( p-addr -- 16bit )

	hdr	1,'P@'
pat:	pop	dx
	in	ax,dx
	push	ax
	nextt

;	P!  ( 16bit p-addr -- )

	hdr	1,'P!'
psto:	pop	dx
	pop	ax
	out	dx,ax
	nextt

	cseg

beep0:	mov	ax,75		; (BEEP)
	push	ax
	mov	cx,600
	call	sound1

ms0:	pop	cx		; (MS)
	push	tnext1

;	delay (ms) in CX	; uses timer 0

ms1:	jcxz	ms5
ms2:	test	cl,3		; PAUSE each 4mS for
	jnz	ms3		; multitasking
	push	cx
	call	docol
	dw	pause
	dw	exit1
	pop	cx
ms3:	call	ms6
	mov	dx,bx
ms4:	call	ms6
	sub	bx,dx
	cmp	bx,-2385
	jnc	ms4
	loop	ms2
ms5:	ret

ms6:	pushf			; clear interrupts
	cli			; during CTC read
	sub	al,al
	out	43h,al
	iodelay
	in	al,40h
	mov	bl,al
	iodelay
	in	al,40h
	mov	bh,al
	popf
	ret

sound0:	pop	ax		; (SOUND)
	pop	cx
	push	tnext1

sound1:	push	ax		; uses timer 2
	mov	dx,12h
	cmp	dx,cx
	jnc	sound2		; trap zero/overflow
	mov	ax,34ddh
	div	cx
	mov	cx,ax
	in	al,61h
	or	al,3		; enable spkr
	iodelay
	out	61h,al
	pushf			; clear interrupts
	cli			; during CTC write
	mov	al,0b6h
	out	43h,al
	mov	al,cl
	iodelay
	out	42h,al
	mov	al,ch
	iodelay
	out	42h,al
	popf
sound2:	pop	cx
	call	ms1
	in	al,61h
	and	al,0fch		; disable spkr
	iodelay
	out	61h,al
	ret

;	MS  ( ms -- )

	hdr	1,'MS'
ms:	call	dodef
	dw	ms0

;	SOUND  ( freq ms -- )

	hdr	1,'SOUND'
sound:	call	dodef
	dw	sound0

;	BEEP  ( -- )

	hdr	1,'BEEP'
beep:	call	dodef
	dw	beep0

;	AT-XY  ( x y -- )	position cursor at col x, row y

	hdr	1,'AT-XY'	; not bounds checked - allows any
atxy:	pop	ax		; BIOS permissible value
	pop	dx
	mov	dh,al
	add	dl,wmin
	add	dh,wmin+1
atxy1:	call	scurs
	nextt

;	GET-XY  ( -- x y )	get cursor position col x, row y

	hdr	1,'GET-XY'
getxy:	call	gcurs
	sub	dl,wmin
	sub	dh,wmin+1
getxy1:	sub	ax,ax
	xchg	al,dh
	jmp	dpush

;	SET-WINDOW  ( x1 y1 x2 y2 -- )

	hdr	1,'SET-WINDOW'
setwin:	pop	ax
	pop	cx
	mov	ch,al
	pop	ax
	pop	dx
	mov	dh,al
	mov	word ptr wmin,dx
	mov	word ptr wmax,cx
	jmp	atxy1

;	GET-WINDOW  ( -- x1 y1 x2 y2 )

	hdr	1,'GET-WINDOW'
getwin:	mov	dx,word ptr wmin
	sub	ax,ax
	xchg	al,dh
	push	dx
	push	ax
	mov	dx,word ptr wmax
	jmp	getxy1

;	ATTRIB  ( -- addr )	address of video attribute byte

	hdr	1,'ATTRIB'
attrib:	call	docon
	dw	cattr

;	FOREGROUND  ( u -- )	0-15

	hdr	1,'FOREGROUND'
fg:	pop	ax
	and	al,0fh
	and	byte ptr cattr,0f0h
fg1:	or	cattr,al
	nextt

;	BACKGROUND  ( u -- )	0-7

	hdr	1,'BACKGROUND'
bg:	pop	ax
	and	al,7
	mov	cl,4
	shl	al,cl
	and	byte ptr cattr,8fh
	jmp	fg1

;	COLOR-TABLE  ( -- addr )	default colors

	hdr	1,'COLOR-TABLE'
clrtbl:	call	dovar
dnorm	db	07h		; normal
dinver	db	70h		; inverse
dbold	db	03h		; bold
dbrite	db	0Bh		; bright

;	NORMAL	( -- )

	hdr	1,'NORMAL'
vnorm:	mov	al,dnorm
vnorm1:	mov	cattr,al
	nextt

;	INVERSE	( -- )
;
;	hdr	1,'INVERSE'
;vinver:	mov	al,dinver
;	jmp	vnorm1

;	BOLD  ( -- )
;
;	hdr	1,'BOLD'
;vbold:	mov	al,dbold
;	jmp	vnorm1

;	BRIGHT  ( -- )
;
;	hdr	1,'BRIGHT'
;vbrite:	mov	al,dbrite
;	jmp	vnorm1

;	CLEAR-LINE  ( -- )

	hdr	1,'CLEAR-LINE'
cleol:	call	gcurs
	mov	ax,0600h
	mov	cx,dx
	mov	dl,wmax
cleol1:	call	videoa
	nextt

;	INSERT-LINE  ( -- )

	hdr	1,'INSERT-LINE'
insln:	mov	ax,0701h
insln1:	push	ax
	call	gcurs
	pop	ax
	mov	ch,dh
	mov	cl,wmin
	mov	dx,word ptr wmax
	jmp	cleol1

;	DELETE-LINE  ( -- )

	hdr	1,'DELETE-LINE'
delln:	mov	ax,0601h
	jmp	insln1

;	PAUSE  ( -- )

	hdr	1,'PAUSE'	; multitasking support
pause:	call	dodef
pause1	dw	noop		; patched by COLD

;	bios console key test  (AL)

	cseg

bconq:	cmp	byte ptr kbpend,0
	jnz	bconq1
	mov	ah,kbfn+1
	call	kbint
bconq1:	mov	al,0
	jz	bconq2
	dec	al
bconq2:	ret

;	dos console key test  (AL)

	cseg

dconq:	mov	ah,0bh
	int	21h
	ret

;	bios console in  (AL)

	cseg

bconi:	sub	al,al
	xchg	al,kbpend
	or	al,al
	jnz	bconi2
	mov	ah,kbfn
	call	kbint
	or	al,al
	jz	bconi1
	cmp	al,80h		; needed when using
	jc	bconi2		; INT16 AH=10h
	sub	al,al		;
bconi1:	mov	kbpend,ah
	or	ah,ah
	jnz	bconi2
	mov	al,3
bconi2:	ret

;	dos console in  (AL)

	cseg

dconi:	mov	ah,8		; allow ctl-C/Break
	int	21h
	ret

;	clear screen

cls:	mov	ax,0600h
	mov	cx,word ptr wmin
	push	cx
	mov	dx,word ptr wmax
	call	videoa
	pop	dx
	jmp	scurs

;	dos console out  (AL)

	cseg

dcono:	cmp	al,ff
	jz	cls
	mov	ah,2		; allow ctl-C/Break
	mov	dl,al
	int	21h
	ret

;	bios console out  (AL)

	cseg

bcono:	cmp	al,ff		; FF
	jz	cls
	push	ax
	call	gcurs
	pop	ax
	cmp	al,bel		; BEL
	jz	bcono3
	cmp	al,bs
	jz	bcono5
	cmp	al,cr		; CR
	jz	bcono4
	cmp	al,lf		; LF
	jz	bcono1
	cmp	al,tab		; TAB
	jz	bcono7
	mov	ah,9
	mov	bl,cattr
	mov	cx,1
	push	dx
	call	videop
	pop	dx
	inc	dl
	cmp	dl,wmax
	jna	bcono2
	mov	dl,wmin
bcono1:	inc	dh
	cmp	dh,wmax+1
	jna	bcono2
	dec	dh
	push	cx
	push	dx
	mov	ax,0601h
	mov	cx,word ptr wmin
	mov	dx,word ptr wmax
	call	videoa
	pop	dx
	pop	cx
bcono2:	jmp	scurs

bcono3:	mov	ah,0eh
	call	videop
	jmp	scurs

bcono4:	mov	dl,wmin
bcono5:	cmp	dl,wmin
	jz	bcono6
	dec	dl
bcono6:	jmp	scurs

bcono7:	sub	dl,wmin
	and	dl,7
	mov	al,8
	sub	al,dl
bcono8:	push	ax
	mov	al,20h
	call	bcono
	pop	ax
	dec	al
	jnz	bcono8
	jmp	scurs

	cseg

iofn	dw	biosfn

biosfn	dw	bconq		; bios functions
	dw	bconi
	dw	bcono

dosfn	dw	dconq		; dos functions
	dw	dconi
	dw	dcono

;	BIOS-IO  ( -- )		use BIOS for I/O calls

	hdr	1,'BIOS-IO'
biosio:	mov	ax,offset biosfn
biosio1:mov	iofn,ax
	mov	byte ptr kbpend,0
	nextt

;	DOS-IO  ( -- )		use DOS for I/O calls

	hdr	1,'DOS-IO'
dosio:	mov	ax,offset dosfn
	jmp	biosio1

;	?terminal  ( -- flag )

	hdr	x,'?TERMINAL'
qterm:	mov	bx,iofn
	call	[bx]
	mov	ah,al
	jmp	apush

;	KEY?  ( -- flag )	(vkeyq) dodefer pause

	hdr	1,'KEY?'
keyq:	call	docol
	dw	lit,vkeyq
	dw	dodef
	dw	pause
	dw	exit

;	pckey  ( -- char )

	hdr	x,'PCKEY'
pckey:	mov	bx,iofn
	call	[bx+cw]
	sub	ah,ah
	jmp	apush

;	conin  ( -- char )	begin key? until pckey dup 0=
;				if drop	pckey 128 + then

	hdr	x,'CONIN'
conin:	call	docol
conin1	dw	keyq
	dw	zbran,conin1
	dw	pckey
	dw	dupp,zequ
	dw	zbran,conin2
	dw	drop
	dw	pckey
	dw	clit
	db	128
	dw	plus
conin2	dw	exit

;	KEY  ( -- char )	(vkey) dodefer pause

	hdr	1,'KEY'
key:	call	docol
	dw	lit,vkey
	dw	dodef
	dw	pause
	dw	exit

;	conout  ( char -- )

	hdr	x,'CONOUT'
conout:	pop	ax
	mov	bx,iofn
	call	[bx+cw*2]
	nextt

;	lstout  ( char -- )

	hdr	x,'LSTOUT'
lstout:	pop	dx
	mov	ah,5
	int	21h
	nextt

;	PAGE  ( -- )		12 emit

	hdr	1,'PAGE'
pagee:	mov	al,ff		; formfeed char
	ignore2

;	SPACE  ( -- )		32 emit

	hdr	1,'SPACE'
space:	mov	al,20h
	sub	ah,ah
	push	ax
;	jmp	emit

;	EMIT  ( char -- )	(vemit) dodefer 1 out +! pause

	hdr	1,'EMIT'
emit:	call	docol
	dw	lit,vemit
	dw	dodef
	dw	one,outt,pstor
	dw	pause
	dw	exit

;	TYPE  ( c-addr n -- )	0 max 0 ?do count emit loop drop

	hdr	1,'TYPE'
typee:	call	docol
	dw	zero,max
	dw	zero
	dw	xqdo,typee2
typee1	dw	count,emit
	dw	xloop,typee1
typee2	dw	drop
	dw	exit

;	SPACES	( n -- )	0 max 0 ?do space loop

	hdr	1,'SPACES'
spacs:	call	docol
	dw	zero,max
	dw	zero
	dw	xqdo,spacs2
spacs1	dw	space
	dw	xloop,spacs1
spacs2	dw	exit

;	CR  ( -- )		(cr) emit (lf) emit out off

	hdr	1,'CR'
crr:	call	docol
	dw	clit
	db	cr
	dw	emit
	dw	clit
	db	lf
	dw	emit
	dw	outt,off
	dw	exit

;	CONSOLE  ( -- ) 	(vcon) @ (vemit) !

	hdr	1,'CONSOLE'	; set EMIT to terminal
consol:	mov	ax,vcon
	mov	vemit,ax
	nextt

;	PRINTER  ( -- ) 	(vlst) @ (vemit) !

	hdr	1,'PRINTER'	; set EMIT to printer
prnt:	mov	ax,vlst
	mov	vemit,ax
	nextt

;	UPCASE	( char1 -- char2 )

	hdr	1,'UPCASE'	; make char uppercase
upcas:	pop	ax
	call	upc
	jmp	apush

;	UPPER  ( c-addr u -- )

	hdr	1,'UPPER'	; make string uppercase
upper:	pop	cx
	pop	bx
	jcxz	upper2
upper1:	mov	al,[bx]
	call	upc
	mov	[bx],al
	inc	bx
	loop	upper1
upper2:	nextt

;	CONTEXT  ( -- addr )

	hdr	1,'CONTEXT',,1
cont:	call	dovar
cont1	dw	vocs dup (?)

;	CURRENT  ( -- addr )

	hdr	1,'CURRENT',,1
curr:	call	dovar
curr1	dw	?

;	context@  ( -- wid )	context @

	hdr	x,'CONTEXT@',,1
contat:	push	cont1
	nextt

;	GET-CURRENT  ( -- wid )  current @

	hdr	1,'GET-CURRENT',,1
getcur:	push	curr1
	nextt

;	SET-CURRENT  ( wid -- )  current !

	hdr	1,'SET-CURRENT',,1
setcur:	pop	curr1
	nextt

;	>s  ( a-addr cells -- i*x )

	hdr	x,'>S',,1
tos:	pop	cx
	pop	ax
	shl	cx,1
	sub	sp,cx
	mov	di,sp
tos1:	xchg	sp,bp
	call	movd
	xchg	sp,bp
	nextt

;	s>  ( i*x a-addr cells -- )

	hdr	x,'S>',,1
froms:	pop	cx
	pop	di
	shl	cx,1
	mov	ax,sp
	add	sp,cx
	jmp	tos1

;	#order  ( -- n )

	hdr	x,'#ORDER',,1
numord:	call	doval
	dw	?

;	GET-ORDER  ( -- widn .. wid1 n )  context #order >s #order

	hdr	1,'GET-ORDER',,1
getord:	call	docol
	dw	cont,numord
	dw	tos
	dw	numord
	dw	exit

;	SET-ORDER  ( widn .. wid1 n -- )
;				dup -1 = if drop forth-wordlist dup 2 then
;				to #order context #order s>

	hdr	1,'SET-ORDER',,1
setord:	call	docol
	dw	dupp,true,equal
	dw	zbran,setord1
	dw	drop,fwlis
	dw	dupp,two
setord1	dw	pto,numord
	dw	cont,numord
	dw	froms
	dw	exit

;	ALSO  ( -- )		get-order dup (vocs) < if 1+ over swap then
;				set-order

	hdr	1,'ALSO',,1
also:	call	docol
	dw	getord
	dw	dupp
	dw	clit
	db	vocs
	dw	less
	dw	zbran,also1
	dw	onep,over,swap
also1	dw	setord
	dw	exit

;	PREVIOUS  ( -- )	get-order dup 2 > if nip 1- then set-order

	hdr	1,'PREVIOUS',,1
prev:	call	docol
	dw	getord
	dw	dupp,two,great
	dw	zbran,prev1
	dw	nip,onem
prev1	dw	setord
	dw	exit

;	ONLY  ( -- )		-1 set-order

	hdr	1,'ONLY',,1
only:	call	docol
	dw	true,setord
	dw	exit

;	SEAL  ( -- )		context@ 1 set-order
;
;	hdr	1,'SEAL',,1
;seal:	call	docol
;	dw	contat
;	dw	one,setord
;	dw	exit

;	(search)  ( c-addr u wid -- 0 | xt nfa -1 | xt nfa 1 )

	hdr	x,'(SEARCH)',,1
psear:	pop	bx
	pop	ax
	pop	dx
	cmp	ax,31+1		; in range?
	jnc	psear5
	or	ax,ax
	jz	psear5
	sub	ch,ch
	mov	bx,[bx]
	mov	es,hseg1
psear1:	or	bx,bx		; end of list?
	jz	psear5
	mov	di,bx
	mov	ah,es:[bx]	; nfa
	inc	bx
	mov	cl,ah
	and	cl,31		; word length
	cmp	cl,al
	jz	psear3
psear2:	add	bx,cx		; move to link
	mov	bx,es:[bx]
	jmp	psear1

psear3:	test	ah,20h		; smudged?
	jnz	psear2
	push	si
	push	di
	mov	si,dx
	mov	di,bx
	 if	ucase
	call	cmpnc
	 else
	rep	cmpsb
	 endif
	mov	cl,al
	pop	di
	pop	si
	jnz	psear2
	add	bx,cx
	push	es:[bx+cw]	; xt
	push	di		; nfa
	and	ah,40h		; immediate?
	jnz	psear4
	jmp	true

psear4:	jmp	one

psear5:	jmp	zero

;	SEARCH-WORDLIST  ( c-addr u wid -- 0 | xt -1 | xt 1 )
;				(search) dup if nip then

	hdr	1,'SEARCH-WORDLIST',,1
swlis:	call	docol
	dw	psear
	dw	dupp
	dw	zbran,swlis1
	dw	nip
swlis1	dw	exit

;	(find)  ( c-addr -- addr 0 | xt -1 | xt 1 )
;				0 #order 0 ?do over count i cells context
;				+ @ search-wordlist ?dup if 2swap 2drop
;				leave then loop

	hdr	x,'(FIND)',,1
pfind:	call	docol
	dw	zero,numord,zero
	dw	xqdo,pfind3
pfind1	dw	over,count
	dw	ido,cells
	dw	cont,plus,at
	dw	swlis,qdup
	dw	zbran,pfind2
	dw	tswap,tdrop
	dw	pleav,pfind1-cw
pfind2	dw	xloop,pfind1
pfind3	dw	exit

;	FIND  ( c-addr -- c-addr 0 | xt -1 | xt 1 )

	hdr	1,'FIND',,1
find:	call	dodef
	dw	pfind

;	-?  ( -- )		warning @ 0fffe and warning !

	hdr	1,'-?',,1	; disable warnings for next definition only
dques:	and	warnn1,0fffeh	; clear bit 0
	nextt

;	warning?  ( -- flag )	warning @ dup if dup 1 and tuck if -1
;				else $7fff and 1 then or warning ! then

	hdr	x,'WARNING?',,1	; get warning flag and apply mask
qwarn:	mov	bx,offset warnn1
	mov	cx,[bx]
	jcxz	qwarn3
	mov	ax,cx
	and	cx,1		; test bit 0
	jz	qwarn1
	mov	ax,-1		; enable all warnings
	jmp	short qwarn2
qwarn1:	and	ax,7fffh	; disable compile warning
	or	ax,1		; enable redefinition warning
qwarn2:	mov	[bx],ax
qwarn3:	push	cx
	nextt

;	!last  ( xt -- xt nfa )	dph @ 2dup last 2!

	hdr	x,'!LAST',,1
stolas:	call	docol
	dw	dph,at
	dw	tdup
	dw	last,tstor
	dw	exit

;	(header)  ( "name" xt -- )
;				warning? 2>r dph @ (hm-64) u>
;				abort" no header space" bl-word dup c@
;				1 32 within 0= abort" invalid name"
;				dup find nip r> and if dup count type
;				."  is redefined " then dup count tuck
;				+ get-current @ over ! 2+ r> !last dup
;				get-current ! >r swap ! 5 + dup dph +!
;				>r cseg swap hseg 2r> cmovel

	hdr	x,'(HEADER)',,1
phead:	call	docol
	dw	qwarn		; must execute first
	dw	ttor
	dw	dph,at
	dw	lit,hm-64
	dw	ugrea
	dw	pabq
	dcs	'no header space'
	dw	blword
	dw	dupp,cat
	dw	one
	dw	clit
	db	32
	dw	within,zequ
	dw	pabq
	dcs	'invalid name'
	dw	dupp,find,nip
	dw	fromr,andd
	dw	zbran,phead1
	dw	dupp,count,typee
	dw	pdotq
	dcs	' is redefined '
phead1	dw	dupp,count
	dw	tuck
	dw	plus
	dw	getcur,at
	dw	over,store
	dw	twop
	dw	fromr,stolas
	dw	dupp,getcur,store
	dw	tor
	dw	swap,store
	dw	clit
	db	5
	dw	plus
	dw	dupp,dph,pstor
	dw	tor
	dw	csegg,swap
	dw	hseg
	dw	tfrom,cmovl
	dw	exit

;	header	( "name" -- )	here (header)

	hdr	x,'HEADER',,1
headr:	call	docol
	dw	here,phead
	dw	exit

;	,call  ( addr -- )	$E8 c, here 2+ - ,

	hdr	x,',CALL',,1
comcall:call	docol
	dw	clit
	db	0e8h		; 'call' opcode
	dw	ccomm
	dw	here,twop,subb	; relative for 8086
	dw	comma
	dw	exit

;	,docol  ( -- )		(docol) ,call

	hdr	x,',DOCOL',,1
comdoc:	call	docol
	dw	lit,docol
	dw	comcall
	dw	exit

;	:  ( -- )		header smudge ,docol bal off !csp
;				sp@ cf0 ! ]

	hdr	1,':',,1
colon:	call	docol
	dw	headr
	dw	smudg
colon1	dw	comdoc
	dw	bal,off
	dw	scsp
	 if	cfs
	dw	spat
	dw	cfz,store
	 endif
	dw	rbrac
	dw	exit

;	EXIT  ( -- )		postpone (exit) immediate

	hdr	1,'EXIT',1,1
exitt:	call	docol
	dw	comp,exit
	dw	exit

;	;  ( -- )		postpone exit bal @ ?bal ?csp smudge
;				postpone [ ;immediate

	hdr	1,';',1,1
semi:	call	docol
	dw	exitt
	dw	bal,at
	dw	qbal
	dw	qcsp
	dw	smudg
	dw	lbrac
	dw	exit

;	:NONAME  ( -- xt )	warning? drop here !last drop
;				,docol bal off !csp sp@ cf0 ! ]

	hdr	1,':NONAME',,1
nonam:	call	docol
	dw	qwarn,drop		; allow -?
	dw	here,stolas,drop	; allow RECURSE etc
	dw	bran,colon1

;	BUILD  ( xt -- )	header ,call

	hdr	1,'BUILD',,1
build:	call	docol
	dw	headr
	dw	comcall
	dw	exit

;	CREATE	( -- addr )	(dovar) build

	hdr	1,'CREATE',,1
creat:	call	docol
	dw	lit,dovar
	dw	build
	dw	exit

dovar	equ	next

;	(;CODE) 		last cell+ @ 1+ r> over 2+ - swap !

	hdr	1,'(;CODE)',,1
pscod:	mov	bx,last2
	inc	bx
	sub	si,bx		; relative for 8086
	dec	si		;
	dec	si		;
	mov	[bx],si
	jmp	exit

;	DOES>			postpone (;code) ,docol ;immediate

	hdr	1,'DOES>',1,1
does:	call	docol
	dw	comp,pscod
	dw	comdoc
	dw	exit

;	VARIABLE  ( -- addr )	create 2 allot

	hdr	1,'VARIABLE',,1
var:	call	docol
	dw	creat
	dw	two,allot
	dw	exit

;	CONSTANT  ( -- x )	(docon) build ,

	hdr	1,'CONSTANT',,1
con:	call	docol
	dw	lit,docon
	dw	build
	dw	comma
	dw	exit

docon	equ	at

;	2VARIABLE  ( -- addr )	create 4 allot

	hdr	1,'2VARIABLE',,1
tvar:	call	docol
	dw	creat
	dw	clit
	db	4
	dw	allot
	dw	exit

dotvar	equ	next

;	2CONSTANT  ( -- x2 x1 )  (dotcon) build , ,

	hdr	1,'2CONSTANT',,1
tcon:	call	docol
	dw	lit,dotcon
	dw	build
	dw	comma,comma
	dw	exit

dotcon	equ	tat

;	USER  ( -- addr )	(douse) build ,

	hdr	1,'USER',,1	; FIG
user:	call	docol
	dw	lit,douse
	dw	build
	dw	comma
	dw	exit

;	(is)  ( x -- )		r> dup 2+ >r @ >body !

	hdr	x,'(IS)'
pis:	lodsw
	mov	bx,ax
	pop	[bx+3]
	nextt

pto	equ	pis

;	IS			' state? if postpone (is) compile, else
;				>body ! then ;immediate

	hdr	1,'IS',1,1
is:	call	docol
	dw	tick
	dw	stateq
	dw	zbran,is1
	dw	comp,pis
	dw	comxt
	dw	bran,is2
is1	dw	tbody,store
is2	dw	exit

	cseg

undef:	call	docol
	dw	one
	dw	pabq
	dcs	'undefined vector'

;	DEFER  ( -- )		(dodef) build (undef) compile,

	hdr	1,'DEFER',,1
defer:	call	docol
	dw	lit,dodef
	dw	build
	dw	lit,undef
	dw	comxt
	dw	exit

;	TO			aka is to

	hdr	1,'TO',1,,is
to	equ	is

;	VALUE  ( x -- )		aka constant value

	hdr	1,'VALUE',,,con
value	equ	con

doval	equ	docon

;	ADDR  ( -- addr )	' >body state? if postpone literal then
;				;immediate

	hdr	1,'ADDR',1,1
adr:	call	docol
	dw	tick,tbody
	dw	stateq
	dw	zbran,adr1
	dw	liter
adr1	dw	exit

;	AKA  ( "oldname" "newname" -- )	 defined tuck ?defined (header)
;					$80 toggle 0> if immediate then

	hdr	1,'AKA',,1
aka:	call	docol
	dw	defined
	dw	tuck,qdef
	dw	phead		; equivalent of
	dw	clit		; ALIAS ( xt "newname" -- )
	db	80h		;
	dw	toggl		;
	dw	zgrea
	dw	zbran,aka1
	dw	immed
aka1	dw	exit

;	Constants

;	TRUE  ( -- -1 )

	hdr	1,'TRUE'
true:	mov	ax,-1
	push	ax
	nextt

;	FALSE  ( -- 0 )

	hdr	1,'FALSE'
false:	sub	ax,ax
	push	ax
	nextt

;	-1  ( -- -1 )		aka true -1

	hdr	1,'-1',,,true

;	0  ( -- 0 )		aka false 0

	hdr	1,'0',,,false
zero	equ	false

;	1  ( -- 1 )

	hdr	1,'1'
one:	call	docon
	dw	1

;	2  ( -- 2 )

	hdr	1,'2'
two:	call	docon
	dw	2

;	3  ( -- 3 )

	hdr	1,'3'
three:	call	docon
	dw	3

;	BL  ( -- 32 )		ascii value for space character

	hdr	1,'BL'
bll:	call	docon
	dw	32

;	B/BUF  ( -- 1024 )	bytes per screen buffer

	hdr	1,'B/BUF',,1	; FIG
bbuf:	call	doval
bbuf1	dw	1024

;	C/L  ( -- 64 )		chars per screen line

	hdr	1,'C/L',,1	; FIG
csll:	call	doval
	dw	64

; For applications, LIMIT is the upper limit of available memory.
; In forth, it is the beginning of the area which holds the screen
; file buffer, word headers and system definitions.

;	LIMIT  ( -- addr )

	hdr	1,'LIMIT'	; FIG
limit:	call	docon		; application word - used by COLD
limit1	dw	?		; patched on startup

;	HLIMIT  ( -- addr )

	hdr	1,'HLIMIT',,1	; upper limit of heads memory
hlimit:	call	docon
	dw	hm

;	>NEXT  ( -- addr )	address of NEXT

	hdr	1,'>NEXT'
tnext:	call	docon
tnext1	dw	next

;	SYS-VEC  ( -- addr )	system vector table

	hdr	1,'SYS-VEC'
sysvec:	call	dovar

vkeyq	dw	qterm		;  0 KEY?
vkey	dw	conin		;  2 KEY
vemit	dw	conout		;  4 EMIT
vcon	dw	conout		;  6 CONSOLE out
vlst	dw	lstout		;  8 PRINTER out
ainit	dw	cold5		; 10 INIT patch
aident	dw	cold11		; 12 IDENTIFY patch
afnumb	dw	inte12		; 14 FNUMBER patch
nfps	dw	fps		; 16 fp-stack size (bytes)
anumb	dw	inte8		; 18 NUMBER? patch
nfpm	dw	fnum*4		; 20 fp-stack min (bytes)
nrts	dw	rts		; 22 return stack (bytes)
nus	dw	us		; 24 user area (bytes)
npno	dw	pno		; 26 HOLD buffer size (bytes)

;	Variables

;	UP  ( -- addr )		user area pointer

	hdr	1,'UP'
up:	call	dovar
upp	dw	?

;	FSP  ( -- addr )	fp stack pointer

	hdr	1,'FSP'
fsp:	call	dovar
fspp	dw	?

;	boot  ( -- addr )	boot word (holds forth/application xt)

	hdr	x,'BOOT'
boot:	call	dovar
boot1	dw	0		; xt
boot2	dw	0		; 0=forth

;	SYS  ( -- addr )	compile to system or application

	hdr	1,'SYS'
sys:	call	dovar		; application word - used by HERE UNUSED
sys1	dw	0

;	last	( -- addr )	occupies 2 cells

	hdr	x,'LAST',,1
last:	call	dovar
last1	dw	topnfa		; latest nfa
last2	dw	topxt		; latest xt

;	BLK

	hdr	1,'BLK',,1
blk:	call	dovar
blk1	dw	?

;	>IN

	hdr	1,'>IN',,1
inn:	call	dovar
inn1	dw	?

;	'SOURCE			occupies 2 cells

	hdr	1,'''SOURCE',,1
tsourc:	call	dovar
tsourc1	dw	?,?

;	STATE

	hdr	1,'STATE',,1
state:	call	dovar
state1	dw	?

;	SCR  ( -- addr )	occupies 2 cells

	hdr	1,'SCR',,1
scr:	call	dovar
	dw	?,?		; screen number, offset

;	WARNING

	hdr	1,'WARNING',,1	; FIG
warnn:	call	dovar
warnn1	dw	?

;	CSP

	hdr	1,'CSP',,1	; FIG
cspp:	call	dovar
cspp1	dw	?

;	CHECKING

	hdr	1,'CHECKING',,1
check:	call	dovar
	dw	?

;	errmsg  ( -- addr )	message holder for abort"

	hdr	x,'ERRMSG'
errmsg:	call	dovar
errmsg1	dw	?,?

;	zbuf  ( -- addr )	asciiz buffer pointers

	hdr	x,'ZBUF'
zbuf:	call	dovar
zbuf1	dw	zb1	; next buffer
	dw	zb2	; last buffer

;	User Variables

;	bytes 0-5		reserved for multitasking

;	S0

	hdr	1,'S0'		; FIG
szero:	call	douse
	dw	6

;	R0

	hdr	1,'R0'		; FIG
rzero:	call	douse
	dw	8

;	DP			application dictionary pointer

	hdr	1,'DP'		; FIG
dpp:	call	douse
	dw	10

;	dps			system dictionary pointer

	hdr	x,'DPS',,1	; must follow DP
dps:	call	douse
	dw	12

;	VOC-LINK

	hdr	1,'VOC-LINK',,1	; FIG
vocl:	call	douse
	dw	14

;	FS0

	hdr	1,'FS0'
fszero:	call	douse
	dw	16

;	DPH  ( -- addr )	heads dictionary pointer

	hdr	1,'DPH',,1
dph:	call	douse
	dw	18

; End of boot-up literals

;	DPL

	hdr	1,'DPL'		; FIG
dpl:	call	douse
	dw	20

;	hld

	hdr	x,'HLD'		; FIG
hld:	call	douse
	dw	22

;	BASE

	hdr	1,'BASE'
base:	call	douse
	dw	24

;	bytes 26-27		reserved for locals

;	OUT

	hdr	1,'OUT'		; FIG
outt:	call	douse
	dw	28

;	bytes 30-33		reserved

;	CATCHER

	hdr	1,'CATCHER'
catchr:	call	douse
	dw	34

;	bytes 36-43		reserved

; User area bytes 44 onwards are available for user applications

;	sys?  ( -- flag )	sys @

	hdr	x,'SYS?'
sysq:	push	word ptr sys1
	nextt

;	state?  ( -- flag )	state @

	hdr	x,'STATE?',,1
stateq:	push	word ptr state1
	nextt

;	APPLICATION  ( -- )	sys off

	hdr	1,'APPLICATION',,1
app:	mov	bx,offset sys1
	jmp	off1

;	SYSTEM	( -- )		sys on

	hdr	1,'SYSTEM',,1
system:	mov	bx,offset sys1
	jmp	on1

;	h  ( -- addr )		sys@ if dps else dp then

	hdr	x,'H'
hh:	mov	ax,sys1
	or	ax,ax
	jnz	hh1
	jmp	dpp
hh1:	jmp	dps

;	HERE  ( -- addr )	h @

	hdr	1,'HERE'
here:	call	docol
	dw	hh,at
	dw	exit

;	ALLOT  ( n -- ) 	here over 0 max dup unused u>
;				abort" no data space" erase h +!

	hdr	1,'ALLOT'
allot:	call	docol
	dw	here,over
	dw	zero,max
	dw	dupp
	dw	unus,ugrea
	dw	pabq
	dcs	'no data space'
	dw	erase
	dw	hh,pstor
	dw	exit

;	C,  ( char -- ) 	here 1 allot c!

	hdr	1,'C,',,1
ccomm:	call	docol
	dw	here
	dw	one,allot
	dw	cstor
	dw	exit

;	,  ( x -- )		here 2 allot !

	hdr	1,',',,1
comma:	call	docol
	dw	here
	dw	two,allot
	dw	store
	dw	exit

;	>BODY  ( xt -- addr )	3 +

	hdr	1,'>BODY'
tbody:	pop	ax
	add	ax,3
	jmp	apush

;	BODY>  ( addr -- xt )	3 -

	hdr	1,'BODY>'
fbody:	pop	ax
	sub	ax,3
	jmp	apush

;	n>link	( nfa -- lfa )

	hdr	x,'N>LINK',,1
nlnk:	pop	bx
	mov	es,hseg1
	mov	al,es:[bx]
	and	ax,1fh
	inc	bx
	add	ax,bx
	jmp	apush

;	N>NAME	( nfa1 -- nfa2 | 0 )

	hdr	1,'N>NAME',,1
ntnam:	call	docol
	dw	nlnk,hat
	dw	exit

;	name>  ( nfa -- xt )	n>link 2+ h@

	hdr	x,'NAME>',,1
namef:	call	docol
	dw	nlnk,twop
	dw	hat
	dw	exit

;	-alias  ( nfa -- nfa flag )  dup hc@ $80 <

	hdr	x,'-ALIAS',,1	; false if alias
dalias:	call	docol
	dw	dupp,hcat
	dw	clit
	db	80h
	dw	less
	dw	exit

;	>name  ( xt -- nfa | 0 )
;				voc-link begin @ dup while tuck cell- @
;				begin ?dup while -alias if 2dup name>
;				= if -rot 2drop exit then then n>name
;				repeat swap repeat nip

	hdr	x,'>NAME',,1
tname:	call	docol
	dw	vocl
tnam1	dw	at
	dw	dupp
	dw	zbran,tnam5
	dw	tuck
	dw	cellm,at
tnam2	dw	qdup
	dw	zbran,tnam4
	dw	dalias		; skip if alias
	dw	zbran,tnam3
	dw	tdup,namef
	dw	equal
	dw	zbran,tnam3
	dw	drot,tdrop
	dw	exit
tnam3	dw	ntnam
	dw	bran,tnam2
tnam4	dw	swap
	dw	bran,tnam1
tnam5	dw	nip
	dw	exit		; not found

;	(name)  ( nfa -- c-addr u )  dup 1+ swap hc@ 31 and

	hdr	x,'(NAME)',,1
pname:	call	docol
	dw	dupp,onep
	dw	swap,hcat
	dw	clit
	db	31
	dw	andd
	dw	exit

;	.ID  ( nfa | 0 -- )	?dup if dup name> limit u< if (dnorm) else
;				(dbold) then c@ over hc@ $40 and 3 rshift
;				xor attrib c! (name) over + swap ?do hseg i
;				c@l emit loop normal exit then ." [noname]"

	hdr	1,'.ID',,1
dotid:	call	docol
	dw	qdup
	dw	zbran,dotid5
	dw	dupp,namef
	dw	limit,uless
	dw	zbran,dotid1
	dw	lit,dnorm	; normal
	dw	bran,dotid2
dotid1	dw	lit,dbold	; bold
dotid2	dw	cat
	dw	over,hcat
	dw	clit		; immediate?
	db	40h
	dw	andd
	dw	three,rsh
	dw	xorr		; toggle bright
	dw	attrib,cstor
	dw	pname
	dw	over,plus,swap
	dw	xqdo,dotid4
dotid3	dw	hseg
	dw	ido
	dw	catl
	dw	emit
	dw	xloop,dotid3
dotid4	dw	vnorm
	dw	exit
dotid5	dw	pdotq
	dcs	'[noname]'
	dw	exit

;	.NAME  ( xt -- )	>name .id

	hdr	1,'.NAME',,1
dotnam:	call	docol
	dw	tname,dotid
	dw	exit

;	!CSP  ( -- )		sp@ csp !

	hdr	1,'!CSP',,1	; FIG
scsp:	mov	ax,sp
	mov	cspp1,ax
	nextt

;	?CSP  ( -- )		sp@ csp @ - ?bal

	hdr	1,'?CSP',,1	; FIG
qcsp:	mov	ax,cspp1
	sub	ax,sp
	push	ax
	jmp	qbal

;	?COMP  ( -- )		state? 0= abort" compilation only'

	hdr	1,'?COMP',,1	; FIG
qcomp:	call	docol
	dw	stateq
	dw	zequ
	dw	pabq
	dcs	'compilation only'
	dw	exit

;	?EXEC  ( -- )		state? abort" execution only'

	hdr	1,'?EXEC',,1	; FIG
qexec:	call	docol
	dw	stateq
	dw	pabq
	dcs	'execution only'
	dw	exit

;	?STACK	( -- )		sp@ s0 @ over u< swap pad u< or
;				abort" stack?" r0 @ rp@ u< rp@ fs0 @ u<
;				or abort" r-stack?" fs0 @ fsp @ u< fsp @
;				fs0 @ (nfpm) @ - u< or abort" f-stack?"

	hdr	1,'?STACK',,1	; FIG
qstac:	call	docol
	dw	spat
	dw	szero,at
	dw	over,uless
	dw	swap
	dw	pad
	dw	uless
	dw	orr
	dw	pabq
	dcs	'stack?'
	dw	rzero,at
	dw	rpat
	dw	uless
	dw	rpat
	dw	fszero		; = S0 if no float
	dw	at
	dw	uless,orr
	dw	pabq
	dcs	'r-stack?'
	dw	fszero,at
	dw	fsp,at
	dw	uless
	dw	fsp,at
	dw	fszero,at
	dw	lit,nfpm
	dw	at
	dw	subb
	dw	uless
	dw	orr
	dw	pabq
	dcs	'f-stack?'
	dw	exit

;	?defined  ( flag -- )	0= abort" is undefined"

	hdr	x,'?DEFINED',,1
qdef:	call	docol
	dw	zequ
	dw	pabq
	dcs	'is undefined'
	dw	exit

;	[			state off ;immediate

	hdr	1,'[',1,1
lbrac:	mov	bx,offset state1
	jmp	off1

;	]			state on

	hdr	1,']',,1
rbrac:	mov	bx,offset state1	; must be -1 for INTERPRET to work
	jmp	on1

;	(ACCEPT)  ( c-addr +n1 -- +n2)
;				0 begin key dup >r dup bl 127 within 2over -
;				and if dup emit over 4 pick + c! 1+ else 2dup
;				dup 8 = swap esc = or and if esc = if 0 swap
;				else 1- 1 then begin 8 dup emit space emit 1-
;				dup 0= until then drop then r> 13 = until
;				-rot 2drop

	hdr	x,'(ACCEPT)'
paccep:	call	docol
	dw	zero
paccep1	dw	key
	dw	dupp,tor
	dw	dupp,bll	; only accept chars between 32 and 126
	dw	clit
	db	127
	dw	within
	dw	tover,subb
	dw	andd
	dw	zbran,paccep2
	dw	dupp,emit
	dw	over
	dw	clit
	db	4
	dw	pick
	dw	plus
	dw	cstor
	dw	onep
	dw	bran,paccep6
paccep2	dw	tdup
	dw	dupp
	dw	clit
	db	bs		; backspace?
	dw	equal,swap
	dw	clit
	db	escape		; escape?
	dw	equal,orr
	dw	andd
	dw	zbran,paccep5
	dw	clit
	db	escape		; escape?
	dw	equal
	dw	zbran,paccep3
	dw	zero,swap
	dw	bran,paccep4
paccep3	dw	onem,one
paccep4	dw	clit
	db	bs
	dw	dupp,emit
	dw	space,emit
	dw	onem
	dw	dupp,zequ
	dw	zbran,paccep4
paccep5	dw	drop
paccep6	dw	fromr
	dw	clit
	db	cr		; cr?
	dw	equal
	dw	zbran,paccep1
	dw	drot,tdrop
	dw	exit

;	ACCEPT  ( c-addr +n1 -- +n2)

	hdr	1,'ACCEPT'
accept:	call	dodef
	dw	paccep

;	PAD  ( -- addr )	dp @ (npno) @ +

	hdr	1,'PAD'
pad:	mov	bx,upp
	mov	ax,[bx+10]	; DP
	add	ax,npno
	jmp	apush

;	SOURCE  ( -- c-addr u )		'source 2@

	hdr	1,'SOURCE',,1
source:	mov	bx,offset tsourc1
	jmp	tat1

;	PARSE  ( char -- c-addr u )	>r source >in @ /string 2dup r>
;					scan nip tuck - dup rot 0<> - >in
;					+!

	hdr	1,'PARSE',,1
parse:	call	docol
	dw	tor
	dw	source
	dw	inn,at,sstr
	dw	tdup
	dw	fromr
	dw	scan,nip
	dw	tuck
	dw	subb,dupp
	dw	rot,zneq
	dw	subb
	dw	inn,pstor
	dw	exit

;	+psb  ( a1 n1 n2 -- n3 )	>r (pssiz) r@ - umin r> 2dup + >r
;					(psb) + swap cmove r>

	hdr	x,'+PSB',,1
pps:	pop	bx
	pop	cx
	mov	di,pssiz
	sub	di,bx
	cmp	di,cx
	jnc	pps1
	mov	cx,di
pps1:	mov	di,offset orig+psb
	add	di,bx
	add	bx,cx
	pop	ax
	push	bx
	jmp	cmove1

;	PARSE"  ( "ccc" -- a n )	0 begin >r [char] " parse 2dup r>
;					+psb >r 1+ + dup source + u< while
;					dup c@ [char] " = while 1 dup >in
;					+! r> +psb repeat then drop (psb) r>

	hdr	1,'PARSE"',,1
parsq:	call	docol
	dw	zero
parsq1	dw	tor
	dw	clit
	db	'"'
	dw	parse
	dw	tdup
	dw	fromr,pps
	dw	tor
	dw	onep,plus
	dw	dupp
	dw	source,plus
	dw	uless
	dw	zbran,parsq2
	dw	dupp,cat
	dw	clit
	db	'"'
	dw	equal
	dw	zbran,parsq2
	dw	one,dupp
	dw	inn,pstor
	dw	fromr,pps
	dw	bran,parsq1
parsq2	dw	drop
	dw	lit,psb
	dw	fromr
	dw	exit

;	bl-word  ( -- addr )		bl word

	hdr	x,'BL-WORD',,1
blword:	mov	ax,20h
	push	ax
;	jmp	wordd

;	WORD  ( char -- c-addr ) 	>r source >in @ /string over swap
;					r@ skip drop swap - >in +! r> parse
;					255 min (em-5) over - dup to pwa
;					place pwa bl (em-4) c!

	hdr	1,'WORD',,1
wordd:	call	docol
	dw	tor
	dw	source
	dw	inn,at,sstr
	dw	over,swap
	dw	rat,skip,drop
	dw	swap,subb
	dw	inn,pstor
	dw	fromr,parse
	dw	clit
	db	255
	dw	min
	 if	retro
	dw	dpp,at
	 else
	dw	lit,em-5
	dw	over,subb
	 endif
	dw	dupp
	dw	pto,pwa
	dw	place
	dw	pwa
	dw	bll		; trailing blank
	 if	retro
	dw	over,count,plus
	 else
	dw	lit,em-4
	 endif
	dw	cstor
	dw	exit

;	token  ( -- c-addr u )	bl-word count

	hdr	x,'TOKEN',,1
token:	call	docol
	dw	blword,count
	dw	exit

;	defined  ( -- c-addr 0 | xt -1 | xt 1 )	bl-word find

	hdr	x,'DEFINED',,1
defined:call	docol
	dw	blword,find
	dw	exit

;	'  ( -- xt )		defined ?defined

	hdr	1,'''',,1
tick:	call	docol
	dw	defined
	dw	qdef
	dw	exit

;	[UNDEFINED]  ( -- flag )  defined nip 0= ;immediate

	hdr	1,'[UNDEFINED]',1,1
budef:	call	docol
	dw	defined
	dw	nip
	dw	zequ
	dw	exit

;	[DEFINED]  ( -- flag )	postpone [undefined] 0= ;immediate

	hdr	1,'[DEFINED]',1,1
bdef:	call	docol
	dw	budef,zequ
	dw	exit

;	IMMEDIATE  ( -- )	$40 toggle

	hdr	1,'IMMEDIATE',,1
immed:	mov	al,40h
	ignore2

;	SMUDGE	( -- )		$20 toggle

	hdr	1,'SMUDGE',,1	; FIG
smudg:	mov	al,20h
	ignore1

;	toggle  ( x -- )	toggle nfa

	hdr	x,'TOGGLE',,1
toggl:	pop	ax
	mov	bx,last1
	mov	es,hseg1
	xor	es:[bx],al
	nextt

;	\  ( "ccc" -- )		source nip blk @ if c/l >in @ over / 1+ *
;				min then >in ! ;immediate

	hdr	1,'\',1,1
bslas:	call	docol
	dw	source,nip
	dw	blk,at
	dw	zbran,bslas1
	dw	csll
	dw	inn,at
	dw	over,slash
	dw	onep,star
	dw	min
bslas1	dw	inn,store
	dw	exit

;	\\  ( "ccc" -- )	source nip >in ! ;immediate

	hdr	1,'\\',1,1
bslss:	call	docol
	dw	source,nip
	dw	inn,store
	dw	exit

;	(  ( "ccc<delim>" )	[char] ) parse 2drop ;immediate

	hdr	1,'(',1,1
paren:	call	docol
	dw	clit
	db	')'
	dw	parse,tdrop
	dw	exit

;	.(  ( "ccc<delim>" )	[char] ) parse type ;immediate

	hdr	1,'.(',1,1
dotp:	call	docol
	dw	clit
	db	')'
	dw	parse,typee
	dw	exit

;	WORDLIST  ( -- wid )	here 0 , here voc-link @ , voc-link !
;				last @ ,

	hdr	1,'WORDLIST',,1
wlist:	call	docol
	dw	here
	dw	zero,comma
	dw	here
	dw	vocl,at
	dw	comma
	dw	vocl,store
	dw	last,at		; needed for forget to work
	dw	comma		; if vocab name beheaded
	dw	exit

;	VOCABULARY		sys? system create wordlist drop sys !
;				does> context !

	hdr	1,'VOCABULARY',,1
vocab:	call	docol
	dw	sysq
	dw	system
	dw	creat
	dw	wlist,drop
	dw	sys,store
	dw	pscod
dovoc:	call	docol
	dw	cont,store
	dw	exit

;	DEFINITIONS  ( -- )	context@ set-current

	hdr	1,'DEFINITIONS',,1
defin:	call	docol
	dw	contat
	dw	setcur
	dw	exit

;	FORTH			vocabulary forth

	hdr	1,'FORTH',,1
forth:	call	dovoc
forth1	dw	topnfa		; nfa of top word in vocabulary
forth2	dw	0		; link to previous vocabulary
	dw	lastl		; nfa pointer

;	FORTH-WORDLIST  ( -- wid )

	hdr	1,'FORTH-WORDLIST',,1
fwlis:	call	docon
	dw	forth1

;	UNUSED	( -- u )	sys? if (esm) @ else sp@ then here
;				255 + 2dup u> -rot - and

	hdr	1,'UNUSED'
unus:	call	docol
	dw	sysq
	dw	zbran,unus1
	dw	lit,esm
	dw	at
	dw	bran,unus2
unus1	dw	spat
unus2	dw	here
	dw	clit		; allow margin
	db	255
	dw	plus
	dw	tdup
	dw	ugrea
	dw	drot
	dw	subb
	dw	andd
	dw	exit

;	interpret  ( -- )	begin bl-word dup c@ while find ?dup if
;				state? = if compile, else execute then
;				else count base @ >r over c@ case [char] $
;				of hex 1 endof [char] # of decimal 1 endof
;				0 swap endcase /string 2dup number? if
;				2swap 2drop dpl @ 0< if drop state? if
;				postpone literal then else state? if
;				postpone 2literal then then true else
;				fnumber then r> base ! ?defined then ?stack
;				repeat drop

	hdr	1,'INTERPRET',,1
inte:	call	docol
inte1	dw	blword
	dw	dupp,cat
	dw	zbran,inte15	; while not end of input stream
	dw	find
	dw	qdup
	dw	zbran,inte4	; if found
	dw	stateq
	dw	equal
	dw	zbran,inte2	; if compiling and not immediate
	dw	comxt
	dw	bran,inte3
inte2	dw	exec
inte3	dw	bran,inte14
inte4	dw	count
	dw	base,at,tor
	dw	over,cat
	dw	clit
	db	'$'
	dw	pof,inte5
	dw	hex,one
	dw	bran,inte7
inte5	dw	clit
	db	'#'
	dw	pof,inte6
	dw	decim,one
	dw	bran,inte7
inte6	dw	zero,swap
	dw	drop
inte7	dw	sstr
	dw	tdup
inte8	dw	numq		; NUMBER? patch
	dw	zbran,inte12
	dw	tswap,tdrop
	dw	dpl,at,zless
	dw	zbran,inte10
	dw	drop
	dw	stateq
	dw	zbran,inte9
	dw	liter
inte9	dw	bran,inte11
inte10	dw	stateq
	dw	zbran,inte11
	dw	tlite
inte11	dw	true
	dw	bran,inte13
inte12	dw	fnu		; FNUMBER patch
inte13	dw	fromr,base,store
	dw	qdef
inte14	dw	qstac
	dw	bran,inte1
inte15	dw	drop
	dw	exit

;	(eval)	( c-addr u blk -- )	blk @ >in @ 2>r source 2>r blk !
;					'source 2! >in off interpret 2r>
;					'source 2! 2r> >in ! blk !

	hdr	x,'(EVAL)',,1		; does not restore block contents
peval:	call	docol
	dw	blk,at
	dw	inn,at
	dw	ttor
	dw	source,ttor
	dw	blk,store
	dw	tsourc,tstor
	dw	inn,off			; reset >IN
	dw	inte
	dw	tfrom,tsourc,tstor
	dw	tfrom
	dw	inn,store
	dw	blk,store
	dw	exit

;	?block	 ( -- )			blk @ ?dup if block drop then

	hdr	x,'?BLOCK',,1		; restore block
qblock:	call	docol
	dw	blk,at,qdup
	dw	zbran,qblock1
	dw	block,drop
qblock1	dw	exit

;	EVALUATE  ( c-addr u -- )	0 (eval) ?block

	hdr	1,'EVALUATE',,1
eval:	call	docol
	dw	zero,peval
	dw	qblock
	dw	exit

;	(refill)  ( -- flag )	blk @ ?dup if 1+ dup #screens u< and dup
;				while dup blk ! block b/buf else (tib)
;				dup 80 accept space then 'source 2! >in
;				off true then

	hdr	x,'(REFILL)',,1		; doesn't correctly handle source
prefil:	call	docol			; from EVALUATE
	 if	debug
	dw	pdotq
	dcs	'(REFILL) '
	 endif
	dw	blk,at,qdup
	dw	zbran,prefil1
	dw	onep,dupp
	dw	nscr,uless
	dw	andd,dupp
	dw	zbran,prefil3
	dw	dupp,blk,store
	dw	block,bbuf
	dw	bran,prefil2
prefil1	dw	lit,tib
	dw	dupp
	dw	clit
	db	80
	dw	accept
	dw	space
prefil2	dw	tsourc,tstor
	dw	inn,off
	dw	true
prefil3	dw	exit

;	REFILL  ( -- flag )

	hdr	1,'REFILL',,1
refil:	call	dodef
	dw	prefil

;	reset  ( -- )		catcher off cseg sseg ! -caps bios-io
;				console

	hdr	x,'RESET'
reset:	call	docol
	dw	catchr,off	; reset error handler
	dw	csegg		; set search segment
	dw	sseg,store
	dw	dcaps		; reset COMPARE/SEARCH caps
	dw	biosio		; default i/o mode
	dw	consol		; set EMIT vector
	dw	exit

;	/interpret  ( -- )	blk off >in off postpone [

	hdr	x,'/INTERPRET',,1
sinte:	sub	ax,ax
	mov	blk1,ax
	mov	inn1,ax
	jmp	lbrac

;	QUIT  ( -- )		r0 @ rp! reset normal /interpret begin
;				cr (refill) drop interpret state? 0= if
;				."  ok" then again

	hdr	1,'QUIT',,1
quit:	call	docol
quit1	dw	rzero,at
	dw	rpsto
	dw	reset
	dw	vnorm
	dw	sinte
	 if	debug
	dw	pdotq
	dcs	'QUIT '
	 endif
quit2	dw	crr
	dw	prefil,drop
	dw	inte
	dw	stateq
	dw	zequ
	dw	zbran,quit3
	dw	pdotq
	dcs	' ok'
quit3	dw	bran,quit2

;	RETURN  ( x -- )	exit to DOS with return code x

	hdr	1,'RETURN'
retrn:	mov	al,iattr		; restore video attribute
	mov	cattr,al
	mov	al,cr			; force update - this kludge
	call	bcono			; works if cursor is located
	mov	al,lf			; on bottom screen row
	call	bcono
	call	gmode			; restore video mode
	mov	ax,word ptr imode
	cmp	ax,word ptr cmode
	jz	retrn1
	sub	ah,ah
	int	10h
retrn1:	mov	dl,defdrv		; restore drive
	mov	ah,0eh
	int	21h
	pop	ax
	mov	ah,4Ch
	int	21h

;	BYE  ( -- )		close-all 0 return

	hdr	1,'BYE',,1
bye:	call	docol
	dw	closa
	dw	zero
	dw	retrn

;	boot?  ( -- bootword )	(iboot) @

	hdr	x,'BOOT?'
bootq:	push	word ptr iboot
	nextt

;	(abort)  ( -- )		s0 @ sp! fs0 @ fsp ! boot? if 1 return then
;				quit

	hdr	x,'(ABORT)'
pabor:	call	docol
	dw	szero,at
	dw	spsto
	dw	fszero,at
	dw	fsp,store
	dw	bootq
	 if	not debug
	dw	zbran,quit1
	dw	one
	dw	retrn
	 else
	dw	zbran,pabor1
	dw	one
	dw	retrn
pabor1	dw	pdotq
	dcs	' (ABORT) '
	dw	quit
	 endif

;	.error  ( -- )		cr blk @ ?dup if file? and if loadfile type
;				>in @ 2- 0 max blk @ 2dup scr 2! ."  Scr "
;				u. c/l / ." Line " . cr then then ." Error: "
;				[char] " dup emit pwa count type emit

	hdr	x,'.ERROR',,1
doterr:	call	docol
	dw	crr
	dw	blk,at
	dw	qdup
	dw	zbran,doterr1
	dw	fileq
	dw	andd		; screen file open and loading from block?
	dw	zbran,doterr1
	dw	loadf,typee
	dw	inn,at
	dw	twom		; adjust pointer
	dw	zero,max
	dw	blk,at
	dw	tdup		; set error block, offset
	dw	scr,tstor
	dw	pdotq
	dcs	' Screen '
	dw	udot
	dw	csll
	dw	slash
	dw	pdotq
	dcs	'Line '
	dw	dot
	dw	crr
doterr1	dw	pdotq
	dcs	'Error: '
	dw	clit
	db	'"'
	dw	dupp,emit
	dw	pwa
	dw	count,typee	; word name
	dw	emit
	dw	exit

;	pwa  ( -- adr )		parsed word address

	hdr	x,'PWA',,1
pwa:	call	doval
	dw	?

;	error  ( n -- )
;				case -1 of (abort) then -2 of boot cell+
;				@ 0= if .error then space errmsg 2@ type
;				(abort) then ."  exception = " . (abort)
;				endcase

	hdr	x,'ERROR'
error:	call	docol
	dw	true		; -1
	dw	pof,error1
	dw	pabor
error1	dw	lit,-2
	dw	pof,error3
	dw	boot,cellp,at
	dw	zequ
	dw	zbran,error2
	dw	doterr		; skipped by applications
error2	dw	space
	dw	errmsg,tat
	dw	typee
	dw	pabor
error3	dw	pdotq
	dcs	' exception = '
	dw	dot
	dw	pabor
	dw	exit

;	CATCH  ( xt -- n | 0 )	sp@ >r fsp @ >r catcher @ >r rp@ catcher
;				! execute r> catcher ! 2r> 2drop 0

	hdr	1,'CATCH'
catch:	call	docol
	dw	spat,tor
	dw	fsp,at
	dw	tor
	dw	catchr,at,tor
	dw	rpat,catchr,store
	dw	exec
	dw	fromr,catchr,store
	dw	tfrom,tdrop
	dw	zero
	dw	exit

;	THROW  ( n -- )		?dup if catcher @ ?dup 0= if error then rp!
;				r> catcher ! r> fsp ! r> swap >r sp! drop
;				r> then

	hdr	1,'THROW'
throw:	call	docol
	dw	qdup
	dw	zbran,throw2
	dw	catchr,at
	 if	debug
	dw	pdotq
	dcs	' THROW:'
	dw	over,dot
	dw	pdotq
	dcs	'CATCHER:'
	dw	dupp,udot,space,space
	 endif
	dw	qdup,zequ
	dw	zbran,throw1
	dw	error
throw1	dw	rpsto
	dw	fromr,catchr,store
	dw	fromr,fsp,store
	dw	fromr,swap,tor
	dw	spsto
	dw	drop,fromr
throw2	dw	exit

;	ABORT  ( -- )		-1 throw

	hdr	1,'ABORT'
abort:	mov	ax,-1
abort1:	push	ax
	jmp	throw

;	(abort")  ( n -- )	r> count rot if errmsg 2! -2 throw then +
;				>r

	hdr	x,'(ABORT")'
pabq:	sub	ax,ax
	lodsb
	pop	cx
	jcxz	pabq1
	mov	bx,offset errmsg1
	mov	[bx],ax
	mov	[bx+cw],si
	mov	ax,-2
	jmp	abort1

pabq1:	add	si,ax
	nextt

;	ABORT"			postpone (abort") ," ;immediate

	hdr	1,'ABORT"',1,1
aborq:	call	docol
	dw	comp,pabq
	dw	comq
	dw	exit

; Cold start from DOS

	cseg

nodos	db	cr,lf,'wrong DOS version',cr,lf,'$'
noram	db	cr,lf,'not enough RAM'
crlf	db	cr,lf,'$'

cldd:	cld
	mov	ax,cs
	mov	ds,ax
	mov	segfth,ax
	mov	hseg1,ax
	mov	sp,offset tmpstk	; always safe

	mov	ax,3000h		; check dos version
	int	21h
	mov	word ptr dosv,ax
	cmp	al,2
	mov	dx,offset nodos
	mov	ah,0
	jc	cldd2

	mov	ax,boot1		; get BOOT word
	mov	iboot,ax		; save it
	test	ax,boot2
	pushf

	mov	bx,ulimit		; turnkey limit
	jnz	cldd1
	mov	bx,em/16		; default limit
	add	hseg1,bx		; set heads segment
	add	bx,hm/16		; add heads space
cldd1:	push	cs
	pop	es
	mov	ah,4ah			; adjust memory
	int	21h
	mov	dx,offset noram
	mov	ax,4C01h		; error-code = 1
	jnc	cldd3

cldd2:	push	ax
	mov	ah,9			; show failure
	int	21h
	pop	ax
	int	21h			; terminate

cldd3:	call	gmode			; save video mode
	mov	word ptr imode,ax
	mov	bh,ah
	mov	ah,8
	int	10h
	mov	iattr,ah		; save video attribute

	mov	ah,19h			; save current drive
	int	21h
	mov	defdrv,al

	mov	ax,40h			; set keyboard type
	mov	es,ax
	mov	bx,96h
	test	byte ptr es:[bx],10h
	mov	ax,0100h		; old
	jz	cldd4
	mov	ax,1110h		; extended
cldd4:	mov	word ptr kbfn,ax

	popf
	jz	cldd5			; need forth system

	mov	word ptr cold4,offset noop ; patch out forth init
	mov	di,ulimit+cw		; LIMIT for applications
	jmp	short cldd8

cldd5:	mov	byte ptr cmdf,0ffh	; enable command line flag

	push	ds			; move heads into place
	mov	di,idph
cldd6:	sub	cx,cx			; later patched to MOV CX,DI
	dec	di
	mov	si,di
	mov	es,hseg1
	mov	ax,ds
	add	ax,hstart
	mov	ds,ax
	std
	rep	movsb
	cld
	pop	ds

	mov	ax,idp			; move system into place
	mov	di,offset orig+sm
	mov	cx,idps
cldd7:	sub	cx,cx			; later patched to SUB CX,DI
	call	bmovu
	inc	di

cldd8:	mov	limit1,di		; patch LIMIT

	db	0E9h			; 'jmp'
cldd9	dw	movpat-$-2		; later patched to 'cold'

;	COLD  ( -- )

	hdr	1,'COLD'		; FIG
cold:	cld
	mov	ax,cs
	mov	ds,ax
	cli
	mov	ss,segfth
	mov	sp,offset tmpstk
	sti

	mov	word ptr esm,offset orig+fdbs ; patch end of system memory

	mov	ax,limit1		; get LIMIT
	sub	ax,nus
	mov	bp,ax			; init return stack
	mov	ir0,ax			; patch R0
	mov	upp,ax			; patch UP
	sub	ax,nrts
	mov	fspp,ax			; init fp stack
	mov	ifs0,ax			; patch FS0
	sub	ax,nfps			; fp stack size
	mov	sp,ax			; init data stack
	mov	is0,ax			; patch S0
	 if	cfs
	mov	cfz1,ax			; init CF0 with safe value
	 endif
	mov	di,bp			; init boot up variables
	mov	ax,offset initu
	mov	cx,initu2-initu
	call	movd
	mov	word ptr pause1,offset noop ; patch PAUSE

	mov	ax,0500h		; set video page = 0
cold1:	call	video
	call	gmode			; get video mode
	cmp	al,7			; 80 col mono
	jz	cold2
	cmp	al,3			; 80 col color
	jz	cold2
	cmp	al,2			; 80 col b/w
	jz	cold2
	mov	ax,3			; set video mode = 80 col color
	jmp	cold1			; (screen will blank)
cold2:	dec	bh			; cols
	mov	wmax,bh
	sub	bh,bh
	sub	dl,dl			; assume old CGA card
	mov	ax,1130h
	call	video
	or	dl,dl			; rows if EGA+
	jnz	cold3
	mov	dl,24
cold3:	mov	wmax+1,dl
	mov	word ptr wmin,0

	mov	al,iattr		; set default attribute
	and	al,7fh
	mov	cattr,al

	mov	dx,offset orig+dosbuf	; reset DOS DTA
	mov	ah,1ah
	int	21h

	call	docol
	dw	sys,off			; default is APPLICATION
	dw	decim			; default base
	dw	reset			; general reset
cold4	dw	freset			; forth reset
cold5	dw	init			; run INIT eg. for float
	dw	bootq
	dw	dupp,boot,store		; restore BOOT
	dw	qdup
	dw	zbran,cold6
	dw	exec			; run application
	dw	zero,retrn		; exit to DOS

	aseg				; run forth interpreter

cold6	dw	clit			; process command-line
	db	dosbuf
	dw	count
	dw	lit,cmdf
	dw	cat,andd
	dw	tuck
	dw	lit,tib			; copy to tib
	dw	zero,pstr
	dw	tsourc,tstor
	dw	zbran,cold8
	dw	zero
	dw	lit,cmdf		; disable
	dw	cstor
	dw	blword			; parse first word
	dw	at
	dw	lit
	db	1,'-'			; skips file open
	dw	subb
	dw	zbran,cold7
	dw	inn,off
	dw	getfn,popen
cold7	dw	inte			; interpret
cold8	dw	vnorm			; sign-on message
	dw	pagee
	dw	pdotq
	db	cold11-$-1
cold9	db	'DX-Forth '
	db	'0'+rel,'.','0'+rev/10
	db	'0'+rev mod 10
	db	'  '
	date
	 if	beta
	db	'  [beta release]'
	 endif
cold10	db	cr,lf,cr,lf
	db	'Forth-94'
cold11	dw	ident			; run IDENTIFY
	dw	crr
	dw	fileq
	dw	zbran,cold12
	dw	crr
	dw	pdotq
	dcs	'Using '
	dw	loadf,typee
	dw	crr
cold12	dw	quit			; jump to interpreter

;	SET-LIMIT  ( addr -- )	$fff0 and dup 4 rshift (ulimit) 2!

	hdr	1,'SET-LIMIT',,1
setlim:	pop	ax
	and	ax,0fff0h
	mov	ulimit+cw,ax
	mov	cl,4
	shr	ax,cl
	mov	ulimit,ax
	nextt

;	forth-reset  ( -- )	(em) set-limit empty warning on checking
;				on (fdbs) (fdsiz*nfd) erase empty-buffers
;				/interpret 'source off bl-word drop

	hdr	x,'FORTH-RESET',,1
freset:	call	docol
	dw	lit,em
	dw	setlim
	dw	empty		; reset vocabulary pointers
	dw	warnn,on	; enable warnings
	dw	check,on	; enable checking
	dw	lit,fdbs	; clear files
	dw	lit,fdsiz*nfd	;
	dw	erase		;
	dw	mtbuf		; mark screen buffer as empty
	dw	sinte		; reset interpreter
	dw	tsourc,off	; clear parsed word buffer
	dw	blword,drop	;
	dw	exit

;	FREEZE	( -- )		up @ (initu) (initu2-initu) cmove

	hdr	1,'FREEZE',,1
freez:	call	docol
	dw	up,at
	dw	lit,initu
	dw	lit,initu2-initu
	dw	cmove
	dw	exit

;	'prune			variable 'prune  'prune off

	hdr	x,"'PRUNE",,1
tprun:	call	dovar
	dw	toppru		; 0=end

;	REMEMBER  ( xt -- )	here 'prune dup @ , ! ,

	hdr	1,'REMEMBER',,1	; add to prunes list
remem:	call	docol
	dw	here
	dw	tprun
	dw	dupp,at
	dw	comma		; save old link
	dw	store		; update new link
	dw	comma		; xt
	dw	exit

;	xdp  ( xt -- xt xdp )	dup limit u< if dp else dps then

	hdr	x,'XDP',,1
xdp:	call	docol
	dw	dupp
	dw	limit,uless
	dw	zbran,xdp1
	dw	dpp
	dw	bran,xdp2
xdp1	dw	dps
xdp2	dw	exit

;	prunes  ( -- )		begin 'prune @ dup while dup xdp @ u< 0=
;				while 2@ 'prune ! execute repeat then drop

	hdr	x,'PRUNES',,1
pruns:	call	docol
pruns1	dw	tprun,at
	dw	dupp
	dw	zbran,pruns2
	dw	dupp
	dw	xdp,at
	dw	uless,zequ
	dw	zbran,pruns2
	dw	tat
	dw	tprun,store
	dw	exec
	dw	bran,pruns1
pruns2	dw	drop
	dw	exit

;	(forget)  ( nfa dps dp -- )
;				dp 2! >r voc-link begin @ dup cell+ @ r@
;				u< until dup voc-link ! begin dup cell-
;				dup @ begin dup r@ u< 0= while -alias if
;				dup name> xdp tuck @ umin swap ! then
;				n>name repeat swap ! @ ?dup 0= until r>
;				dup dph ! (idph) @ u< if freeze then
;				prunes

	hdr	x,'(FORGET)',,1
pforg:	call	docol
	dw	dpp,tstor
	dw	tor
	dw	vocl
pforg1	dw	at
	dw	dupp,cellp,at	; voc nfa
	dw	rat,uless
	dw	zbran,pforg1
	dw	dupp,vocl,store
pforg2	dw	dupp,cellm
	dw	dupp
	dw	at
pforg3	dw	dupp,rat
	dw	uless,zequ
	dw	zbran,pforg5
	dw	dalias		; skip if alias
	dw	zbran,pforg4
	dw	dupp,namef
	dw	xdp
	dw	tuck,at
	dw	umin
	dw	swap,store
pforg4	dw	ntnam
	dw	bran,pforg3
pforg5	dw	swap,store
	dw	at
	dw	qdup,zequ
	dw	zbran,pforg2
	dw	fromr
	dw	dupp
	dw	dph,store
	dw	lit,idph	; below fence?
	dw	at,uless
	dw	zbran,pforg6
	dw	freez		; fix bootup values
pforg6	dw	pruns		; run prunes chain
	dw	exit

;	EMPTY  ( -- )		only forth definitions (idph) @ (idp)
;				2@ (forget)

	hdr	1,'EMPTY',,1
empty:	call	docol
	dw	only
	dw	forth,defin	; switch to a safe vocabulary
	dw	lit,idph
	dw	at
	dw	lit,idp
	dw	tat
	dw	pforg
	dw	exit

;	?name  ( "name" -- xt nfa )
;				token context@ (search) ?defined
;				dup (idph) @ u< abort" is protected"

	hdr	x,'?NAME',,1	; find name in context wordlist
qname:	call	docol
	dw	token
	dw	contat
	dw	psear,qdef
	dw	dupp
	dw	lit,idph
	dw	at,uless
	dw	pabq
	dcs	'is protected'
	dw	exit

;	BEHEAD  ( "name1" "name2" -- )
;				?name nip ?name nip 2dup u> if swap then >r
;				n>name context@ cseg begin swap 2dup @l r@
;				- while @l n>link hseg repeat !l r> drop

	hdr	1,'BEHEAD',,1	; unlink word heads
behead:	call	docol
	dw	qname,nip
	dw	qname,nip
	dw	tdup,ugrea
	dw	zbran,behead1
	dw	swap
behead1	dw	tor
	dw	ntnam
	dw	contat
	dw	csegg
behead2	dw	swap,tdup
	dw	atl,rat
	dw	subb
	dw	zbran,behead3
	dw	atl,nlnk
	dw	hseg
	dw	bran,behead2
behead3	dw	storl
	dw	fromr,drop
	dw	exit

;	FORGET	( "name" -- )	only get-current context ! ?name -alias
;				0= abort" is alias" swap limit over u<
;                               if dp @ else dps @ swap then (forget)

	hdr	1,'FORGET',,1
forg:	call	docol
	dw	only
	dw	getcur
	dw	cont,store
	dw	qname
	dw	dalias,zequ	; alias?
	dw	pabq
	dcs	'is alias'
	dw	swap
	dw	limit
	dw	over,uless
	dw	zbran,forg1
	dw	dpp,at
	dw	bran,forg2
forg1	dw	dps,at
	dw	swap
forg2	dw	pforg
	dw	exit

;	MARKER  ( "name" -- )	sys? sp@ >r dph @ dp 2@ get-current
;				get-order system create sp@ r@ over -
;				string, r> sp! sys ! does> count 2/ >s
;				set-order set-current (forget)

	hdr	1,'MARKER',,1
marker:	call	docol
	dw	sysq
	dw	spat,tor
	dw	dph,at
	dw	dpp,tat
	dw	getcur
	dw	getord
	dw	system
	dw	creat
	dw	spat,rat
	dw	over,subb
	dw	scomm
	dw	fromr,spsto
	dw	sys,store
	dw	pscod
domark:	call	docol
	dw	count
	dw	twodiv,tos
	dw	setord
	dw	setcur
	dw	pforg
	dw	exit

;	COMPILE,  ( xt -- )	warning @ 0< if dup limit u< sys? d0=
;				if dup .name ."  is system " then then ,

	hdr	1,'COMPILE,',,1
comxt:	call	docol
	dw	warnn,at
	dw	zless
	dw	zbran,comxt1
	dw	dupp,limit
	dw	uless
	dw	sysq
	dw	dzequ
	dw	zbran,comxt1
	dw	dupp
	dw	dotnam
	dw	pdotq
	dcs	' is system '
comxt1	dw	comma
	dw	exit

;	COMPILE  ( -- ) 	?comp r> dup 2+ >r @ compile,

	hdr	1,'COMPILE',,1
comp:	call	docol
	dw	qcomp		; prevent crash if interpreting
	dw	fromr
	dw	dupp,twop
	dw	tor
	dw	at
	dw	comxt
	dw	exit

;	POSTPONE		?comp defined dup ?defined 0< if
;				compile compile then compile, ;immediate

	hdr	1,'POSTPONE',1,1
postp:	call	docol
	dw	qcomp
	dw	defined
	dw	dupp,qdef
	dw	zless
	dw	zbran,postp1
	dw	comp,comp
postp1	dw	comxt
	dw	exit

;	string,  ( c-addr u -- )  255 min here over 1+ allot place

	hdr	x,'STRING,',,1
scomm:	call	docol
	dw	clit
	db	255
	dw	min
	dw	here,over
	dw	onep,allot
	dw	place
	dw	exit

;	,"  ( "ccc" -- )	parse" string,

	hdr	1,',"',,1
comq:	call	docol
	dw	parsq
	dw	scomm
	dw	exit

;	(s")  ( -- c-addr u )	r> count 2dup + >r

	hdr	x,'(S")'
psqot:	sub	ax,ax
	lodsb
	push	si
	push	ax
	add	si,ax
	nextt

;	SLITERAL  ( c-addr u -- )  postpone (s") string, ;immediate

	hdr	1,'SLITERAL',1,1
slite:	call	docol
	dw	comp,psqot
	dw	scomm
	dw	exit

;	S"  ( -- c-addr u )	parse" state? if postpone sliteral then
;				;immediate

	hdr	1,'S"',1,1	; state smart version
squot:	call	docol
	dw	parsq
	dw	stateq
	dw	zbran,squot1
	dw	slite
squot1	dw	exit

	 if	0

;	(c")  ( -- c-addr )	r> dup count + >r

	hdr	x,'(C")'
pcqot:	push	si
	sub	ax,ax
	lodsb
	add	si,ax
	nextt

;	C"  ( -- c-addr u )	postpone (c") ," ;immediate

	hdr	1,'C"',1,1
cquot:	call	docol
	dw	comp,pcqot
	dw	comq
	dw	exit

	 endif

;	(.")			r> count 2dup + >r type

	hdr	x,'(.")'
pdotq:	sub	ax,ax
	lodsb
	push	si
	push	ax
	add	si,ax
	jmp	typee

;	."			postpone (.") ," ;immediate

	hdr	1,'."',1,1
dotq:	call	docol
	dw	comp,pdotq
	dw	comq
	dw	exit

;	LITERAL  ( n -- )	dup 255 u> if postpone lit , exit then
;				postpone clit c, ;immediate

	hdr	1,'LITERAL',1,1
liter:	call	docol
	dw	dupp
	dw	clit
	db	255
	dw	ugrea
	dw	zbran,liter1
	dw	comp,lit
	dw	comma
	dw	exit
liter1	dw	comp,clit
	dw	ccomm
	dw	exit

;	2LITERAL  ( x1 x2 -- )	postpone 2lit , , ;immediate

	hdr	1,'2LITERAL',1,1
tlite:	call	docol
	dw	comp,tlit
	dw	comma,comma
	dw	exit

;	[']			' postpone literal ;immediate

	hdr	1,'['']',1,1
btick:	call	docol
	dw	tick
	dw	liter
	dw	exit

;	[COMPILE]		' compile, ;immediate

	hdr	1,'[COMPILE]',1,1
bcomp:	call	docol
	dw	tick
	dw	comxt
	dw	exit

;	RECURSE  ( -- ) 	last cell+ @ compile, ;immediate

	hdr	1,'RECURSE',1,1
recurs:	call	docol
	dw	last,cellp
	dw	at
	dw	comxt
	dw	exit

;	CHAR  ( -- char )	bl-word 1+ c@

	hdr	1,'CHAR',,1
char:	call	docol
	dw	blword
	dw	onep,cat
	dw	exit

;	[CHAR]	( -- char )	char postpone literal ;immediate

	hdr	1,'[CHAR]',1,1
pchar:	call	docol
	dw	char
	dw	liter
	dw	exit

;	Y/N  ( -- flag )	." (y/n) N\bs" key upcase [char] Y = dup
;				if [char] Y else [char] N then emit space

	hdr	1,'Y/N'
yn:	call	docol
	dw	pdotq
	dcs	'(y/n) N',bs
	dw	key,upcas
	dw	clit
	db	'Y'
	dw	equal,dupp
	dw	zbran,yn1
	dw	clit
	db	'Y'
	dw	bran,yn2
yn1	dw	clit
	db	'N'
yn2	dw	emit,space
	dw	exit

;
;	File and Block Functions
;
; PATH  -PATH  filetype?  +EXT  -EXT  FILE-POSITION  FILE-SIZE
; RESIZE-FILE  REPOSITION-FILE  READ-FILE  WRITE-FILE  hwrite
; READ-LINE  WRITE-LINE  R/O  W/O  R/W  BIN  OPEN-FILE
; CREATE-FILE  CLOSE-FILE  FLUSH-FILE  FILE-STATUS  DELETE-FILE
; RENAME-FILE  sfp  SWAP-FILE  FDB  fnb  scr#  blks  fid  fd
; buf  blk#  FILE?  LOADFILE  ?open  #SCREENS  EMPTY-BUFFERS
; UPDATE  blkerr  blk-rw  ?blk  SAVE-BUFFERS  FLUSH  BUFFER
; BLOCK  -->  LOAD  THRU  FILEBLOCKS  CLOSE  CLOSE-ALL  lastfile
; .lastfile  ?create  init-scr  OPEN  (open)  GETFILENAME  USING
; LOADED  FLOAD  SAVE  TURNKEY  TURNKEY-SYSTEM

;	PATH  ( u -- c-addr u ior )

	hdr	1,'PATH'	; uses asciiz buffer
path:	pop	ax
	or	ax,ax
	jnz	path1
	mov	ah,19h
	int	21h
	inc	al
path1:	mov	dl,al
	mov	bx,zbuf1
	push	bx
	add	al,'@'
	mov	[bx],al
	inc	bx
	mov	[bx],'\:'
	add	bx,2
	push	si
	mov	si,bx
	mov	ah,47h
	int	21h
	pop	si
	jc	path3
	pop	bx
	push	bx
	call	zcnt1
	cmp	ax,3
	jz	path2
	mov	byte ptr [bx],'\'
	inc	ax
path2:	push	ax
	jmp	zero

path3:	mov	dx,0		; don't change CF
	push	dx
	jmp	doserr1

;	-PATH  ( c-addr1 u1 -- c-addr2 u2 )
;				2dup [char] : scan dup if 1 /string 2swap
;				then begin 2drop 2dup [char] \ scan dup
;				while 1 /string 2swap repeat 2drop

	hdr	1,'-PATH'
dpath:	call	docol
	dw	tdup
	dw	clit
	db	':'
	dw	scan
	dw	dupp
	dw	zbran,dpath1
	dw	one,sstr
	dw	tswap
dpath1	dw	tdrop
	dw	tdup
	dw	clit
	db	'\'
	dw	scan,dupp
	dw	zbran,dpath2
	dw	one,sstr
	dw	tswap
	dw	bran,dpath1
dpath2	dw	tdrop
	dw	exit

;	filetype?  ( c-addr1 u1 -- u2 )  -path [char] . scan nip

	hdr	x,'FILETYPE?'	; get filetype length
ftype:	call	docol
	dw	dpath
	dw	clit
	db	'.'
	dw	scan
	dw	nip
	dw	exit

;	+EXT  ( c-addr1 u1 c-addr2 u2 -- c-addr3 u3 )
;				2over filetype? if 2drop exit then 3 min
;				s" ." 2rot -trailing (pfsiz-5) min zbuf
;				@ 0 +string +string +string

	hdr	1,'+EXT'	; uses asciiz buffer
pext:	call	docol
	dw	tover,ftype
	dw	zbran,pext1
	dw	tdrop,exit
pext1	dw	three,min
	dw	psqot
	dcs	'.'
	dw	trot
	dw	dtrai		; trim trailing blanks
	dw	clit
	db	pfsiz-5
	dw	min
	dw	zbuf,at		; unused
	dw	zero
	dw	pstr
	dw	pstr
	dw	pstr
	dw	exit

;	-EXT  ( c-addr1 u1 -- c-addr2 u2 )  2dup filetype? -

	hdr	1,'-EXT'
dext:	call	docol
	dw	tdup,ftype
	dw	subb
	dw	exit

;	FILE-POSITION  ( fileid -- ud ior )

	hdr	1,'FILE-POSITION'
fpos:	pop	bx
	sub	cx,cx
	mov	dx,cx
	mov	ax,4201h
	int	21h
	push	ax
	push	dx
fpos1:	jmp	doserr1

;	FILE-SIZE  ( fileid -- ud ior )

	hdr	1,'FILE-SIZE'
fsiz:	pop	bx
	sub	cx,cx
	mov	dx,cx
	mov	ax,4201h
	int	21h
	push	ax
	push	dx
	jc	fpos1
	mov	dx,cx		; assume CX BX unchanged
	mov	ax,4202h
	int	21h
	pop	cx
	pop	di
	push	ax
	push	dx
	mov	dx,di
	mov	ax,4200h
	int	21h
	jmp	zero

;	RESIZE-FILE  ( ud fileid -- ior )

	hdr	1,'RESIZE-FILE'
resizf:	pop	bx
	pop	cx
	pop	dx
	mov	ax,4200h
	int	21h
	jc	resizf2
	sub	cx,cx		; truncate file
	mov	ah,40h		; assume BX unchanged
resizf1:int	21h
resizf2:jmp	doserr1

;	REPOSITION-FILE  ( ud fileid -- ior )

	hdr	1,'REPOSITION-FILE'
reposf:	pop	bx
	pop	cx
	pop	dx
	mov	ax,4200h
	jmp	resizf1

;	READ-FILE  ( c-addr u1 fileid -- u2 ior )

	hdr	1,'READ-FILE'
readf:	pop	bx
	pop	cx
	pop	dx
	mov	ah,3fh
readf1:	int	21h
	push	ax
	jmp	doserr1

;	WRITE-FILE  ( c-addr u fileid -- ior )

	hdr	1,'WRITE-FILE'
writf:	mov	ax,ds
writf1:	pop	bx
	pop	cx
	pop	dx
	or	cx,cx		; must trap CX=0
	jnz	writf2
	jmp	zero

writf2:	mov	ds,ax
	mov	ah,40h
	int	21h
	push	cs
	pop	ds
	jc	writf3
	cmp	ax,cx		; assume CX unchanged
	mov	al,255
writf3:	jmp	doserr1

;	hwrite  ( h-addr u fileid -- ior )

	hdr	x,'HWRITE',,1
hwrite:	mov	ax,word ptr hseg1
	jmp	writf1

;	READ-LINE  ( c-addr u1 fileid -- u2 flag ior )

	hdr	1,'READ-LINE'
readl:	pop	bx
	pop	cx
	pop	di
	sub	dx,dx		; u2
	call	readl6
	jc	readl5
	or	ax,ax
	jnz	readl2
	sub	bx,bx		; flag
	jmp	short readl4

readl1:	call	readl6
	jc	readl5
	or	ax,ax
	jz	readl3
readl2:	mov	al,[di]
	cmp	al,lf
	jz	readl3
	cmp	al,cr
	jz	readl1
	inc	di
	inc	dx
	loop	readl1
readl3:	mov	bx,-1
readl4:	sub	ax,ax		; also clears CF
readl5:	push	dx
	push	bx
	jmp	doserr1

readl6:	push	cx
	xchg	dx,di
	mov	cx,1
	mov	ah,3fh
	int	21h
	xchg	dx,di
	pop	cx
	ret

;	WRITE-LINE  ( c-addr u fileid -- ior )
;				dup >r write-file ?dup if r> drop exit
;				then (crlf) 2 r> write-file

	hdr	1,'WRITE-LINE'
writl:	call	docol
	dw	dupp,tor
	dw	writf
	dw	qdup
	dw	zbran,writl1
	dw	fromr,drop
	dw	exit
writl1	dw	lit,crlf
	dw	two
	dw	fromr
	dw	writf
	dw	exit

	cseg

pascii:	push	bx
	push	ax
	call	docol
	dw	asciiz
	dw	exit1
	pop	dx	; addr
	ret

;	R/O  ( -- fam )			aka 0 r/o

	hdr	1,'R/O',,,zero
rso	equ	zero

;	W/O  ( -- fam )			aka 1 w/o

	hdr	1,'W/O',,,one
wso	equ	one

;	R/W  ( -- fam )			aka 2 r/w

	hdr	1,'R/W',,,two
rsw	equ	two

;	BIN  ( fam1 -- fam2 )		aka noop bin immediate

	hdr	1,'BIN',1,,noop
binn	equ	next

;	OPEN-FILE  ( c-addr u fam -- fileid ior )

	hdr	1,'OPEN-FILE'
openf:	pop	dx
	pop	ax
	pop	bx
	push	dx
	call	pascii
openf1:	pop	ax		; fam
	mov	ah,3dh
	jmp	readf1

;	CREATE-FILE  ( c-addr u fam -- fileid ior )

	hdr	1,'CREATE-FILE'
creatf:	pop	dx
	pop	ax
	pop	bx
	push	dx		; fam (or dummy fileid if fail)
	call	pascii
	push	dx		; asciiz
	sub	cx,cx		; normal attribute
	mov	ah,3ch
	int	21h
	jnc	creatf1
	pop	dx		; discard
	jmp	doserr1		; failed

creatf1:mov	bx,ax		; close and re-open file using fam
	mov	ah,3eh
	int	21h
	pop	dx		; asciiz
	jmp	openf1

;	CLOSE-FILE  ( fileid -- ior )

	hdr	1,'CLOSE-FILE'
closf:	pop	bx
	mov	ah,3eh
	jmp	resizf1

;	FLUSH-FILE  ( fileid -- ior )

	hdr	1,'FLUSH-FILE'
flusf:	pop	bx
	mov	ah,45h
	int	21h
	jc	flusf1
	push	ax
	jmp	closf

flusf1:	jmp	doserr1

;	FILE-STATUS  ( c-addr u -- x ior )	get file attributes

	hdr	1,'FILE-STATUS'
statf:	pop	ax
	pop	bx
	call	pascii
	mov	ax,4300h
	int	21h
	push	cx
	jmp	doserr1

;	DELETE-FILE  ( c-addr u -- ior )

	hdr	1,'DELETE-FILE'
delf:	pop	ax
	pop	bx
	call	pascii
	mov	ah,41h
	jmp	resizf1

;	RENAME-FILE  ( c-addr1 u1 c-addr2 u2 -- ior )

	hdr	1,'RENAME-FILE'
renf:	pop	ax
	pop	bx
	call	pascii
	pop	ax
	pop	bx
	push	dx
	call	pascii
	pop	di
	mov	ax,ds
	mov	es,ax
	mov	ah,56h
	int	21h
	jmp	doserr1

; screen file selector

	aseg

fdtab:	gfdb			; fdb table

;	sfp  ( -- a )

	hdr	x,'SFP',,1
sfp:	call	dovar
sfp1	dw	fdtab		; current
sfp2	dw	fdtab+cw	; swap-file

;	SWAP-FILE  ( -- )	scr @ scr# ! sfp 2@ swap sfp 2!
;				scr# @ scr ! empty-buffers

	hdr	1,'SWAP-FILE',,1
swapf:	call	docol
	dw	scr,at
	dw	snum,store
	dw	sfp,tat
	dw	swap
	dw	sfp,tstor
	dw	snum,at
	dw	scr,store
	dw	mtbuf
	dw	exit

;	FDB  ( -- addr )	(fdtab) (nfd) 0 do dup @ @ 0= if unloop exit
;				then cell+ loop abort" too many files"

	hdr	1,'FDB',,1	; get a free slot
fdb:	mov	bx,offset fdtab
	mov	cx,offset orig+nfd
fdb1:
;	cmp	bx,sfp2		; skip swap-file
;	jz	fdb2
	mov	di,[bx]
	cmp	word ptr [di],0
	jz	fdb3
fdb2:	inc	bx
	inc	bx
	loop	fdb1
	call	docol
	dw	one
	dw	pabq
	dcs	'too many files'

fdb3:	push	bx
	nextt

; file descriptor fields
;
;	FD	cell		status 0=closed
;	FID	cell		file handle
;	BLKS	cell		file size (blocks)
;	SCR#	cell		current SCR#
;	FNB	'pfsiz' bytes	file name

;	fnb  ( -- addr )

	hdr	x,'FNB',,1
fnb:	mov	al,cw*4		; file name field
	ignore2

;	scr#  ( -- addr )

	hdr	x,'SCR#',,1
snum:	mov	al,cw*3		; current SCR# field
	ignore2

;	blks  ( -- addr )

	hdr	x,'BLKS',,1
blks:	mov	al,cw*2		; file size field
	ignore2

;	fid  ( -- addr )

	hdr	x,'FID',,1
fid:	mov	al,cw*1		; file handle field
	ignore2

;	fd  ( -- addr )

	hdr	x,'FD',,1
fd:	mov	al,0		; file descriptor field
	sub	ah,ah
	mov	di,sfp1
	add	ax,[di]
	jmp	apush

;	buf	( -- addr )

	hdr	x,'BUF',,1
buf:	call	docon		; file buffer address
	dw	sfb

;	blk#  ( -- addr )

	hdr	x,'BLK#',,1
bnum:	call	dovar		; block#, update flag
bnum1	dw	?

;	FILE?  ( -- flag )	fd @ 0<>

	hdr	1,'FILE?',,1
fileq:	call	docol
	dw	fd,at
	dw	zneq
	dw	exit

;	LOADFILE  ( -- c-addr u )  fnb count

	hdr	1,'LOADFILE',,1
loadf:	call	docol
	dw	fnb,count
	dw	exit

;	?open  ( -- )		file? 0= abort" no file open"

	hdr	x,'?OPEN',,1
qopen:	call	docol
	dw	fileq
	dw	zequ
	dw	pabq
	dcs	'no file open'
	dw	exit

;	#SCREENS  ( -- +n )	?open blks @

	hdr	1,'#SCREENS',,1
nscr:	call	docol
	dw	qopen
	dw	blks,at
	dw	exit

;	EMPTY-BUFFERS  ( -- )	$7fff blk# !

	hdr	1,'EMPTY-BUFFERS',,1
mtbuf:	mov	bnum1,7fffh
	nextt

;	UPDATE	( -- )		?open blk# @ $8000 or blk# !

	hdr	1,'UPDATE',,1
update:	call	docol
	dw	qopen
	dw	exit1
	or	bnum1,8000h
	nextt

;	blkerr  ( flag -- )	abort" block r/w error"

	hdr	x,'BLKERR',,1
blkerr:	call	docol
	dw	pabq
	dcs	'block r/w error'
	dw	exit

;	blk-rw  ( +n mode -- )	>r b/buf um* fid @ reposition-file blkerr
;				buf b/buf fid @ r> if write-file else
;				read-file blkerr b/buf < then blkerr

	hdr	x,'BLK-RW',,1
blkrw:	call	docol
	dw	tor
	dw	bbuf,umstr
	dw	fid,at
	dw	reposf
	dw	blkerr
	dw	buf,bbuf
	dw	fid,at
	dw	fromr
	dw	zbran,blkrw1
	dw	writf
	dw	bran,blkrw2
blkrw1	dw	readf
	dw	blkerr
	dw	bbuf,less
blkrw2	dw	blkerr
	dw	exit

;	?blk  ( +n -- +n )	dup 0 #screens within 0=
;				abort" block out of range"

	hdr	x,'?BLK',,1
qblk:	call	docol
	dw	dupp
	dw	zero,nscr
	dw	within,zequ	; block in range?
	dw	pabq
	dcs	'block out of range'
	dw	exit

;	SAVE-BUFFERS  ( -- )	?open blk# @ 0< if blk# @ $7fff and
;				dup blk# ! ?blk 1 blk-rw then

	hdr	1,'SAVE-BUFFERS',,1
savbuf:	call	docol
	dw	qopen
	dw	bnum,at
	dw	zless
	dw	zbran,savbuf1
	dw	bnum,at
	dw	lit,7fffh
	dw	andd
	dw	dupp
	dw	bnum,store
	dw	qblk		; block in range?
	dw	one,blkrw
savbuf1	dw	exit

;	FLUSH  ( -- )		save-buffers empty-buffers

	hdr	1,'FLUSH',,1
flush:	call	docol
	dw	savbuf,mtbuf
	dw	exit

;	BUFFER	( +n -- addr )	save-buffers ?blk blk# ! buf

	hdr	1,'BUFFER',,1
buffer:	call	docol
	dw	savbuf
	dw	qblk
	dw	bnum,store
	dw	buf
	dw	exit

;	BLOCK  ( +n -- addr )	?open blk# @ $7fff and over - if dup
;				buffer drop 0 blk-rw else drop then buf

	hdr	1,'BLOCK',,1
block:	call	docol
	dw	qopen
	dw	bnum,at
	dw	lit,7fffh
	dw	andd,over,subb
	dw	zbran,block1
	dw	dupp,buffer,drop
	dw	zero,blkrw
	dw	bran,block2
block1	dw	drop
block2	dw	buf
	dw	exit

;	-->  ( -- )		blk @ 0= abort" loading only" (refill) drop
;				;immediate

	hdr	1,'-->',1,1
arrow:	call	docol
	dw	blk,at
	dw	zequ
	dw	pabq
	dcs	'loading only'
	dw	prefil,drop
	dw	exit

;	(thru)  ( +n1 +n2 -- )	1+ swap ?do i block b/buf i (eval) loop

	hdr	x,'(THRU)',,1
pthru:	call	docol
	dw	onep,swap
	dw	xqdo,pthru2
pthru1	dw	ido,block
	dw	bbuf
	dw	ido,peval
	dw	xloop,pthru1
pthru2	dw	exit

;	LOAD  ( +n -- ) 	dup thru

	hdr	1,'LOAD',,1
load:	pop	ax
	push	ax
	push	ax

;	THRU  ( +n1 +n2 -- )	(thru) ?block

	hdr	1,'THRU',,1
thru:	call	docol
	dw	pthru
	dw	qblock
	dw	exit

;	FILEBLOCKS  ( +n -- )	#screens 2dup u< if drop dup then tuck -
;				swap dup b/buf um* 2dup fid @ resize-file
;				>r fid @ reposition-file r> or if 2drop 1
;				else over + blks ! b/buf 128 */ dosbuf
;				128 blank 0 tuck ?do dosbuf 128 fid @
;				write-file if 1+ leave then loop then
;				abort" can't resize file"

	hdr	1,'FILEBLOCKS',,1
fbloc:	call	docol		; uses DOSBUF
	dw	nscr		; tests if file open
	dw	tdup,uless
	dw	zbran,fbloc1
	dw	drop,dupp
fbloc1	dw	tuck
	dw	subb,swap
	dw	dupp
	dw	bbuf
	dw	umstr
	dw	tdup
	dw	fid,at
	dw	resizf
	dw	tor
	dw	fid,at
	dw	reposf
	dw	fromr,orr
	dw	zbran,fbloc2
	dw	tdrop,one
	dw	bran,fbloc5
fbloc2	dw	over,plus
	dw	blks,store	; update max block
	dw	bbuf
	dw	clit
	db	128
	dw	ssla
	dw	clit
	db	dosbuf
	dw	clit
	db	128
	dw	blank
	dw	zero,tuck
	dw	xqdo,fbloc5
fbloc3	dw	clit
	db	dosbuf
	dw	clit
	db	128
	dw	fid,at
	dw	writf
	dw	zbran,fbloc4
	dw	onep
	dw	pleav,fbloc3-cw
fbloc4	dw	xloop,fbloc3
fbloc5	dw	pabq
	dcs	'can''t resize file'
	dw	exit

;	CLOSE  ( -- )		file? if flush fid @ close-file drop
;				fd off then empty-buffers
;
; NOTE: errors are NOT reported with this function

	hdr	1,'CLOSE',,1	; close current file
close:	call	docol
	dw	fileq
	dw	zbran,close1
	dw	flush
	dw	fid,at
	dw	closf,drop
	dw	fd,off
close1	dw	mtbuf
	dw	exit

;	CLOSE-ALL  ( -- )	close (fdtab) nfd 0 do dup sfp ! close
;				cell+ loop drop

	hdr	1,'CLOSE-ALL',,1
closa:	call	docol
	dw	close		; ensure buffer flushed
	dw	lit,fdtab
	dw	clit
	db	nfd
	dw	zero
	dw	xdo,closa2
closa1	dw	dupp
	dw	sfp,store
	dw	close
	dw	cellp
	dw	xloop,closa1
closa2	dw	drop
	dw	exit

;	lastfile  ( -- c-addr u )	zbuf 2+ @ zcount

	hdr	x,'LASTFILE',,1
lastf:	call	docol		; last named file used by open-file etc
	dw	zbuf
	dw	twop,at
	dw	zcnt
	dw	exit

;	.lastfile  ( -- )	beep cr lastfile type space

	hdr	x,'.LASTFILE',,1
dotlf:	call	docol
	dw	beep,crr
	dw	lastf,typee
	dw	space
	dw	exit

;	?create  ( c-addr u -- fileid )
;				r/o open-file 0= tuck if close-file then
;				drop if .lastfile ." exists - delete it? "
;				y/n 0= if abort then then lastfile r/w
;				create-file abort" can't create file"

	hdr	x,'?CREATE',,1
qcreat:	call	docol
	dw	rso,openf	; test if file exists
	dw	zequ,tuck
	dw	zbran,qcreat1
	dw	closf
qcreat1	dw	drop
	dw	zbran,qcreat2
	dw	dotlf
	dw	pdotq
	dcs	'exists - delete it? '
	dw	yn,zequ
	dw	zbran,qcreat2
	dw	abort
qcreat2	dw	lastf,rsw,creatf
	dw	pabq
	dcs	'can''t create file'
	dw	exit

;	init-scr  ( fileid ior -- )	if drop exit then fdb sfp ! fd on
;					dup fid ! file-size drop b/buf
;					um/mod nip blks ! lastfile fnb
;					place loadfile upper empty-buffers

	hdr	x,'INIT-SCR',,1
iniscr:	call	docol		; init screenfile
	dw	zbran,iniscr1
	dw	drop
	dw	exit
iniscr1	dw	fdb,sfp,store
	dw	fd,on
	dw	dupp,fid,store
	dw	fsiz,drop
	dw	bbuf,umslm,nip	; overflow stores $FFFF
	dw	blks,store
	dw	lastf,fnb,place
	dw	loadf,upper
	dw	mtbuf
	dw	exit

;	OPEN  ( c-addr u -- ior )	fdb drop s" scr" +ext r/w
;					open-file tuck init-scr

	hdr	1,'OPEN',,1	; open a screen file
open:	call	docol
	dw	fdb,drop	; free slot?
	dw	psqot
	dcs	'scr'
	dw	pext
	dw	rsw,openf
	dw	tuck
	dw	iniscr
	dw	exit

;	(open)  ( c-addr u -- )		open abort" can't open file"

	hdr	x,'(OPEN)',,1
popen:	call	docol
	dw	open
	dw	pabq
	dcs	'can''t open file'
	dw	exit

;	GETFILENAME  ( -- c-addr u )	>in @ char dup rot >in ! [char] "
;					- if drop bl then word count dup
;					0= abort" specify filename"

;	GETFILENAME  ( -- c-addr u )	token dup 0= abort" specify filename"

	hdr	1,'GETFILENAME',,1
getfn:	call	docol
	dw	token
	dw	dupp,zequ
	dw	pabq
	dcs	'specify filename'
	dw	exit

;	USING  ( "filename[.SCR]" -- )	close getfilename open ?dup if
;					.lastfile -507 = if ." access denied"
;					0 else ." not found - create it? "
;					y/n then 0= if abort then lastfile
;					?create 0 init-scr then 0 0 scr 2!

	hdr	1,'USING',,1	; open/make a screen file
using:	call	docol
	dw	close
	dw	getfn,open
	dw	qdup
	dw	zbran,using4
	dw	dotlf
	dw	lit,-507
	dw	equal
	dw	zbran,using1
	dw	pdotq
	dcs	'access denied'
	dw	zero
	dw	bran,using2
using1	dw	pdotq
	dcs	'not found - create it? '
	dw	yn
using2	dw	zequ
	dw	zbran,using3
	dw	abort
using3	dw	lastf,qcreat
	dw	zero,iniscr
using4	dw	zero,zero	; reset SCR
	dw	scr,tstor
	dw	exit

;	LOADED  ( +n1 +n2 c-addr u -- )	sfp @ >r (open) (thru) close r>
;					sfp ! ?block

	hdr	1,'LOADED',,1
loaded:	call	docol
	dw	sfp,at
	dw	tor
	dw	popen
	dw	pthru
	dw	close
	dw	fromr
	dw	sfp,store
	dw	qblock
	dw	exit

;	FLOAD  ( +n "filename[.SCR]" -- )  dup getfilename loaded

	hdr	1,'FLOAD',,1
fload:	call	docol
	dw	dupp
	dw	getfn
	dw	loaded
	dw	exit

	cseg

hstart	dw	?		; segment offset of heads in image

	aseg

exehdr	db	'MZ'		; 0  EXE id
	dw	?		; 2  file size (mod 512)
	dw	?		; 4  file size (512 byte blocks)
	dw	0		; 6  # relocation items
	dw	2		; 8  exe header size (paragraphs)
	dw	0		; A  minimum paragraphs needed
	dw	0FFFFh		; C  maximum paragraphs needed
	dw	0FFF0h		; E  stack segment
	dw	tmpstk		;10  stack offset
	dw	0		;12  checksum (ignored by DOS)
	dw	start		;14  start address
	dw	0FFF0h		;16  code segment
	dw	1Ch		;18  offset 1st relocation
	dw	0		;1A  overlay #  0=resident code
	dw	0		;1C  null relocation item
	dw	0		;1E  	"	"

;	SAVE  ( "filename[.EXE]" -- )
;				0 0 over swap boot 2! freeze getfilename
;				s" exe" +ext ?create >r (cold9) (zb1)
;				(cold10-cold9) cmove (exehdr) (100h-20h) $20
;				cmove 0= >r 0 dph @ r@ and limit dp 2@ >r
;				over - r@ + $0F + $FFF0 and r@ - r> over + 4
;				rshift (hstart) ! r@ and (100h-20h) dp @ over
;				- dup 3 pick + 0 6 pick m+ 512 um/mod over
;				0<> - swap (100h-20h+2) 2! r> -rot r@
;				write-file ?dup 0= if if r@ write-file ?dup
;				0= if r@ hwrite else 2drop drop then then
;				then r> close-file or abort" can't save file"

	hdr	1,'SAVE',,1
save:	call	docol
	dw	zero,zero
save1	dw	over,swap
	dw	boot,tstor
	dw	freez
	dw	getfn
	dw	psqot
	dcs	'exe'
	dw	pext
	dw	qcreat
	dw	tor		; fid
	dw	lit,cold9	; insert compiler logo
	dw	lit,zb1
	dw	clit
	db	cold10-cold9
	dw	cmove
	dw	lit,exehdr	; position header
	dw	lit,100h-20h
	dw	clit
	db	20h
	dw	cmove
	dw	zequ,tor	; system flag
	dw	zero
	dw	dph,at
	dw	rat,andd
	dw	limit
	dw	dpp,tat
	dw	tor
	dw	over,subb
	dw	rat,plus
	dw	clit
	db	0fh
	dw	plus
	dw	lit,0fff0h
	dw	andd
	dw	rat,subb
	dw	fromr
	dw	over,plus
	dw	clit
	db	4
	dw	rsh
	dw	lit,hstart
	dw	store
	dw	rat,andd
	dw	clit
	db	100h-20h
	dw	dpp,at
	dw	over,subb
	dw	dupp
	dw	three,pick
	dw	plus
	dw	zero
	dw	clit
	db	6
	dw	pick
	dw	mplus
	dw	lit,512
	dw	umslm
	dw	over,zneq
	dw	subb
	dw	swap
	dw	lit,100h-20h+2
	dw	tstor
	dw	fromr
	dw	drot
	dw	rat,writf	; save application
	dw	qdup,zequ
	dw	zbran,save3	; error
	dw	zbran,save2	; if sys
	dw	rat,writf	; save system
	dw	qdup,zequ
	dw	zbran,save3	; error
	dw	rat,hwrite	; save heads
	dw	bran,save3
save2	dw	tdrop,drop
save3	dw	fromr,closf
	dw	orr
	dw	pabq
	dcs	'can''t save file'
	dw	exit

;	TURNKEY  ( "bootword" "filename[.EXE]" -- )

	hdr	1,'TURNKEY',,1
turnk:	call	docol
	dw	true
turnk1	dw	tick
	dw	bran,save1

;	TURNKEY-SYSTEM  ( "bootword" "filename[.EXE]" -- )

	hdr	1,'TURNKEY-SYSTEM',,1
turnks:	call	docol
	dw	zero
	dw	bran,turnk1

;	CHAR+  ( c-addr1 -- c-addr2 )	aka 1+ char+

	hdr	1,'CHAR+',,,onep
charp	equ	onep

;	CHARS  ( n1 -- n2 )		aka noop chars immediate

	hdr	1,'CHARS',1,,noop
chars	equ	next

;	CELL+  ( addr1 -- addr2 )	aka 2+ cell+

	hdr	1,'CELL+',,,twop
cellp	equ	twop

;	CELL-  ( addr1 -- addr2 )	aka 2- cell-

	hdr	1,'CELL-',,,twom
cellm	equ	twom

;	CELLS  ( n1 -- n2 )		aka 2* cells

	hdr	1,'CELLS',,,tstar
cells	equ	tstar

;	ALIGN  ( -- )			aka noop align immediate

	hdr	1,'ALIGN',1,,noop
alignn	equ	next

;	ALIGNED  ( addr -- a-addr )	aka noop aligned immediate

	hdr	1,'ALIGNED',1,,noop
alignd	equ	next

;	ENVIRONMENT			vocabulary environment

	hdr	1,'ENVIRONMENT',,1
envir:	call	dovoc
envir1	dw	0		; nfa of top word in vocabulary
envir2	dw	forth2		; link to previous vocabulary
	dw	lastl		; nfa pointer

;	ENVIRONMENT?  ( c-addr u -- false | i*x true )
;				(envir1) search-wordlist if execute true
;				else false then

	hdr	1,'ENVIRONMENT?',,1
envq:	call	docol
	dw	lit,envir1
	dw	swlis
	dw	zbran,envq1
	dw	exec
	dw	true
	dw	bran,envq2
envq1	dw	false
envq2	dw	exit

	 if	float
;
;       Floating Point Functions
;
; -FP  FLOAT+  FLOATS  FALIGN  FALIGNED  F,  FLITERAL  FCONSTANT
; FVARIABLE  FDEPTH  FDROP  FDUP  FSWAP  FOVER  FROT  F@  F!  FABS
; FNEGATE  F+  F-  F*  F/  FMOD  D>F  FLOOR  FROUND  FTRUNC  F>D
; F0=  F0<  F0>  F<  F>  FMIN  FMAX  REPRESENT  >FLOAT  PRECISION
; SET-PRECISION  (FS.)  FS.R  FS.  (FE.)  FE.R  FE.  (F.)  F.R  F.
; (G.)  G.R  G.  FSQRT  FEXP  FLN  F**  FSIN  FATAN  PI  FRANDOM
; fpinit  fident  fnumber
;

	cseg
cdp	=	$
	aseg
cdps	=	$
heads	segment	public
cdph	=	$-horig
heads	ends

;	-FP  ( -- )		marker -FP

	hdr	1,'-FP',,1
dfp:	call	domark
	db	14
	dw	2
	dw	forth1
	dw	forth1
	dw	forth1
	dw	cdp
	dw	cdps
	dw	cdph

;	FLOAT+ ( f-addr1 -- f-addr2 )	4 +

	hdr	1,'FLOAT+'
floatp:	pop	ax
	add	ax,4
	jmp	apush

;	FLOATS ( n1 -- n2 )		4 *

	hdr	1,'FLOATS'
floats:	pop	ax
	shl	ax,1
	shl	ax,1
	jmp	apush

;	FALIGN  ( -- )			aka noop falign immediate

	hdr	1,'FALIGN',1,,noop
falign	equ	next

;	FALIGNED ( addr -- f-addr )	aka noop faligned immediate

	hdr	1,'FALIGNED',1,,noop
falignd	equ	next

	 if	fstack

	cseg

;	pop fp-stack to CX,DX

fpop:	mov	bx,fspp
	mov	cx,[bx]
	mov	dx,[bx+2]
	add	word ptr fspp,4
	ret

;	push CX,DX to fp-stack

fpush:	sub	word ptr fspp,4
	mov	bx,fspp
	mov	[bx],cx
	mov	[bx+2],dx
	ret

;	FLITERAL runtime

flit:	lodsw
	mov	cx,ax
	lodsw
	mov	dx,ax
	call	fpush
	nextt

;	FCONSTANT runtime

dofcon:	pop	bx
	mov	cx,[bx]
	mov	dx,[bx+2]
	call	fpush
	nextt

	 else

flit	equ	tlit
dofcon	equ	tat

	 endif	;fstack

;	F,  (F: r -- ) or ( r -- )

	hdr	1,'F,',,1
fcomm:	call	docol
	dw	here
	dw	clit
	db	4
	dw	allot
	dw	fstor
	dw	exit

;	FLITERAL  (F: -- r ) or ( -- r )	postpone flit f, ;immediate

	hdr	1,'FLITERAL',1,1
flite:	call	docol
	dw	comp,flit
	dw	fcomm
	dw	exit

;	FCONSTANT  (F: -- r ) or ( -- r )

	hdr	1,'FCONSTANT',,1
fcon:	call	docol
	dw	lit,dofcon
	dw	build
	dw	fcomm
	dw	exit

;	FVARIABLE  ( -- f-addr )	aka 2variable fvariable

	hdr	1,'FVARIABLE',,,tvar
fvar	equ	tvar

;	FDEPTH   ( -- +n )	fs0 @ fsp @ - 2/ 2/

	hdr	1,'FDEPTH'
fdepth:	call	docol
	 if	fstack
	dw	fszero,at
	dw	fsp,at
	dw	subb
	dw	twodiv
	 else
	dw	depth
	 endif
	dw	twodiv
	dw	exit

;	FDROP  (F: r -- ) or ( r -- )

	 if	fstack
	hdr	1,'FDROP'
fdrop:	add	word ptr fspp,4
	nextt
	 else
	hdr	1,'FDROP',,,tdrop	; aka 2drop fdrop
fdrop	equ	tdrop
	 endif

;	FDUP  (F: r -- r r ) or ( r -- r r )

	 if	fstack
	hdr	1,'FDUP'
fdup:	xchg	fspp,sp
	mov	bx,sp
	push	[bx+2]
	push	[bx]
	xchg	fspp,sp
	nextt
	 else
	hdr	1,'FDUP',,,tdup		; aka 2dup fdup
fdup	equ	tdup
	 endif

;	FSWAP  (F: r1 r2 -- r2 r1 ) or ( r1 r2 -- r2 r1 )

	 if	fstack
	hdr	1,'FSWAP'
fswap:	mov	bx,fspp
	mov	ax,[bx]
	xchg	ax,[bx+4]
	mov	[bx],ax
	mov	ax,[bx+2]
	xchg	ax,[bx+6]
	mov	[bx+2],ax
	nextt
	 else
	hdr	1,'FSWAP',,,tswap	; aka 2swap fswap
fswap	equ	tswap
	 endif

;	FOVER  (F: r1 r2 -- r1 r2 r1 ) or ( r1 r2 -- r1 r2 r1 )

	 if	fstack
	hdr	1,'FOVER'
fover:	xchg	fspp,sp
	mov	bx,sp
	push	[bx+6]
	push	[bx+4]
	xchg	fspp,sp
	nextt
	 else
	hdr	1,'FOVER',,,tover	; aka 2over fover
fover	equ	tover
	 endif

;	FROT  (F: r1 r2 r3 -- r2 r3 r1 ) or ( r1 r2 r3 -- r2 r3 r1 )

	 if	fstack
	hdr	1,'FROT'
frot:	mov	bx,fspp
	mov	ax,[bx]
	xchg	ax,[bx+4]
	xchg	ax,[bx+8]
	mov	[bx],ax
	mov	ax,[bx+2]
	xchg	ax,[bx+6]
	xchg	ax,[bx+10]
	mov	[bx+2],ax
	nextt
	 else
	hdr	1,'FROT',,,trot		; aka 2rot frot
frot	equ	trot
	 endif

;	F@  ( f-addr -- ) (F: -- r ) or ( f-addr -- r )

	 if	fstack
	hdr	1,'F@'
fat:	pop	bx
	mov	cx,[bx]
	mov	dx,[bx+2]
	call	fpush
	nextt
	 else
	hdr	1,'F@',,,tat		; aka 2@ f@
fat	equ	tat
	 endif

;	F!  ( f-addr -- ) (F: r -- ) or ( r f-addr -- )

	 if	fstack
	hdr	1,'F!'
fstor:	call	fpop
	pop	bx
	mov	[bx],cx
	mov	[bx+2],dx
	nextt
	 else
	hdr	1,'F!',,,tstor		; aka 2! f!
fstor	equ	tstor
	 endif

	cseg

; floating point accumulator

acce	db	5 dup (?)	; exponent
accs	=	acce+1		; sign
acc1	=	accs+1		; 1st fraction (msb)
acc2	=	acc1+1		; 2nd fraction
acc3	=	acc2+1		; 3rd fraction

sf	db	?		; subtraction flag

f1	dd	?		; temp float storage
f2	dd	?		;
f3	dd	?		;

; save/load temp fp registers

savf1:	mov	bx,offset f1	; save regs to f1
	jmp	short stom

savf2:	mov	bx,offset f2	; save regs to f2
	jmp	short stom

lodf1:	mov	bx,offset f1	; load accum/regs from f1
	jmp	short lod

lodf2:	mov	bx,offset f2	; load accum/regs from f2
	jmp	short lod

; pop float from stack to accum

ldop:
	 if	fstack
	call	fpop
	mov	bx,offset f1
	mov	[bx],cx
	mov	[bx+2],dx
	 else
	pop	dx
	pop	word ptr f1
	pop	word ptr f1+2
	push	dx
	mov	bx,offset f1
	 endif
	jmp	short lod

; pop 2 float from stack to bx (f2) and accum

ld2op:
	 if	fstack
	call	fpop
	mov	bx,offset f2
	push	bx
	mov	[bx],cx
	mov	[bx+2],dx
	call	ldop
	pop	bx
	 else
	pop	di
	pop	word ptr f2
	pop	word ptr f2+2
	call	ldop
	push	di
	mov	bx,offset f2
	 endif
	ret

; push float registers to stack and exit

svop:	mov	dl,cl
	mov	cl,al
	 if	fstack
	call	fpush
	 else
	push	dx
	push	cx
	 endif
	nextt

; overflow - set regs to maximum, set cy

ovf:	mov	cx,7fffh
	mov	al,cl
	mov	dh,cl
	stc
	ret

; zero - set accum and regs to zero

zro:	sub	ax,ax
	mov	acce,al
	mov	cx,ax
	mov	dh,al
	ret

; load float [bx] to accum and regs, set flags
; entry - bx=adr
; exit	- cx:dh (packed), al=exp, flags set

lod:	mov	dl,[bx]
	and	dl,dl
	jnz	lod1
	jmp	short zro

lod1:	mov	ch,[bx+1]
	mov	cl,[bx+2]
	mov	dh,[bx+3]
	mov	al,ch
	or	ch,80h
	xor	al,ch
	call	storr
	xor	al,ch
	jmp	short tst1

; store regs to accum  dl=exp

storr:	mov	bx,offset acce
	mov	[bx],dl
	inc	bx

; store regs to mem
; entry - bx=adr al=exp cx:dh (packed)
; exit	- none

stom:	mov	[bx],al
stom1:	mov	[bx+1],ch
	mov	[bx+2],cl
	mov	[bx+3],dh
	ret

; change sign of accumulator and again
; when calling routine completes

chss:	call	chs
	pop	bx
	call	bx

; change sign of accumulator
; entry - none
; exit	- cx:dh (packed) al=exp flags set

chs:	xor	byte ptr accs,80h

; load regs from acc and test

lodr:	mov	bx,offset acce
	mov	dl,[bx]		; exp
	or	dl,dl
	jz	zro
	mov	al,[bx+1]	; accs
	xor	al,[bx+2]	; msb sign packed
	mov	cl,[bx+3]
	mov	dh,[bx+4]

; entry - al:cl:dh (packed) dl=exp
; exit	- cx:dh (packed) al=exp flags set

tst1:	mov	ch,al
tst2:	or	al,1		; test sign, clear Z C flags
	mov	al,dl
	ret

; entry - al=exp
; exit  - dl=exp  Z=zero S=negative

tstr:	mov	dl,al
	or	al,al
	jnz	tstr1
	ret

tstr1:	mov	al,ch
	jmp	tst2

; normalise and pack cx:dx

npack:	or	ch,ch
	js	pack
	call	norm
	js	pack
	jmp	zro		; underflow or zero

; pack cx:dx

pack:	call	rondr		; round cx:dx
	jnc	tst1
	jmp	ovf

; compare regs with mem [bx], return S if regs < mem, Z if match
; bx preserved

fcmp:	cmp	byte ptr [bx],0
	jz	tstr		; mem=0  test regs sign

	or	al,al
	mov	dl,al
	mov	al,[bx+1]
	not	al
	jz	tst2		; regs=0 test mem sign

	xor	al,ch
	jns	tstr1		; signs differ

	cmp	dl,[bx]
	jnz	fcmp1
	cmp	ch,[bx+1]
	jnz	fcmp1
	cmp	cl,[bx+2]
	jnz	fcmp1
	cmp	dh,[bx+3]
	jz	fcmp2		; regs = mem
fcmp1:	rcr	al,1		; carry to sign
	xor	al,ch		; complement sign for neg values
fcmp2:	mov	al,dl
	ret

;	FABS  (F: r1 -- r2 ) or ( r1 -- r2 )

	hdr	1,'FABS'
fabss:
	 if	fstack
	mov	bx,fspp
	 else
	mov	bx,sp
	 endif
	and	byte ptr [bx+1],7fh
	nextt

;	FNEGATE  (F: r1 -- r2 ) or ( r1 -- r2 )

	hdr	1,'FNEGATE'
fneg:
	 if	fstack
	mov	bx,fspp
	 else
	mov	bx,sp
	 endif
	xor	byte ptr [bx+1],80h
	nextt

	cseg

; right shift n bits
; entry - cx:dh al=count
; exit	- cx:dx

shrr:	sub	dl,dl
shrr1:	or	al,al		; test for zero
	jz	shrr2
	shr	cx,1
	rcr	dx,1
	dec	al
	jmp	shrr1

shrr2:	ret

; Complement cx:dx adjust accs, return sign flag

fcpl:	xor	byte ptr accs,80h ; change accum sign
	neg	cx		; complement fraction
	neg	dx
	sbb	cx,0
	ret

; Normalize cx:dx adjust acce
; entry - cx:dx
; exit	- cx:dx z=cx:dx=0 or acce=0 sign=underflow

norm:	mov	bl,32		; max shift
norm1:	or	ch,ch
	jnz	norm3
	xchg	ch,cl
	xchg	cl,dh
	xchg	dh,dl
	sub	bl,8
	jnz	norm1
	ret			; cx:dx = zero

norm2:	dec	bl		; shl until bit 31 set
	shl	dx,1
	rcl	cx,1
	or	ch,ch
norm3:	jns	norm2
	mov	al,bl		; adjust accum exp
	sub	al,32
	mov	bx,offset acce
	add	al,[bx]
	mov	[bx],al
	jz	norm4
	rcr	al,1		; carry to sign
	and	al,al		; sign = underflow
norm4:	ret

; Round the cx:dx registers, save to acc
; entry - cx:dx
; exit	- cx:dh al=packed msb dl=exp cy=ovf

rondr:	and	dl,dl		; test bit 7 and clear cy
	mov	bx,offset acce	; exp
	mov	dl,[bx]
	jns	rondr1
	inc	dh		; round up cx:dh dl=exp
	jnz	rondr1
	inc	cx
	jnz	rondr1
	mov	ch,80h		; new 1st fraction
	add	dl,1		; inc exp adjust cy
	mov	acce,dl		; new acc exp
rondr1:	jc	rondr2		; overflow
	mov	al,ch
	inc	bx		; accs
	xor	al,[bx]		; a=packed msb
	jmp	stom1		; save cx:dh to acc

rondr2:	ret

; fsu	floating point subtract subroutine

fsu:	mov	ch,80h		; mask to change operand sign
	ignore2

; fad	floating point add subroutine

fad:	mov	ch,0
	mov	dl,[bx]		; load operand
	xor	ch,[bx+1]
	mov	cl,[bx+2]
	mov	dh,[bx+3]
	and	dl,dl
	jz	fad2		; operand zero

	mov	al,ch		; unpack
	or	ch,80h
	xor	al,ch		; generate subtraction flag

	mov	bx,offset accs
	xor	al,[bx]
	mov	sf,al

; determine relative magnitudes of operand and accum

	dec	bx
	mov	al,[bx]		; acce
	or	al,al
	jz	fad8		; accum zero

	sub	al,dl		; get difference of exponents
	jc	fad3		; accum smaller

; check insignificant operand

	js	fad2

	cmp	al,25		; compare shift count to 25
	jc	fad4

fad2:	jmp	lodr

; check insignificant accum

fad3:	jns	fad8

	cmp	al,0-25		; compare shift count to -25
	jc	fad8		; move operand to accum

	mov	[bx],dl		; set acce
	neg	al		; complement shift count
	mov	dl,sf
	xor	[bx+1],dl	; set accs
	xchg	ch,[bx+2]	; exchange fraction
	xchg	cl,[bx+3]
	xchg	dh,[bx+4]

; position the operand, check if add or subtract

fad4:	call	shrr
	mov	bx,offset acc3
	mov	al,sf
	or	al,al
	js	fad6

	add	dh,[bx]		; add
	adc	cl,[bx-1]
	adc	ch,[bx-2]
	jnc	fad5

	rcr	cx,1		; rshift fraction
	rcr	dx,1
	add	byte ptr acce,1	; adjust exponent
	jnc	fad5
	jmp	ovf		; overflow

fad5:	jmp	pack

fad6:	neg	dl		; subtract
	mov	al,[bx]
	sbb	al,dh
	mov	dh,al
	mov	al,[bx-1]
	sbb	al,cl
	mov	cl,al
	mov	al,[bx-2]
	sbb	al,ch
	mov	ch,al
	jnc	fad7
	call	fcpl		; complement
fad7:	jmp	npack

; move operand to accumulator

fad8:	mov	al,sf
	mov	bx,offset accs
	xor	al,[bx]
	call	storr
	xor	al,ch
	jmp	tst1

;	F+  (F: r1 r2 -- r3 ) or ( r1 r2 -- r3 )

	hdr	1,'F+'
faddd:	call	ld2op
	call	fad
	jmp	svop

;	F-  (F: r1 r2 -- r3 ) or ( r1 r2 -- r3 )

	hdr	1,'F-'
fsubb:	call	ld2op
	call	fsu
	jmp	svop

	cseg

; read the operand at (bx), check the accum exponent

mdex:	mov	ch,al
	mov	cl,[bx+1]
	mov	dh,[bx+2]
	mov	dl,[bx+3]

	mov	bx,offset acce	; accum exp
	mov	al,[bx]
	or	al,al
	jz	mdex2		; is zero

	add	al,ch		; result exp plus bias
	mov	ch,al
	rcr	al,1		; carry to sign
	xor	al,ch		; carry and sign must differ
	mov	al,ch		; result exp plus bias
	mov	ch,80h		; exp bias, sign mask, most sig bit
	jns	mdex1		; if over or underflow

	sub	al,ch		; remove excess exp bias
	jz	mdex2		; return if underflow

	mov	[bx],al		; result exp
	inc	bx		; address accum sign
	xor	[bx],cl		; result sign in sign bit
	and	[bx],ch		; result sign

	mov	al,cl		; operand sign and 1st fraction
	or	al,ch		; operand first fraction
	ret

mdex1:	rol	al,1		; set carry bit if overflow
	jc	mdex2
	sub	al,al		; clear register
mdex2:	ret

; fixed point multiply subroutine  al:dx * acc -> cx:dh

mulx:	mov	di,dx		; 3rd 2nd multiplicand

; multiply  by each accumulator fraction in turn

	sub	ah,ah		; clear 6th product
	sub	dx,dx		; clear 4th 5th product
	mov	bx,offset acc3	; multiply by accum 3rd fraction
	call	mulx2
	mov	bx,offset acc2	; multiply by accum 2nd fraction
	call	mulx1
	mov	bx,offset acc1

; multiply by one accumulator byte

mulx1:	mov	ah,dh		; 5th partial product
	mov	dx,cx		; 3rd 4th partial prod
mulx2:	mov	ch,[bx]		; multiplier
	sub	cl,cl		; 2nd partial prod
	cmp	cl,ch		; set carry bit for exit flag
	jc	mulx4		; if multiplier is zero
	mov	cl,dh		; 2nd partial product
	mov	dh,dl		; 3rd partial prod
mulx3:	ret

; loop for each bit of multiplier byte

mulx4:	adc	ah,ah		; shift exit flag out if done
	jz	mulx3		; exit if multiplication done
	rcl	dx,1		; 4th 3rd partial prod
	rcl	cx,1		; 2nd 1st partial prod
	jnc	mulx4		; if addition required

; add the multiplicand to the product if the multiplier bit is one

	add	dx,di		; 4th 3rd partial prod
	adc	cl,al		; 2nd partial prod
	adc	ch,0		; add carry to 1st prod
	clc
	jmp	mulx4

; fmu	floating point multiplication subroutine

fmu:	mov	al,[bx]		; operand exponent
	or	al,al
	push	bx
	jz	fmu1
	call	mdex		; read operand
fmu1:	pop	bx
	jz	fmu3		; zero or underflow
	jc	fmu4		; overflow
	call	mulx		; fixed mult
	or	ch,ch		; normalize if necessary
	js	fmu2
	dec	byte ptr acce	; dec accum exp
	jz	fmu3		; underflow
	shl	dx,1
	rcl	cx,1
fmu2:	jmp	pack

fmu3:	jmp	zro		; zero or underflow
fmu4:	jmp	ovf		; overflow

;	F*  (F: r1 r2 -- r3 ) or ( r1 r2 -- r3 )

	hdr	1,'F*'
fstar:	call	ld2op
	call	fmu
	jmp	svop

	cseg

; fixed point divide
; entry - al:dx
; exit  - cx:dx  nc=overflow

; subtract divisor from accum to obtain 1st remainder

divx:	mov	bx,offset acc1
	sub	[bx+2],dl	; acc 3rd fraction
	sbb	[bx+1],dh	; acc 2nd fraction
	sbb	[bx],al		; acc 1st fraction

; halve divisor and store for addition or subtraction  cl:dx:ch

	sub	ah,ah		; init quot 1st fraction
	sar	al,1		; divisor 1st fraction
	rcr	dx,1		; divisor 2nd 3rd fraction
	rcr	ah,1		; divisor 4th fraction is zero

	mov	di,dx

; load 1st remainder

	mov	dl,[bx]		; 1st fraction
	mov	bx,[bx+1]	; 2nd 3rd fraction
	xchg	bh,bl

; position remainder, initialise quotient, check sign

	sub	cx,cx		; init quot 2nd fraction
	sub	dh,dh		; init quot 3rd fraction
	or	dl,dl		; test sign, clear cy
	js	divx5		; remainder negative
	inc	byte ptr acce	; inc quotient exponent
	jnz	divx1
	ret			; overflow

divx1:	inc	dh		; init quot 3rd fraction
				; sub divisor if remainder positive
divx2:	neg	ah		; 4th fraction is zero
	neg	ah
	sbb	bx,di		; 2nd 3rd fraction
	sbb	dl,al		; 1st fraction

divx3:	rol	ch,1		; shift remainder left one bit
	ror	ch,1
	jnc	divx4
	ret			; division complete

divx4:	rol	ah,1		; shift remainder 4th fraction to carry
	ror	ah,1
	rcl	bx,1		; shift cx:dx:bx
	rcl	dx,1
	rcl	cx,1

				; branch if subtraction is required
	ror	dh,1		; quotient 3rd fraction
	rol	dh,1		; remainder sign to carry bit
	jc	divx2		; to sub divisor if remainder positive
				; add divisor if remainder negative
divx5:	add	bx,di		; 2nd 3rd fraction
	adc	dl,al		; 1st fraction
	jmp	divx3

; fdi	floating point division subroutine

fdi:	sub	al,al
	sub	al,[bx]		; complement of divisor exponent
	cmp	al,1		; set carry if division by zero
	push	bx
	jc	fdi1
	call	mdex		; read operand if not zero
fdi1:	pop	bx
	jc	fdi2
	jz	fdi3
	call	divx		; fixed division
	jnc	fdi2
	jmp	pack

fdi2:	jmp	ovf		; overflow or division by zero
fdi3:	jmp	zro		; underflow or zero

;	F/  (F: r1 r2 -- r3 ) or ( r1 r2 -- r3 )

	hdr	1,'F/'
fslas:	call	ld2op
	call	fdi
	jmp	svop

	 if	0

;	FMOD  (F: r1 r2 -- r3 ) or ( r1 r2 -- r3 )

	hdr	1,'FMOD'
fmod:	call	ld2op
	push	bx
	call	fdi
	call	fix
	call	flt
	pop	bx
	call	fmu
	mov	bx,offset f1
	call	fsu
	call	chs
	jmp	svop

	 endif

	cseg

; convert signed integer AL to float

flta:	mov	ch,al
	sub	cl,cl
	sub	dx,dx
	mov	al,8
	ignore2

; convert 32 bit signed integer to float
; entry - cx:dx (int)

flt:	mov	al,32		; scaling factor
	xor	al,80h		; apply exponent bias
	mov	bx,offset acce
	mov	[bx],al
	mov	byte ptr [bx+1],80h ; assume positive
	or	ch,ch
	jns	flt2
	call	fcpl		; negate
flt2:	jmp	npack

;	D>F  ( d -- ) (F: -- r ) or ( d -- r )

	hdr	1,'D>F'
dtof:	pop	cx
	pop	dx
	call	flt
	jmp	svop

	cseg

; Round/floor/trunc accum to integer
; entry - al cx:dh
; exit	- al cx:dh dl=signed integer

flr:	mov	bl,0		; floor
flr0:	mov	dl,dh
	mov	ah,80h+24
	cmp	al,ah
	jnc	flr5		; no fraction
	mov	acce,ah
	mov	bh,ch		; save sign
	or	ch,80h		; unpack msb
	or	bl,bl
	jnz	flr2
	or	bh,bh
	jns	flr2
	sub	dh,1		; dec cx:dh
	sbb	cx,0
flr2:	neg	al
	add	al,ah
	call	shrr
	or	bl,bl
	jnz	flr3
	or	bh,bh
	jns	flr3
	add	dh,1		; inc cx:dh
	adc	cx,0
flr3:	dec	bl
	jnz	flr4
	add	dl,dl		; round
	adc	dh,0
	adc	cx,0
flr4:	push	dx
	sub	dl,dl
	call	npack		; normalise and pack
	pop	bx
	mov	dl,bh
flr5:	or	ch,ch
	jns	flr6
	neg	dl
flr6:	ret

;	FLOOR  (F: r1 -- r2 ) or ( r1 -- r2 )

	hdr	1,'FLOOR'
floor:	call	ldop
	call	flr
	jmp	svop

;	FROUND	(F: r1 -- r2 ) or ( r1 -- r2 )

	hdr	1,'FROUND'
frnd:	call	ldop
	mov	bl,1
	call	flr0
	jmp	svop

	 if	0

;	FTRUNC	(F: r1 -- r2 ) or ( r1 -- r2 )

	hdr	1,'FTRUNC'
ftrunc:	call	ldop
	mov	bl,2
	call	flr0
	jmp	svop

	 endif

	cseg

; fix	convert float in acc to 32 bit signed integer
; exit	- cx:dx (int)  cy=overflow

fix:	mov	dl,32		; scaling
	or	al,al
	jz	fix2		; zero
	xchg	dl,al
	add	al,80h-1	; add bias-1
	sub	al,dl		; shift count -1
	jc	fix1		; accum too large
	cmp	al,31		; compare to large shift
	jnc	fix2		; accum too small
	inc	al		; shift count
	or	ch,80h		; unpack msb
	call	shrr		; position the fraction
	test	byte ptr accs,80h
	js	fix1
	call	fcpl
fix1:	clc
	ret

fix2:	sub	cx,cx		; zero
	sub	dx,dx
	ret

;	F>D  (F: r -- ) ( -- d ) or ( r -- d )

	hdr	1,'F>D'
ftod:	call	ldop
	call	fix
	jnc	ftod1
	jmp	cverr		; overflow

ftod1:	push	dx
	push	cx
	nextt

;	F0=  (F: r -- ) ( -- flag ) or ( r -- flag )

	hdr	1,'F0='
fzeq:	call	ldop
	jnz	ffl
	jmp	true
ffl:	jmp	false

;	F0<  (F: r -- ) ( -- flag ) or ( r -- flag )

	hdr	1,'F0<'
fzle:	call	ldop
	jnl	ffl
	jmp	true

;	F0>  (F: r -- ) ( -- flag ) or ( r -- flag )

	hdr	1,'F0>'
fzgr:	call	ldop
	jng	ffl
	jmp	true

;	F<  (F: r1 r2 -- ) ( -- flag ) or ( r1 r2 -- flag )

	hdr	1,'F<'
fles:	call	ld2op
	call	fcmp
	jns	ffl
	jmp	true

;	F>  (F: r1 r2 -- ) ( -- flag ) or ( r1 r2 -- flag )

	hdr	1,'F>'
fgre:	call	ld2op
	call	fcmp
	jng	ffl
	jmp	true

;	FMIN  (F: r1 r2 -- r3 ) or ( r1 r2 -- r3 )

	hdr	1,'FMIN'
fmin:	call	ld2op
	call	fcmp
	js	fmin1
	call	lod		; r1 >= r2
fmin1:	jmp	svop

;	FMAX  (F: r1 r2 -- r3 ) or ( r1 r2 -- r3 )

	hdr	1,'FMAX'
fmax:	call	ld2op
	call	fcmp
	jns	fmax1
	call	lod		; r1 < r2
fmax1:	jmp	svop

	hdr	x,'10E.'
ften:	call	dofcon
ften1	db	84h,20h,0,0	; 10.0

	hdr	1,'MAX-PRECISION'
mprec:	call	docon		; max precision
	dw	maxsig

	hdr	x,'EXSN'
exsn:	call	dovar		; exponent, sign
	dw	2 dup (?)

;	REPRESENT  ( c-addr u -- exp sign flag ) (F: r -- ) or
;		   ( r c-addr u -- exp sign flag )
;				2dup max-precision max [char] 0 fill dup
;				0< if 2drop fdrop 0 0 else max-precision
;				min 2>r fdup f0< 0 exsn 2! fabs fdup f0= 0=
;				begin while fdup 1e f< 0= if 10e f/ 1 else
;				fdup 0.1e f< if 10e f* -1 else 0 then then
;				dup exsn +! repeat 1e r@ 0 ?do 10e f* loop
;				f* fround f>d 2dup <# #s #> dup r@ - exsn
;				+! 2r> rot min 1 max cmove then d0= if 1 0
;				else exsn 2@ swap then true

	hdr	1,'REPRESENT'
repr:	call	docol
	dw	tdup
	dw	mprec,max
	dw	clit
	db	'0'
	dw	fill
	dw	dupp,zless
	dw	zbran,repr1
	dw	tdrop,fdrop
	dw	zero,zero
	dw	bran,repr9
repr1	dw	mprec,min
	dw	ttor
	dw	fdup,fzle
	dw	zero,exsn,tstor
	dw	fabss
	dw	fdup,fzeq
	dw	zequ		; begin
repr2	dw	zbran,repr6
	dw	fdup		; while
	dw	flit
	db	81h,0,0,0
	dw	fles,zequ
	dw	zbran,repr3
	dw	ften,fslas
	dw	one
	dw	bran,repr5
repr3	dw	fdup
	dw	flit
	db	7dh,4ch,0cch,0cdh
	dw	fles
	dw	zbran,repr4
	dw	ften,fstar
	dw	true
	dw	bran,repr5
repr4	dw	zero
repr5	dw	dupp,exsn,pstor
	dw	bran,repr2	; repeat
repr6	dw	flit
	db	81h,0,0,0
	dw	rat,zero
	dw	xqdo,repr8
repr7	dw	ften,fstar
	dw	xloop,repr7
repr8	dw	fstar
	dw	frnd,ftod
	dw	tdup
	dw	bdigs
	dw	digs
	dw	edigs
	dw	dupp
	dw	rat,subb	; handle overflow
	dw	exsn,pstor
	dw	tfrom
	dw	rot,min
	dw	one,max
	dw	cmove
repr9	dw	dzequ
	dw	zbran,repr10
	dw	one,zero	; 0.0E fixup
	dw	bran,repr11
repr10	dw	exsn,tat
	dw	swap
repr11	dw	true
	dw	exit

	cseg

finstr	dw	?,?	; string addr, count
finsgn	db	?	; sign
finpt	dw	?	; decimal point flag
finexp	db	?	; decimal exponent
fincvt	db	?	; converted digits

; fin	convert character string to float
; entry - bx=adr, ax=len
; exit	- result in accum, cy=error

fin:	dec	bx		; init string adr, count
	inc	ax
	mov	finstr,bx
	mov	finstr+2,ax

	mov	finsgn,80h	; set sign positive
	sub	ax,ax
	mov	finpt,ax	; clear decimal point flag
	mov	finexp,al	; set decimal exponent = 0
	mov	fincvt,al	; zero converted digits
	mov	acce,al		; zero accum

	call	fin21		; get 1st char
	jz	fin7		; treat zero length as blanks

	cmp	al,' '
	jnz	fin2
fin1:	call	fin21		; treat all blanks as zero
	jz	fin7
	cmp	al,' '
	jz	fin1
	stc
	ret

fin2:	cmp	al,'+'		; check for sign
	jz	fin3
	cmp	al,'-'
	jnz	fin4
	mov	finsgn,0	; set negative flag
fin3:	call	fin21		; get char after sign
	jz	fin5		; none

fin4:	cmp	al,'.'		; check for decimal point
	jnz	fin8
	xor	finpt,-1	; 2nd decimal point?
	jnz	fin9
fin5:	stc			; error
	ret

fin6:	cmp	fincvt,0
	jz	fin5
fin7:	jmp	short fin16

; process char

fin8:	call	fin22		; convert char to digit
	jc	fin5		; bad

	inc	fincvt
	push	ax
	mov	bx,offset ften1	; mult old value by 10
	call	fmu
	call	savf1
	pop	ax
	call	flta		; convert digit to floating point
	mov	bx,offset f1	; add to old value
	call	fad

	mov	ax,finpt	; if decimal point
	add	finexp,al	; decrement exponent

; get next char

fin9:	mov	ch,0		; zero exponent
	call	fin21
	jz	fin6		; done

; check for exponent

	cmp	al,'+'
	jz	fin11
	cmp	al,'-'
	jz	fin11
	call	upc
	cmp	al,'E'
	jz	fin10
	cmp	al,'D'
	jnz	fin4

; process exponent

fin10:	call	fin21		; next char
	jz	fin6		; done

fin11:	mov	dl,al
	sub	dl,'-'		; test minus sign
	jz	fin12
	cmp	dl,'+'-'-'	; test plus sign
	jnz	fin13

fin12:	call	fin21		; got sign, get 1st digit

fin13:	mov	ch,0		; possible decimal exponent
;	jnz	fin14
;	jmp	fin5		; none - error
	jz	fin6		; none - assume zero exponent

fin14:	call	fin22
	jnc	fin15
	ret			; not digit

fin15:	mov	cl,10		; accumulate exponent
	xchg	cl,al
	mul	ch
	add	al,cl
	mov	ch,al

	call	fin21		; get next
	jnz	fin14
	and	dl,dl		; test exponent sign
	jnz	fin16
	neg	ch		; complement if neg

fin16:	mov	al,finsgn	; store accum sign
	mov	accs,al

; adjust exponent

fin17:	mov	bx,offset finexp
	add	ch,[bx]
	jnz	fin18
	jmp	lodr		; done

fin18:	mov	[bx],ch
	mov	bx,offset ften1
	jns	fin19
	call	fdi		; div by 10
	mov	ch,1
	jmp	fin17

fin19:	call	fmu		; mul by 10
	jnc	fin20
	ret			; overflow

fin20:	mov	ch,-1
	jmp	fin17

; get next char al  return z if end

fin21:	mov	bx,offset finstr
	inc	word ptr [bx]
	dec	word ptr [bx+2]
	mov	bx,[bx]
	mov	al,[bx]
	ret

; convert ascii char (a) to digit, return cy if not in range 0-9

fin22:	sub	al,'0'
	jc	fin23
	cmp	al,10
	cmc
fin23:	ret

;	>FLOAT	( c-addr u -- true | false ) (F: -- r ) or
;		( c-addr u -- r true | false )

	hdr	1,'>FLOAT'
tflt:	pop	ax
	pop	bx
	call	fin
	jc	tflt1
	mov	dl,cl
	mov	cl,al
	 if	fstack
	call	fpush
	 else
	push	dx
	push	cx
	 endif
	jmp	true

tflt1:	jmp	false

;	PRECISION  ( -- u )

	hdr	1,'PRECISION'
prec:	call	doval
	dw	?		; set by FPINIT

;	SET-PRECISION  ( u -- )		1 max max-precision min to precision

	hdr	1,'SET-PRECISION'
setpr:	call	docol
	dw	one,max
	dw	mprec,min
	dw	pto,prec
	dw	exit

	hdr	1,'FDP'
fdp:	call	dovar		; decimal point display
	dw	?,?		; set by FPINIT

	hdr	x,'FBUF'
fbuf:	call	dovar		; fp string buffer
	db	maxsig dup (?)

	hdr	x,'EX#'
exn:	call	doval		; exponent
	dw	?

	hdr	x,'SN#'
snn:	call	doval		; sign
	dw	?

	hdr	x,'EF#'
efn:	call	doval		; exponent factor
	dw	?

	hdr	x,'PL#'
pln:	call	doval		; places after decimal point
	dw	?

;	(f1)  ( F: r -- r ) ( -- exp )
;				fdup fbuf max-precision represent 2drop

	hdr	x,'(F1)'	; get exponent
pf1:	call	docol
	dw	fdup
	dw	fbuf,mprec
	dw	repr,tdrop	; never error
	dw	exit

;	(f2)  ( exp -- offset exp' )  s>d ef# fm/mod ef# *

	hdr	x,'(F2)'	; apply exponent factor
pf2:	call	docol
	dw	stod
	dw	efn,fmsmd
	dw	efn,star
	dw	exit

;	(f3)  ( F: r -- ) ( places -- c-addr u )
;                               dup to pl# 0< if precision else (f1) ef# 0>
;                               if 1- (f2) drop 1+ then pl# + max-precision
;                               min then fbuf swap represent drop to sn# to
;                               ex# fbuf max-precision -trailing <# ;

	hdr	x,'(F3)'	; float to ascii
pf3:	call	docol
	dw	dupp
	dw	pto,pln
	dw	zless
	dw	zbran,pf31
	dw	prec
	dw	bran,pf33
pf31	dw	pf1
	dw	efn,zgrea
	dw	zbran,pf32
	dw	onem
	dw	pf2,drop
	dw	onep
pf32	dw	pln,plus
	dw	mprec,min
pf33	dw	fbuf,swap
	dw	repr
	dw	drop		; never error
	dw	pto,snn
	dw	pto,exn
	dw	fbuf
	dw	mprec
	dw	dtrai
	dw	bdigs
	dw	exit

;	(f4)  ( exp -- )	pl# 0< >r dup abs s>d r@ 0= if # then #s
;				2drop dup sign 0< r> d0= if [char] + hold
;				then [char] E hold

	hdr	x,'(F4)'	; insert exponent
pf4:	call	docol
	dw	pln,zless
	dw	tor
	dw	dupp
	dw	abss,stod
	dw	rat,zequ
	dw	zbran,pf41
	dw	dig
pf41	dw	digs
	dw	tdrop
	dw	dupp,sign
	dw	zless
	dw	fromr
	dw	dzequ
	dw	zbran,pf42
	dw	clit
	db	'+'
	dw	hold
pf42	dw	clit
	db	'E'
	dw	hold
	dw	exit

;	(f5)  ( char -- )	hold fdp cell+ on

	hdr	x,'(F5)'	; insert digit and update flag
pf5:	call	docol
	dw	hold
	dw	fdp,twop
	dw	on
	dw	exit

;	(f6)  ( c-addr u -- )	0 max begin dup while 1- 2dup + c@ (f5)
;				repeat 2drop

	hdr	x,'(F6)'	; insert string
pf6:	call	docol
	dw	zero,max
pf61	dw	dupp
	dw	zbran,pf62
	dw	onem
	dw	tdup,plus
	dw	cat
	dw	pf5
	dw	bran,pf61
pf62	dw	tdrop
	dw	exit

;	(f7)  ( n -- )		0 max 0 ?do [char] 0 (f5) loop

	hdr	x,'(F7)'	; insert '0's
pf7:	call	docol
	dw	zero,max
	dw	zero
	dw	xqdo,pf72
pf71	dw	clit
	db	'0'
	dw	pf5
	dw	xloop,pf71
pf72	dw	exit

;	(f8)  ( -- )		sn# sign 0 0 #>

	hdr	x,'(F8)'	; insert sign
pf8:	call	docol
	dw	snn,sign
	dw	zero,zero
	dw	edigs
	dw	exit

;	(f9)  ( c-addr u1 -- c-addr u2 )
;				pl# 0< if begin dup while 1- 2dup
;				+ c@ [char] 0 - until 1+ then then

	hdr	x,'(F9)'	; trim trailing '0's
pf9:	call	docol
	dw	pln,zless
	dw	zbran,pf92
pf91	dw	dupp
	dw	zbran,pf92
	dw	onem,tdup
	dw	plus,cat
	dw	clit
	db	'0'
	dw	subb
	dw	zbran,pf91
	dw	onep
pf92	dw	exit

;	(fa)  ( u1 -- u1 u2 )	pl# 0< if dup else pl# then

	hdr	x,'(FA)'
pfaa:	call	docol
	dw	pln,zless
	dw	zbran,pfaa1
	dw	dupp
	dw	bran,pfaa2
pfaa1	dw	pln
pfaa2	dw	exit

;	(fb)  ( c-addr u n -- )  fdp cell+ off >r (f9) r@ + (fa) over -
;				(f7) (fa) min r@ - (f6) r> (fa) min (f7)
;				fdp 2@ or if [char] . hold then

	hdr	x,'(FB)'	; insert fraction n places right of dec. pt
pfbb:	call	docol
	dw	fdp,twop
	dw	off
	dw	tor
	dw	pf9
	dw	rat,plus
	dw	pfaa
	dw	over,subb
	dw	pf7
	dw	pfaa,min
	dw	rat,subb
	dw	pf6
	dw	fromr
	dw	pfaa,min
	dw	pf7
	dw	fdp,tat,orr
	dw	zbran,pfbb1
	dw	clit
	db	'.'
	dw	hold
pfbb1	dw	exit

;	(fc)  ( c-addr u n -- )
;				>r 2dup r@ min 2swap r> /string 0 (fb) (f6)

	hdr	x,'(FC)'	; split into int/frac and insert
pfcc:	call	docol
	dw	tor
	dw	tdup
	dw	rat,min
	dw	tswap
	dw	fromr,sstr
	dw	zero,pfbb
	dw	pf6
	dw	exit

;	(fd)  ( F: r -- ) ( n factor -- c-addr u )
;				to ef# (f3) ex# 1- (f2) (f4) 1+ (fc) (f8)

	hdr	x,'(FD)'	; exponent form
pfdd:	call	docol
	dw	pto,efn
	dw	pf3
	dw	exn,onem
	dw	pf2
	dw	pf4
	dw	onep,pfcc
	dw	pf8
	dw	exit

;	(FS.)  ( F: r -- ) ( n -- c-addr u )  1 (fd)

	hdr	1,'(FS.)'
pfsd:	mov	ax,1
	push	ax
	jmp	pfdd

;	FS.R  ( F: r -- ) ( n u -- )
;				>r (fs.) r> over - swap spaces type

	hdr	1,'FS.R'
fsdr:	call	docol
	dw	tor
	dw	pfsd
	dw	bran,ddotr1

;	FS.  ( F: r -- )	-1 0 fs.r space

	hdr	1,'FS.'
fsdot:	call	docol
	dw	true
	dw	zero,fsdr
	dw	space
	dw	exit

	 if	fpeng

;	(FE.)  ( F: r -- ) ( -- c-addr u )  3 (fd)

	hdr	1,'(FE.)'
pfse:	mov	ax,3
	push	ax
	jmp	pfdd

;	FE.R  ( F: r -- ) ( n u -- )
;				>r (fe.) r> over - swap spaces type

	hdr	1,'FE.R'
fedr:	call	docol
	dw	tor
	dw	pfse
	dw	bran,ddotr1

;	FE.  ( F: r -- )	-1 0 fe.r space

	hdr	1,'FE.'
fedot:	call	docol
	dw	true
	dw	zero,fedr
	dw	space
	dw	exit

	 endif

;	(F.)  ( F: r -- ) ( n -- c-addr u )
;				0 to ef# (f3) ex# dup max-precision > if
;				fbuf 0 0 (fb) max-precision - (f7) (f6)
;				else dup 0> if (fc) else abs (fb) 1 (f7)
;				then then (f8)

	hdr	1,'(F.)'
pfd:	call	docol
	dw	zero
	dw	pto,efn
	dw	pf3
	dw	exn,dupp
	dw	mprec,great
	dw	zbran,pfd1	; if
	dw	fbuf,zero
	dw	zero,pfbb
	dw	mprec,subb
	dw	pf7
	dw	pf6
	dw	bran,pfd3	; else
pfd1	dw	dupp,zgrea
	dw	zbran,pfd2
	dw	pfcc
	dw	bran,pfd3	; else
pfd2	dw	abss
	dw	pfbb
	dw	one,pf7
pfd3	dw	pf8		; then then
	dw	exit

;	F.R  ( F: r -- ) ( n u -- )
;				>r (f.) r> over - spaces type

	hdr	1,'F.R'
fdotr:	call	docol
	dw	tor
	dw	pfd
	dw	bran,ddotr1

;	F.  ( F: r -- )		-1 0 f.r space

	hdr	1,'F.'
fdot:	call	docol
	dw	true
	dw	zero,fdotr
	dw	space
	dw	exit

;	(G.)  ( F: r -- ) ( n -- c-addr u )
;				>r (f1) -3 7 within  r> swap if (f.) else
;				(fs.) then

	hdr	1,'(G.)'
pgd:	call	docol
	dw	tor
	dw	pf1
	dw	lit,-3
	dw	clit
	db	7
	dw	within
	dw	fromr,swap
	dw	zbran,pgd1	; if
	dw	pfd
	dw	bran,pgd2	; else
pgd1	dw	pfsd
pgd2	dw	exit		; then

;	G.R  ( F: r -- ) ( n u -- )
;				>r (g.) r> over - spaces type

	hdr	1,'G.R'
gdotr:	call	docol
	dw	tor,pgd
	dw	bran,ddotr1

;	G.  ( F: r -- )		-1 0 g.r space

	hdr	1,'G.'
gdot:	call	docol
	dw	true
	dw	zero,gdotr
	dw	space
	dw	exit

	cseg

;	sqr

sqr:	call	tstr
	jnz	sqr1
	ret			; zero

sqr1:	jns	sqr2
	jmp	ovf		; neg

sqr2:	call	savf1
	and	al,al
	rcr	al,1
	add	al,40h
	call	savf2
	mov	dh,5
sqr3:	push	dx
	call	lodf1
	mov	bx,offset f2
	call	fdi
	mov	bx,offset f2
	call	fad
	sub	al,1
	call	savf2
	pop	dx
	dec	dh
	jnz	sqr3
	mov	bx,offset f2
	jmp	lod

;	FSQRT  (F: r1 -- r2 ) or ( r1 -- r2 )

	hdr	1,'FSQRT'
fsqr:	call	ldop
	call	sqr
	jmp	svop

	cseg

poly:	push	bx
	call	savf1
	pop	bx
	mov	al,[bx]
	mov	poly3,al
	inc	bx
	push	bx
	call	lod
	jmp	short poly2

poly1:	push	bx
	mov	bx,offset f1
	call	fmu
	pop	bx
	push	bx
	call	fad
poly2:	pop	bx
	add	bx,4
	dec	byte ptr poly3
	jnz	poly1
	ret

poly3	db	?

polx:	push	bx
	call	savf2
	mov	bx,offset f2
	call	fmu
	pop	bx
	call	poly
	mov	bx,offset f2
	jmp	fmu

;	exp

exp:	mov	bx,offset ln2
	call	fdi
	cmp	al,88h
	jnc	exp3

	cmp	al,68h
	jnc	exp1
	mov	bx,offset fone
	jmp	lod

exp1:	call	savf2
	call	flr
	call	savf1
	mov	al,dl
	add	al,81h
	jz	exp2

	push	ax
	call	lodf2
	mov	bx,offset f1
	call	fsu
	mov	bx,offset exp4
	call	poly
	pop	ax
	mov	cx,0
	mov	dh,ch
	call	savf1
	mov	bx,offset f1
	jmp	fmu

exp2:	call	lodr
	jns	exp3
	jmp	zro

exp3:	jmp	ovf

exp4	db	7
	db	74h,59h,88h,7ch
	db	77h,26h,97h,0e0h
	db	7ah,1eh,1dh,0c4h
	db	7ch,63h,50h,5eh
	db	7eh,75h,0feh,1ah
ln2	db	80h,31h,72h,18h		; ln2
fone	db	81h,0,0,0		; 1.0

;	FEXP  (F: r1 -- r2 ) or ( r1 -- r2 )

	hdr	1,'FEXP'
fexp:	call	ldop
	call	exp
	jmp	svop

	cseg

;	log

log:	call	tstr
	jng	log1		; neg or zero
	xor	al,80h
	push	ax
	mov	al,80h
	mov	bx,offset log2
	call	poly
	call	savf1
	pop	ax
	call	flta
	mov	bx,offset f1
	call	fad
	mov	bx,offset ln2
	jmp	fmu

log1:	jmp	zro

log2	db	9
	db	82h,94h,0eeh,0d8h
	db	84h,7dh,0aah,0a9h
	db	86h,0bfh,99h,7dh
	db	87h,28h,0e5h,7bh
	db	87h,0c0h,71h,8ah
	db	87h,14h,95h,6eh
	db	86h,0a0h,1eh,0b2h
	db	85h,02h,7ah,0adh
	db	83h,8dh,9dh,09h

;	FLN  (F: r1 -- r2 ) or ( r1 -- r2 )

	hdr	1,'FLN'
ffln:	call	ldop
	call	log
	jmp	svop

;	F**  (F: r1 -- r2 ) or ( r1 -- r2 )  fswap fln f* fexp

	hdr	1,'F**'
fsq:	call	docol
	dw	fswap,ffln
	dw	fstar,fexp
	dw	exit

	cseg

;	sin / cos

cos:	mov	bx,offset fpi2
	call	fad
sin:	or	al,al
	jnz	sin1
	ret

sin1:	cmp	al,80h+25
	jc	sin2
	jmp	ovf

sin2:	mov	bx,offset f2pi2
	call	fmu
	call	savf1
	call	flr
	or	al,al
	pushf
	jz	sin3
	call	savf2
sin3:	call	lodf1
	popf
	jz	sin4
	mov	bx,offset f2
	call	fsu
sin4:	mov	bx,offset sin9
	call	fsu
	pushf
	js	sin5
	mov	bx,offset sin8
	call	fsu
	js	sin5
	call	chs
sin5:	mov	bx,offset sin9
	call	fad
	popf
	js	sin6
	call	chs
sin6:	mov	bx,offset sin7
	jmp	polx

sin7	db	5
	db	86h,1eh,0d7h,0fbh
	db	87h,99h,26h,64h
	db	87h,23h,34h,58h
	db	86h,0a5h,5dh,0e1h
	db	83h,49h,0fh,0dbh

sin8    db	80h,0,0,0	; 0.5

sin9	db	7fh,0,0,0	; 0.25

fpi2	db	81h,49h,0fh,0dbh ; pi/2

f2pi2	db	7eh,22h,0f9h,83h ; 1/2pi

;	FSIN  (F: r1 -- r2 ) or ( r1 -- r2 )

	hdr	1,'FSIN'
fsinn:	call	ldop
	call	sin
	jmp	svop

;	FCOS  (F: r1 -- r2 ) or ( r1 -- r2 )

	hdr	1,'FCOS'
fcoss:	call	ldop
	call	cos
	jmp	svop

	cseg

;	atan

atan:	call	tstr
	jns	atan1
	call	chss		; make positive
atan1:	cmp	al,81h
	jc	atan2		; < 1

	mov	bx,offset atan4
	push	bx
	call	savf1
	mov	bx,offset fone
	call	lod
	mov	bx,offset f1
	call	fdi
atan2:	mov	bx,offset atan9
	call	fcmp
	js	atan3

	mov	bx,offset atan5
	push	bx
	call	savf1
	mov	bx,offset atan7
	call	fad
	mov	bx,offset f3
	call	stom
	call	lodf1
	mov	bx,offset atan6
	call	poly
	mov	bx,offset f3
	call	fdi
atan3:	mov	bx,offset atan8
	jmp	polx

atan4:	mov	bx,offset fpi2
	call	fsu
	jmp	chs

atan5:	mov	bx,offset atan10
	jmp	fad

atan6	db	2
atan7	db	81h,5dh,0b3h,0d7h
	db	81h,80h,0,0	; -1.0

atan8	db	4
	db	7eh,83h,35h,62h
	db	7eh,4ch,24h,50h
	db	7fh,0aah,0a9h,79h
	db	81h,0,0,0

atan9	db	7fh,09h,38h,0a3h
atan10	db	80h,06h,0ah,92h

;	FATAN  (F: r1 -- r2 ) or ( r1 -- r2 )

	hdr	1,'FATAN'
fatan:	call	ldop
	call	atan
	jmp	svop

;	PI  (F: -- r ) or ( -- r )

	hdr	1,'PI'
fpi:	call	dofcon
	db	82h,49h,0fh,0dbh	; pi

;	FRANDOM  (F: r1 -- r2 ) or ( r1 -- r2 )

	hdr	1,'FRANDOM'
rand:	call	ldop
	js	rand1			; neg = seed generator
	pushf
	mov	bx,offset rand5
	call	lod
	popf
	jz	rand2			; zero = return last value
	mov	bx,offset rand3		; pos = get next value
	call	fmu
	mov	bx,offset rand4
	call	fad
rand1:	mov	bx,offset acc3
	mov	ch,[bx]			; swap msb lsb
	mov	cl,[bx-1]
	mov	dh,[bx-2]
	mov	byte ptr [bx-3],80h	; make positive
	mov	dl,[bx-4]
	mov	byte ptr [bx-4],80h	; fix exponent
	call	npack			; normalise
	mov	bx,offset rand5
	call	stom
rand2:	jmp	svop

rand3	db	98h,35h,44h,7Ah
rand4	db	68h,28h,0B1h,46h
rand5	db	80h,31h,41h,59h		; seed

;	fpinit  ( -- )		max-precision set-precision fdp on

	hdr	x,'FPINIT'
fpini:	call	docol
	dw	mprec,setpr
	dw	fdp,on
	dw	exit

;	fident  ( -- )

	hdr	x,'FIDENT',,1
fiden:	call	docol
	dw	crr
	dw	pdotq
	db	fiden1-$-1
	db	'Software floating-point ('
	 if	fstack
	db	'separate'
	 else
	db	'common'
	 endif
	db	' stack)'
fiden1	dw	exit

	 if	not ldp		; F94 requires digit before decimal-point

;	fnumber  ( c-addr u -- flag )  ( F: -- [r] )
;                ( c-addr u -- [r] flag )
;				dup 1 > if over dup c@ [char] . < - c@
;				[char] . > >r 2dup s" E" caps search -rot
;				2drop r> and base @ 10 = and 0= while then
;				2drop 0 else >float then dup >r state?
;				and if postpone fliteral then r>

	hdr	x,'FNUMBER',,1
fnumb:	call	docol
	dw	dupp,one,great
	dw	zbran,fnumb1
	dw	over
	dw	dupp,cat
	dw	clit
	db	'.'
	dw	less,subb	; skip sign
	dw	cat
	dw	clit
	db	'.'
	dw	great		; digit?
	dw	tor
	dw	tdup		; scan 'E'
	dw	psqot
	dcs	'E'
	 if	ucase
	dw	caps
	 endif
	dw	sear
	dw	drot,tdrop
	dw	fromr,andd
	dw	base,at		; decimal base?
	dw	clit
	db	10
	dw	equal,andd
	dw	zequ
	dw	zbran,fnumb2
fnumb1	dw	tdrop,zero
	dw	bran,fnumb3
fnumb2	dw	tflt
fnumb3	dw	dupp,tor
	dw	stateq
	dw	andd
	dw	zbran,fnumb4
	dw	flite
fnumb4	dw	fromr
	dw	exit

	 else			; allow leading decimal-point

;	fnumber  ( c-addr u -- flag )  ( F: -- [r] )
;                ( c-addr u -- [r] flag )
;				2dup s" E" caps search -rot 2drop base @
;				10 = and if >float else 2drop 0 then dup >r
;				state? and if postpone fliteral then r>

	hdr	x,'FNUMBER',,1
fnumb:	call	docol
	dw	tdup		; scan 'E'
	dw	psqot
	dcs	'E'
	 if	ucase
	dw	caps
	 endif
	dw	sear
	dw	drot,tdrop
	dw	base,at		; decimal base?
	dw	clit
	db	10
	dw	equal,andd
	dw	zbran,fnumb2
fnumb1	dw	tflt
	dw	bran,fnumb3
fnumb2	dw	tdrop,zero
fnumb3	dw	dupp,tor
	dw	stateq
	dw	andd
	dw	zbran,fnumb4
	dw	flite
fnumb4	dw	fromr
	dw	exit

	 endif

	aseg

; 	( -- )			:noname ['] noop dup (cold5) ! (cold11) !
;				['] false (inte12) ! (nfps) off (nfpm) off
;				; remember

	hdr	x,'(-FP)',,1
fprun:	mov	ax,offset noop
	mov	cold5,ax		; INIT
	mov	cold11,ax		; INDENTIFY
	mov	ax,offset false
	mov	inte12,ax		; FNUMBER
	sub	ax,ax
	mov	nfps,ax
	mov	nfpm,ax
	nextt

fprun1	dw	0		; link
	dw	fprun		; xt

	endif	; float

topnfa	equ	lnk-horig	; nfa of top word in forth vocab
topxt	equ	cfadr		; xt  of top word in forth vocab

	cseg
initdp	equ	$

	aseg
initdps	equ	$

heads	segment	public
initdph	equ	$-horig
heads	ends

	cseg

; Move heads into place for .COM executable only.
; Assumes heads located entirely in DS segment.
; Code is run once then disabled.

;	MOVE-PATCH  ( -- )

movpat:	mov	es,hseg1		; ES = headers segment
	mov	cx,idph			; move heads
	mov	di,cx
	dec	di
	mov	si,di
	add	si,idps
	std
	rep	movsb
	cld
	mov	word ptr cldd6,0CF8Bh		; change 'MOV CX,DI'
	mov	word ptr cldd7,0F929h		; change 'SUB CX,DI'
	mov	word ptr cldd9,cold-cldd9-2	; patch myself out
	jmp	cold

main	ends

	end	start	; start address

;	End
