\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's
\ DESCRIPTION : The Famous Sieve of Eratosthanes
\ CATEGORY    : Benchmarks
\ AUTHOR      : Marcel Hendrix
\ LAST CHANGE : September 19, 1994, Coos Haak: Turnkey program
\ LAST CHANGE : October 5th, 1991 MHX
\ ----------------------------------------------------------------------



        MARKER -sieve


#100  CONSTANT #times
#8192 CONSTANT size

0 VALUE flags

: DO-PRIME      flags size 1 FILL
                0  size 0 DO flags I +
                             C@ IF I DUP +  3 +
                                   DUP  I +
                                    BEGIN  DUP size <
                                    WHILE  0 OVER flags + C!
                                           OVER +
                                    REPEAT
                                   2DROP 1+
                             THEN
                        LOOP ;


: PRIMES
                MS-DOS-IO HERE size ALLOT TO flags
                CR #times .DEC ." iterations."  TIMER-RESET
                0 #times 0 DO
                             DROP  DO-PRIME
                         LOOP
                CR .  ." primes found."
                GETTIME TIMESAVE 2@ D-
                #1000 #times M*/ <# # # # '.' HOLD #S #>
                CR TYPE ."  milliseconds per iteration. "
        ;

size RESERVE

TURNKEY PRIMES SIEVE

                            \ (* End of Source *) /
