\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's
\ DESCRIPTION : Disk access without critical error trap
\ CATEGORY    : MS-DOS
\ AUTHOR      : Coos Haak
\ LAST CHANGE : May 16, 1994, Coos Haak
\ ----------------------------------------------------------------------


        NEEDS -criterr

        ?DEF -disk [IF] -disk [THEN]

        MARKER -disk



privates

internal

code getdiskspace
                mov     dl, bl          \ copy drive number
                mov     ah, # $36
                int     $21
                cmp     ax, # -1
        0<> if
                push    dx              \ total clusters
                push    cx              \ bytes per cluster
                push    bx              \ available clusters
                push    ax              \ sectors per cluster
                xor     bx, bx          \ false flag
        else
                mov     bx, ax          \ true flag
        then
                next
end-code  private

create mydir    #64 allot       private

0 value drive   private

: prepare-label         ( -- )
        getdisk to drive                        \ get drive number
        get-directory throw mydir place         \ get directory name
        ;  private

: restore-label         ( -- )
        drive setdisk drop                      \ reset drive number
        mydir count set-directory throw         \ reset directory name
        ;  private

0 value no-label

: .label
        no-label
        if      exit
        then
        found-file bounds
        do      i c@ '.' <>                     \ type label without '.'
                if      i c@ emit
                then
        loop
        ;

: (label)
        s" \" set-directory throw               \ go to root
        $8 to find-attribute                    \ look for the label
        s" *.*" find-first-file
        dup to no-label
        if      ." Has no label" exit           \ did not work
        then
        ;  private

\ u1 is current value, u2 is maximum value
: bar       ( u1 u2 -- )
        c/l #40 - swap */ dup>r 0
        ?do     '' emit
        loop
        c/l #40 - r>
        ?do     '' emit
        loop
        ;  private

: print2        ( d -- )
        1 #1024 m*/ 2dup #4096. d<        \ decimal and in K's
        if      5 d.r ."  Kb"
        else    1 #1024 m*/ 5 d.r ."  Mb"
        then
        ;  private

: go2           ( u | -- )                      \ input drive or nothing
        depth 0=
        if      0                               \ defaults to current drive
        then
        dup
        if      dup '@' + emit
        else    getdisk 'A' + emit
        then
        ':' emit
        prepare-label
        dup 1- dup 0<
        if      drop drive                      \ 0: use current drive
        then
        setdisk drop
        ['] (label) {{ catch }}                 \ type the label
                ( not yet good: types the label of non-existing drives! )
        restore-label
        if      ." Is not available." exit      \ no disk
        then
        {{ getdiskspace }}
        if      ." Is not available." exit
        then
        .label
        local /clu local free local /sec local total
        push base decimal
        #16 out - spaces
        total free - total bar
        total free - /sec /clu * um* print2 ."  of"
        total /sec /clu * um* print2
        pop base
        ;

deprive

: help
        ." Show info about disks."
        cr
        cr ." DISK [[d:]..] [/?] [-?]"
        cr
    ;

: main
        ms-dos-io
        $80 count set-source
        bl word c@ 0=
        if      0 go2 cr exit
        then
        begin   here char+ c@ dup '-' = swap '/' = or
                if      here 2 chars + c@ '?' =
                        if      help exit
                        then
                then
                here 2 chars + c@ ':' =
                if      here char+ c@ >upc dup 'A' 'Z' 1+ within
                        if      '@' - go2 cr
                        else    drop
                        then
                then
                bl word c@ 0=
        until
    ;

forth

turnkey main disk

                            \ (* End of Source *) /
