\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Character file input and output 
\ CATEGORY    : Library for turnkey programs 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



variable mill   mill off

privates

variable counter-1      private
variable counter-2      private
variable kb     private

: show-1
        push base decimal
        ?at
        counter-1 incr counter-1 @ kb @ * 5 .r
        at-xy 
        pop base
    ;  private

: show-2
        push base decimal
        ?at over 5 + over at-xy
        counter-2 incr counter-2 @ kb @ * 5 .r
        counter-1 @ counter-2 @ min #100 counter-1 @ counter-2 @ max */
        4 u.r '%' emit
        at-xy 
        pop base
    ;  private

variable input  private
variable output private
variable read-in        private

variable inptr  private
variable outptr private
variable /buf   private

variable outbuffer      private
variable inbuffer       private

: flush-buffer
        mill @
        if      show-2
        then
        outbuffer @ outptr @ output @ write-file throw outptr off
    ;  private

: getch         ( -- char | true )
        read-in @ inptr @ =
        if      mill @
                if      show-1
                then
                inptr off
                inbuffer @ /buf @ input @ read-file throw
                dup read-in ! 0= ?dup
                if      exit
                then
        then
        inbuffer @ inptr @ + c@ inptr incr
    ;

\ Open file with name c-addr u
\ Return n1 time, n2 date and ud filesize.
: openr         ( c-addr u -- n1 n2 ud )
        unused u2/ $100 - #1024 / dup kb ! #1024 * /buf !
        here inbuffer ! /buf @ allot
        counter-1 off inptr off read-in off
        r/o bin open-file throw input !
        input @ get-file-time throw
        input @ file-size throw
    ;

: closer        ( -- )
        input @ close-file throw
    ;

: putch         ( char -- )
        outptr @ /buf @ =
        if      flush-buffer
        then
        outbuffer @ outptr @ + c! outptr incr
    ;

\ Open file with name c-addr u
: openw         ( c-addr u -- )
        here outbuffer ! /buf @ allot
        counter-2 off outptr off
        w/o bin create-file throw output !
    ;

\ Set n1 time, n2 date and close the file
: closew        ( n1 n2 -- )
        flush-buffer
        output @ set-file-time throw
        output @ close-file throw
    ;

deprive
                            \ (* End of Source *) /
