\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's
\ DESCRIPTION : Load temporary programs (ASSEMBLER) high
\ CATEGORY    : Standard Programs
\ AUTHOR      : Coos Haak
\ LAST CHANGE : May 31, 1994, Coos Haak
\ ----------------------------------------------------------------------



        MARKER -loadhigh


DOC
    This is a method for compiling a temporary dictionary and forget
    it later. Mostly used to load the ASSEMBLER: generate some CODE
    definitions and throw the ASSEMBLER wordlist away to keep the
    program small.
    An other example is to load a file with new compiler structures
    that consist of a novel combination of IF WHILE and the like to
    build your own CASE statements out of these words. When the
    compilation is finished, you may throw the new compiler away.
ENDDOC

privates

0 value old-link                        private \ Save some info
0 value new-link                        private
0 value old-voc-link                    private
0 value old-mess-link                   private

internal

\G Skip leading space delimiters. Parse name delimited by a space.
\G Allocate temporary space at the top of the dictionary and compile
\G the library name in that space. When this word has been executed,
\G the dictionary space pointers have the same value as before the
\G execution, with the difference that the words in the loaded
\G library are known to the Forth system.
\G See also: DISPOSE MARK
: LOADHIGH      ( "name" -- )                           \ LOADHIGH
        last @ to old-link
        voc-link to old-voc-link
        mess-link to old-mess-link
        here >r
        lhere >r
        hhere >r
        limit #4600 - to dp                     \ Values are for the assembler
        llimit #4100 - to ldp                   \  in 386 mode, probably the
        hlimit #6600 - to hdp                   \  longest (temporary) program
        needs                                   \ Perform NEEDS
        r> to hdp
        r> to ldp
        r> to dp
        ;

\G Skip leading space delimiters. Parse name delimited by a space.
\G Find name. Name is the first word compiled after loading a file
\G with LOADHIGH .
\G See also: DISPOSE LOADHIGH
: MARK          ( "name" -- )                           \ LOADHIGH
        ' >head to new-link
        ;

\G Reclaim the temporary space where the file loaded with LOADHIGH
\G was compiled. All the words loaded with LOADHIGH are no longer
\G available to the Forth system. Be sure not to use references to
\G the words in that file.
\G See also: LOADHIGH MARK
: DISPOSE       ( -- )                                  \ LOADHIGH
        old-link new-link h!
        old-voc-link to voc-link
        old-mess-link to mess-link
        ;

forth

deprive


                            \ (* End of Source *) /
