\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's
\ DESCRIPTION : Online Help
\ CATEGORY    : Standard Utilities
\ AUTHORS     : Erwin Dondorp, Willem Ouwerkerk, Marcel Hendrix
\               Copyright 1991 1992 1993 Dutch Forth Workshop
\ PINCHER     : Coos Haak, Copyleft 1994 Dutch Forth Users Group
\ CREATED     : September 07, 1994, Coos Haak
\ ----------------------------------------------------------------------



        NEEDS -dvalues


        MARKER -help


        PRIVATES

 #14 constant passes                    private \ lb(filesize)-5
#134 constant linelen                   private \ Assumed maximum line length

0 value handle                          private \ Keep the file handle
0. dvalue filelen                       private \ Keep the length of the file
0. dvalue filepos                       private \ Keep file position
0. dvalue increment                     private \ Keep size of partition
0 value eof?                            private \ Flag for end of file
0 value anywhere?                       private \ Found in any file

0 value line-counter                    private \ Count printed lines

: reset-counter     ( -- )
        l/scr 1- to line-counter                \ Fresh display
    ;  private

: cr?               ( -- flag )
        cr -1 +to line-counter
        line-counter
        if      false                           \ Not yet at end of screen
        else    reset-counter ?at               \ New display 
                ." Press a key to continue"     \ Message
                key ^[ =                        \ Escape pressed ?
                -rot at-xy eol                  \ Clear whole line
        then
    ;  private

create linebuf                          private \ Buffer for line
    here linelen char+ dup allot erase

create wordbuf                          private \ Buffer for word
    here linelen char+ dup allot erase

: reposition    ( d -- )                        \ Reposition the file
        handle reposition-file throw
    ;  private

: nextline      ( -- )                          \ Read another line
        linebuf char+ dup wordbuf c@ 1+ blank   \ Clear somewhat
        linelen handle read-line throw          \ read the line
        invert to eof?                          \ Signal end of file
        linebuf c!                              \ Keep length
    ;  private

: keyword?      ( -- flag )                     \ Is this a keyword
        linebuf count 0<> swap c@ bl <> and     \ Not empty and no space
    ;  private

: get-keyword   ( "ccc" -- )                    \ Read keyword
        bl parse-word wordbuf place             \ Copy string
        bl wordbuf count + c!                   \ Put a space at the end
        wordbuf c@ 0= abort" Use: HELP <word>"  \ No null string
    ;  private

: find-keyword  ( -- )                          \ Read lines until a keyword
        begin   nextline eof?
                if      exit
                then
                keyword?
        until
    ;  private

: next-partition                                \ Go a new part of the file
        increment +to filepos
        filepos reposition
    ;  private

: test          ( -- flag )                     \ Compare the strings
        linebuf char+                           \ Address
        wordbuf c@ linelen min 1+               \ Length
        wordbuf count 1+                        \ Addres+length
        compare-uppercase                       \ Compare, ignoring case
    ;  private

: scan-keyword  ( -- )                          \ Read lines till word found
        begin   nextline eof?
                if  exit
                then
                keyword? test 0> and
                if  filelen reposition          \ Go to end of file
                then
                keyword? test 0= and
        until
    ;  private

: search-file   ( -- )                          \ Search binary in the file
        passes 0
        do      filepos increment d+ reposition \ Middle of current block
                nextline                       \ Look for the next full line
                eof?
                if      unloop exit             \ Not found
                then
                find-keyword
                case test
                    0 of leave          endof   \ Found!
                   -1 of next-partition endof   \ Too less, next partition
                    1 of                endof   \ Too great, go back
                endcase
                increment 1 2 m*/ to increment  \ Cut partition in half
        loop
        filepos reposition                      \ Start of partition
        filepos d0= invert                      \ Not at start of file
        if      nextline
        then
        scan-keyword
    ;  private

: print-keyword     ( -- )
        cr?
        if      exit                            \ User break
        then
        ." File: " found-file type              \ Type current filename
        begin   cr?                             \ User break
                if      exit
                then
                linebuf count c/l 1- min type   \ Limit line to screen width
                nextline                        \ Read another line
                eof? invert                     \ While not at end
        while   linebuf c@ 0=                   \ And no empty line
        until   then
        cr? drop true to anywhere?              \ Signal at least one found
    ;  private

: open-helpfile     ( c-addr u -- )
        r/o open-file throw to handle           \ Open the file
        handle file-size throw to filelen       \ Keep size
        filelen 1 2 m*/ to increment            \ Calculate size of partition
        clear filepos                           \ Start at the middle
    ;  private

\G Skip leading space delimiters. Parse name delimited by a space.
\G Look up name in the files with extension given in HEXT$ in the
\G directory given by HELPPATH and display the description of name.
\G As a binary search on the sorted file is performed, only one
\G descripition per file is displayed. When a full screen is
\G displayed, wait for the user to press any key, escape stops.
\G Otherwise convert name to a number (the prefixes % $ # & etc. are
\G permitted) and display its type and decimal value and the
\G character if it can be displayed or display the exception message
\G if it is defined for the number.
: HELP          ( "name" -- )                   \ HELP
        reset-counter                           \ Fresh display
        get-keyword clear anywhere?             \ Get word and reset found flag
        helppath count set-directory throw      \ Go to help directory
        s" *.hlp" find-first-file throw         \ Search for any matching file
        begin   found-file open-helpfile        \ Open the file
                search-file                     \ Look the item up
                eof? invert                     \ Stop at the end
                if      print-keyword           \ Type the item
                then
                handle close-file throw         \ Close the file
                find-next-file                  \ And try another time
        until
        current-directory count set-directory   \ Reset the directory
        throw
        anywhere? invert
        if      parsed-word number? dup 0=
                if      drop cr ." Word " wordbuf count type ."  not found. "
                        cr exit
                then
                push base decimal
                cr parsed-word type ."  is the " 1 =
                if      ." single precision decimal number " dup .
                        dup bl $80 within
                        if      cr ." Or the character '" emit ''' emit
                        else    dup bl u<
                                if      cr ." Or the control character ^"
                                        '@' or emit
                                else    [ internal ] findmessage [ forth ]
                                        if      cr ." Or error message: "
                                                '"' emit err$ count type '"' emit
                                        then
                                then
                        then
[ ?def -fixed ] [if]
                else    floating?
                        if      ." fixed point number " f.
                        else    ." double precision decimal number " d.
                        then
[else]
                else    ." double precision decimal number " d.
[then]
                then
                pop base cr
        then
    ;

        DEPRIVE

                            \ (* End of Source *) /
