\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Critical error handling 
\ CATEGORY    : Programming 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        NEEDS -assembler
        NEEDS -intvec


        MARKER -criterr



DOC
   Temporary switch off the critical error handler of MS-DOS.
   Use critical sections between {{ and }} .
   Use them carefully, as you will probably know.

   {{    starts a critical error section.
   }}    end a critical error section.
ENDDOC


privates

$24 intvec err.int                      private \ the interrupt handler

code my_crit_error                              \ my handler
                xor     al, al
                iret
end-code  private

\G Redirect the DOS critical error handler to a harmless routine.
\G Use this word only temporary to perform dangerous functions.
: {{            ( -- )                          \ CRITERR
        ['] my_crit_error to err.int
        ;  compile-only

\G Restore the redirection of the DOS critical error handler. Use
\G this word as soon as possible after {{ .
: }}            ( -- )                          \ CRITERR
        clear err.int
        ;  compile-only

deprive

                            \ (* End of Source *) /
