\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Reverse numbers 
\ CATEGORY    : Games 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        MARKER -reverse

DOC
   See: Forth Dimensions III-5, page 152
ENDDOC


variable beurten

: array
        create  cells allot
        does>
        []cell cell- ;

9 array rij

: init
        9 1+ 1
        do      i dup rij !
        loop ;

: drukaf
        cr ." De lijst is nu:" cr 10 1
        do      i 3 .r
        loop
        cr 9 1+ 1
        do      i rij @ 3 .r
        loop
        cr ;

: schudden
        1 9
        do      i choose 1+ i rij @ over rij @ i rij ! swap rij !
        -1 +loop ;

: invoer
        begin   ." Hoeveel omdraaien? " key dup ':' '2' within
        while   drop ." Alleen cijfers groter dan een invoeren!" cr
        repeat
        '0' - ;

: draaien
        dup 2/ 1+ 1
        do      dup i - 1+ dup rij @ swap i rij @ swap rij ! i rij !
        loop
        drop ;

: testen
        true 10 1
        do      i dup rij @ = and
        loop ;

: go
        init
        begin   schudden beurten off
                begin   ?at drukaf invoer -rot at-xy dup
                        if      draaien beurten incr testen
                        else    true
                        then
                until
                drukaf ." Je hebt er " beurten @ . ." beurten over gedaan." cr
                ." Nog eens ?[J,n]" key >upc 'N' = cr
        until ;


: .help
        CR CR ."      Type 'GO' for the game." CR
        ;

.help

                            \ (* End of Source *) /
