\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : ?????????? 
\ CATEGORY    : Standard Programs 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : September 19, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -log


        ?DEF -mkpilot [IF] -mkpilot [THEN]


        MARKER -mkpilot


        IN pilot

s" pilot.log" logfile place

variable log?       log? off

: what
        cr ." What do you mean with " parsed-word type '?' emit
        ;

wordlist constant pilot-help

pilot-help set-current

: bye
        cr ." Leave the Pilot program."
    ;

: dir
        cr ." Show the Pilot programs."
    ;

: list
        cr ." List the current program, ESC stops."
    ;

: logoff
        cr ." Switch the logfile on."
    ;

: logon
        cr ." Switch the logfile off."
    ;

: new
        cr ." Clear the program space."
    ;

: run
        cr ." Run the current program."
    ;

: troff
        cr ." Switch the line tracing on."
    ;

: tron
        cr ." Switch the line tracing off."
    ;

: load
        cr ." Load a Pilot program, needs name."
    ;

forth definitions

wordlist constant pilot

pilot dup set-context set-current

' load alias load
' run alias run
' new alias new
' list alias list
' bye alias bye

: logon
        open-log log? on
    ;

: logoff
        close-log log? off
    ;

: tron
        trace on
    ;

: troff
        trace off
    ;

: dir
        s" *.pil" find-first-file throw
        begin   cr 4 spaces found-file type
                find-next-file
        until
    ;

: help
        bl parse-word here pack count upper here c@
        if      here count pilot-help search-wordlist
                if      execute
                else    what
                then
                exit
        then
        cr ."  Type on of the following after HELP"
        cr ."     BYE     DIR     HELP    LIST    LOAD    LOGON   LOGOFF  "
        cr ."     NEW     RUN     TROFF   TRON"
    ;

forth definitions

#80 constant /regel

create inputbuffer  here /regel dup allot

: main
        cr ." Pilot by Coos Haak, written in CHForth " version 0
        <# # '.' hold # '.' hold # #> type
        begin   cr trace @
                if      ." [T]"
                then
                ." #"
                inputbuffer dup /regel accept set-source
                bl word count 2dup upper pilot search-wordlist
                if      ['] execute catch ?dup
                        if      [ internal ] findmessage [ forth ]
                                cr err$ count type
                        then
                else    here c@
                        if      what
                        then
                then
        again
    ;

statoff
signon off

                            \ (* End of Source *) /
