\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Date calculations 
\ CATEGORY    : Astronomy 
\ AUTHOR      : Jean Meeus , Astronmical formulae for calculators 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        NEEDS -stack

        ?DEF -meeus [IF] -meeus [THEN]

        MARKER -meeus


?undef \G [if]

' \ alias \g    immediate

[then]

privates

?undef u*/ [if]

\G Unsigned multiply followed by unsigned divide. Uses double
\G precision internally.
: U*/           ( u1 u2 u3 -- u4 )      \ MEEUS "u-star-slash"
        >s um* s> um/mod nip
        ;

[then]

\G Converts dates after March 1, 1976 to a short Julian date.
: DAY>JUL       ( day month year -- jd )        \ MEEUS "day-to-julian"
        1976 - local jaar local maand local dag
        maand 3 <
        if      12 +to maand
                -1 +to jaar
        then
        jaar 100 /
        2 over - swap 4 / +
        jaar 36525 100 u*/
        maand 1+ 3060 100 u*/ +
        dag + + ;

true [if]

: $"            ( ccc<"> -- addr )              \ compile a string
        here ",
        ;  private

: []type        ( x addr -- )                   \ type string from array
        []cell @ count type
        ;  private

[else]

: $"            ( ccc<"> -- addr )              \ compile a string
        here lhere , s",
        ;  private

: []type        ( x addr -- )                   \ type string from array
        []cell @ @ typestring
        ;  private

[then]

$" zaterdag"
$" vrijdag"
$" donderdag"
$" woensdag"
$" dinsdag"
$" maandag"
$" zondag"
create dagen$   , , , , , , ,   private

$" december"
$" november"
$" oktober"
$" september"
$" augustus"
$" juli"
$" juni"
$" mei"
$" april"
$" maart"
$" februari"
$" januari"
create maanden$ , , , , , , , , , , , , private

$" vijf voor "
$" tien voor "
$" kwart voor "
$" tien over half "
$" vijf over half "
$" half "
$" vijf voor half "
$" tien voor half "
$" kwart over "
$" tien over "
$" vijf over "
$" "
create stapjes , , , , , , , , , , , , private

$" twaalf"
$" elf"
$" tien"
$" negen"
$" acht"
$" zeven"
$" zes"
$" vijf"
$" vier"
$" drie"
$" twee"
$" een"
create cijfers , , , , , , , , , , , , private

\G Prints the time in Dutch.
: .TIJD         ( sec min hrs -- )      \ MEEUS "dot-tide"
        12 /mod locals| half uur min sec |
        min 5 / stapjes []type
        min 15 >
        if      uur
        else    uur 11 +
        then    12 mod cijfers []type
        min 5 / 0=
        if      ."  uur"
        then
        half
        if      uur 5 >
                if      ."  's avonds "
                else    ."  's middags "
                then
        else    uur 5 >
                if      ."  's morgens "
                else    ."  's nachts "
                then
        then
        ;

\G A testroutine for time routines.
: KLOK          ( hrs -- )              \ MEEUS
        #24 circular local uur 60 0
        do      cr uur 2 .r space i 2 .r space 0 i uur .tijd
        5 +loop
        ;

\G Prints day of week in Dutch.
: .DAG          ( day-of-week -- )      \ MEEUS "dot-dag"
        2 + 7 mod dagen$ []type space
        ;

\G Prints name of month in Dutch.
: .MAAND        ( month -- )            \ MEEUS "dot-maand"
        1- 12 mod maanden$ []type space
        ;

: 3dup          ( x1 x2 x3 -- x1 x2 x3 x1 x2 x3 )
        2 pick 2 pick 2 pick
        ;  private

\G Prints a full date in Dutch format.
: .DATUM        ( d m y -- )            \ MEEUS "dot-datum"
        3dup day>jul .dag rot . swap .maand .
        ;

\G Prints the current time in Dutch.
: NU            ( -- )                  \ MEEUS
        cr ." Het is " date day>jul .dag date rot . swap .maand .
        ." en de juiste tijd is " (time) drop dup 2 type
        ."  uur en " 3 + 2 type ."  minuten" cr
        ." Ongeveer " time .tijd
        cr
        ;

deprive

nu

                            \ (* End of Source *) /
