\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Calculation of Easter Sunday 
\ CATEGORY    : Examples 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        MARKER -easter



DOC
  Jean Meeus, Astronomy for calculators

   year EASTER    prints the Easter Sunday.
   cent CENTURY   prints hunderd years.
   start end STATISTICS show on what days Easter falls.
   day month year-1 year-2 WHEN shows probability of Easter Sunday
                                on that date.
ENDDOC


: (pasen)               ( year -- flag day )    -- March=true
        0 0 0 0 locals| a b h l jaar |
        jaar 1583 > invert abort" Gregorian calender only"
        jaar 19 mod to a jaar 100 /mod to b
        b 4 /mod
        b 8 + 25 /
        negate b + 1+ 3 /
        + negate
        b + a 19 * + 15 + 30 mod
        to h
        swap
        4 /mod
        2* swap -
        h - 32 + over + +
        7 mod
        to l
        a h 11 * + l 22 * + 451 /
        -7 * h + l + 114 + 31 /mod
        3 = swap 1+ ;

: easter
        dup>r (pasen) cr ." Easter Sunday falls on " swap
        if      ." March "
        else    ." April "
        then
        2 .r ." , " r> . ;

: century
        100 * 1+ dup 100 - cr
        do      out #10 + c/l >
                if      cr
                then
                swap
                if      ." Mar "
                else    ." Apr "
                then
                i (pasen) 2 .r
                i 5 .r 5 spaces key? ?leave
        loop ;

31 2* constant dagen

create reeks    dagen cells allot

: statistics
        reeks dagen cells erase
        1+ swap
        do      i (pasen) swap 0=
                if      31 +
                then
                reeks []cell incr
        loop
        cr ." March:" cr 32 22
        do      i 3 .r
        loop
        cr 32 22
        do      i reeks []cell @ 3 .r
        loop
        cr ." April:" cr 26 1
        do      i 3 .r
        loop
        cr 26 1
        do      i 31 + reeks []cell @ 3 .r
        loop
        cr ;

: when          ( dag maand van tot -- )
        locals| tot van maand dag |
        tot 1+ van
        do      i (pasen) dag =
                if      maand 3 = =
                        if      i easter
                        then
                else    drop
                then
        loop ;


                            \ (* End of Source *) /
